package lib.utils;

import java.util.List;

public interface SanityCheckable {
	default public void sanityCheck() {
		//Do nothing.
	}
	
	default public List<? extends SanityCheckable> getOwnedComponents() {
		return null;
	}
	
	default public void deepSanityCheck() {
		sanityCheck();
		
		List<? extends SanityCheckable> ownedComponents = getOwnedComponents();
		
		if (ownedComponents != null) {
			for (SanityCheckable c : ownedComponents) {
				c.deepSanityCheck();
			}
		}
	}
}
