package lib.utils;

import java.util.*;
import java.util.function.Predicate;

public class Permutations {
	public static <K, V> Set<Map<K, V>> getPermutations(Map<K, Set<V>> valuePerKey, Predicate<V> filter, boolean oneValuePerKey) {
		Set<Map<K, V>> result = new HashSet<Map<K, V>>();
		addPermutations(valuePerKey, new HashMap<K, V>(), new ArrayList<K>(valuePerKey.keySet()), 0, filter, result, oneValuePerKey);
		return result;
	}
	
	public static <K, EK, EV> Set<Map<K, Map.Entry<EK, EV>>> getMapPermutations(Map<K, Map<EK, EV>> valuePerKey, Predicate<Map.Entry<EK, EV>> filter, boolean oneValuePerKey) {
		Map<K, Set<Map.Entry<EK, EV>>> temp = new HashMap<K, Set<Map.Entry<EK, EV>>>();
		
		for (Map.Entry<K, Map<EK, EV>> entry : valuePerKey.entrySet()) {
			temp.put(entry.getKey(), entry.getValue().entrySet());
		}
		
		return getPermutations(temp, filter, oneValuePerKey);
	}
	
	private static <K, V> void addPermutations(Map<K, Set<V>> setPerKey, Map<K, V> soFar, List<K> orderedKeys, int keyIndex, Predicate<V> filter, Set<Map<K, V>> destination, boolean oneValuePerKey) {
		if (keyIndex < orderedKeys.size()) {
			K key = orderedKeys.get(keyIndex);
			
			for (V value : setPerKey.get(key)) {
				if (filter.test(value)) {
					Map<K, V> newSoFar = new HashMap<K, V>(soFar);
					newSoFar.put(key, value);
					
					addPermutations(setPerKey, newSoFar, orderedKeys, keyIndex + 1, filter, destination, oneValuePerKey);
				}
			}
			
			if (!oneValuePerKey) {
				addPermutations(setPerKey, new HashMap<K, V>(soFar), orderedKeys, keyIndex + 1, filter, destination, oneValuePerKey);
			}
		} else {
			destination.add(soFar);
		}
	}
}
