package lib.utils;

import java.util.*;

public class LOD {
	public final boolean isAbbreviated;
	public final boolean includesLineage;
	public final boolean includesDir;
	public final boolean includesType;
	public final String sep;
	
	private LOD(boolean isAbbreviated, boolean includesLineage, boolean includesDir, boolean includesType, String sep) {
		this.isAbbreviated = isAbbreviated;
		this.includesLineage = includesLineage;
		this.includesDir = includesDir;
		this.includesType = includesType;
		this.sep = sep;
	}
	
	public final static LOD MINIMAL = new LOD(true, false, false, false, ",");
	public final static LOD FRIENDLY = new LOD(false, false, false, false, ", ");
	public final static LOD BALANCED = new LOD(true, true, false, false, ", ");
	public final static LOD FULL = new LOD(false, true, true, true, ", ");
	
	public final LOD abbr() {
		return new LOD(true, includesLineage, includesDir, includesType, sep);
	}
	
	public final LOD full() {
		return new LOD(false, includesLineage, includesDir, includesType, sep);
	}
	
	public final LOD lineage() {
		return new LOD(isAbbreviated, true, includesDir, includesType, sep);
	}
	
	public final LOD core() {
		return new LOD(isAbbreviated, false, includesDir, includesType, sep);
	}
	
	public final LOD newlineSep() {
		return new LOD(isAbbreviated, includesLineage, includesDir, includesType, "\n");
	}
	
	public final LOD cSep() {
		return new LOD(isAbbreviated, includesLineage, includesDir, includesType, ",");
	}
	
	public final LOD commaSep() {
		return new LOD(isAbbreviated, includesLineage, includesDir, includesType, ", ");
	}
	
	public final LOD plusSep() {
		return new LOD(isAbbreviated, includesLineage, includesDir, includesType, "\n+\n");
	}
	
	public final String abbreviate(String text) {
		return isAbbreviated ? abbreviate(text, "_") : text;
	}
	
	public final String abbreviate(String text, String cutOff) {
		if (!isAbbreviated) {
			return text;
		}
		
		int index = text.indexOf(cutOff);
		
		if (index > 0) {
			return text.substring(0, index);
		}
		
		return text;
	}
	
	public final String textify(Collection<? extends Textifiable> source) {
		if (source.size() > 0) {
			Iterator<? extends Textifiable> q = source.iterator();
			String result = q.next().textify(this);
			
			while (q.hasNext()) {
				result += sep + q.next().textify(this);
			}
			
			return result;
		}
		
		return "";
	}
	
	public final String textifyUnique(Collection<? extends Textifiable> source) {
		if (source.size() > 0) {
			Set<String> texts = new HashSet<String>();
			Iterator<? extends Textifiable> q1 = source.iterator();
			texts.add(q1.next().textify(this));
			
			while (q1.hasNext()) {
				texts.add(q1.next().textify(this));
			}
			
			Iterator<String> q2 = texts.iterator();
			String result = q2.next();
			
			while (q2.hasNext()) {
				result += sep + q2.next();
			}
			
			return result;
		}
		
		return "";
	}
	
	public static String toDot(String source) {
		return source.replace("\n", "\\n").replace("\"", "\\\"");
	}
	
	public final String toDot(Textifiable source) {
		return toDot(source.textify(this));
	}
	
	public final String toDot(Collection<? extends Textifiable> source) {
		return toDot(textify(source));
	}
	
	public final String toDotUnique(Collection<? extends Textifiable> source) {
		return toDot(textifyUnique(source));
	}
}
