package lib.utils;

import java.util.*;
import java.util.function.Predicate;

public class FilterUtils {
	public static <S, T extends S> List<T> filter(List<S> pts, Class<T> clz, Predicate<T> pred) {
		List<T> result = new ArrayList<T>();
		
		for (S pt : pts) {
			if (clz.isAssignableFrom(pt.getClass())) {
				if (pred == null || pred.test(clz.cast(pt))) {
					result.add(clz.cast(pt));
				}
			}
		}
		
		return Collections.unmodifiableList(result);
	}
	
	public static <S, T extends S> Set<T> filter(Set<S> pts, Class<T> clz, Predicate<T> pred) {
		Set<T> result = new HashSet<T>();
		
		for (S pt : pts) {
			if (clz.isAssignableFrom(pt.getClass())) {
				if (pred == null || pred.test(clz.cast(pt))) {
					result.add(clz.cast(pt));
				}
			}
		}
		
		return Collections.unmodifiableSet(result);
	}
}
