package lib.utils;

import java.lang.reflect.*;

@SuppressWarnings("serial")
public class FieldReflectionException extends ReflectionException {
	public FieldReflectionException(Field field, String msg) {
		super(getFieldDescription(field), new Exception(msg));
	}
	
	public FieldReflectionException(Field field, Throwable cause) {
		super(getFieldDescription(field), cause);
	}
	
	private static String getFieldDescription(Field f) {
		return "Reflection on field \"" + f.getName() + "\" of class \"" + f.getClass().getCanonicalName() + "\n failed!";
	}
}
