package lib.utils;

import java.util.*;

public interface Copyable extends Composable {
	public Copyables getCopyables();
	
	@Override
	public Copyable getOwner();
	
	@Override
	default public List<? extends Copyable> getOwnedComponents() {
		return getOwnedCopyables();
	}
	
	public void updateOwner(Copyables copyables);
	public List<? extends Copyable> getOwnedCopyables();
	public Copyable createCopy(Copyables copyables);
	void resolveRefsAfterCopy();
}
