package lib.utils;

import java.util.List;

public interface Composable {
	public Composable getOwner();
	public List<? extends Composable> getOwnedComponents();
	
	default public void connectComponents() {
		//Do nothing.
	}
	
	default public void sanityCheck() {
		//Do nothing.
	}
	
	default public void deepConnectComponents() {
		connectComponents();
		
		for (Composable c : getOwnedComponents()) {
			c.deepConnectComponents();
		}
	}
	
	default public void deepSanityCheck() {
		sanityCheck();
		
		for (Composable c : getOwnedComponents()) {
			c.deepSanityCheck();
		}
	}
	
	default public void print() {
		print(new PrefixedPrinter(System.out));
	}
	
	default public void print(PrefixedPrinter prefix) {
		List<? extends Composable> items = getOwnedComponents();
		prefix.println(toString());
		
		for (int index = 0; index < items.size(); index++) {
			prefix.indent(index, items.size() - 1);
			items.get(index).print(prefix);
			prefix.unindent();
		}
	}
}
