package lib.utils;

@SuppressWarnings("serial")
public class ClassReflectionException extends ReflectionException {
	public ClassReflectionException(Class<?> clz, String msg) {
		super(getClzDescription(clz), new Exception(msg));
	}
	
	public ClassReflectionException(Class<?> clz, Throwable cause) {
		super(getClzDescription(clz), cause);
	}
	
	private static String getClzDescription(Class<?> clz) {
		return "Reflection on class \"" + clz.getCanonicalName() + "\n failed!";
	}
}
