package lib.sim;

import java.util.*;

public class JavaSimClass {
	public static class Var<T> {
		private T value;
		public Var(T value) {
			this.value = value;
		}
		public Var(Var<T> source) {
			value = source.value;
		}
		public final T get() {
			return value;
		}
	}
	public static class In<T> {
		private T value;
		public In(T value) {
			this.value = value;
		}
		public In(In<T> source) {
			value = source.value;
		}
		public final T get() {
			return value;
		}
		public final void set(T value) {
			this.value = value;
		}
	}
	public static class Out<T> {
		private T value;
		public Out(T value) {
			this.value = value;
		}
		public Out(Out<T> source) {
			value = source.value;
		}
		public final T get() {
			return value;
		}
	}
	private static <T> List<List<T>> getAllOrderings(List<T> elems) {
		List<List<T>> result = new ArrayList<List<T>>();
		addAllOrderings(elems, new ArrayList<T>(), result);
		return result;
	}
	private static <T> void addAllOrderings(List<T> elems, List<T> soFar, List<List<T>> dest) {
		if (soFar.size() < elems.size()) {
			for (T elem : elems) {
				if (!soFar.contains(elem)) {
					List<T> newSoFar = new ArrayList<T>(soFar);
					newSoFar.add(elem);
					addAllOrderings(elems, newSoFar, dest);
				}
			}
		} else {
			dest.add(soFar);
		}
	}
	private static <T> List<List<T>> getAllPermutations(List<List<T>> elems) {
		List<List<T>> result = new ArrayList<List<T>>();
		addAllPermutations(elems, new ArrayList<T>(), result);
		return result;
	}
	private static <T> void addAllPermutations(List<List<T>> elems, List<T> soFar, List<List<T>> dest) {
		if (soFar.size() < elems.size()) {
			for (T elem : elems.get(soFar.size())) {
				List<T> newSoFar = new ArrayList<T>(soFar);
				newSoFar.add(elem);
				addAllPermutations(elems, newSoFar, dest);
			}
		} else {
			dest.add(soFar);
		}
	}
	public static class CompState_SMI {
		private final Set<String> vertices;
		public final In<Boolean> T18_Data_Update_In_Initialising;
		public final In<Boolean> T6_Update_process_aborted;
		public final Out<String> DT10_State;
		public final Out<Boolean> T10_Operation_State;
		public final In<Boolean> T2_Preload_item_i_started;
		public final Out<Boolean> T5_Data_installation_item_i_finished;
		public final Out<Boolean> T9_Activation_State;
		public final Out<String> DT9_State;
		public final Out<String> DT8_State;
		public final In<Boolean> T12_Data_Update_After_Operational;
		public final In<Integer> D4_Con_tmax_Response_MDM;
		public final In<Boolean> D16_SMI_Connection_established;
		public final In<Boolean> T1_Maintaining_finished;
		public final Out<Boolean> T15_Data_Update_Finished;
		public final In<Boolean> T3_Preload_item_i_finished;
		public final In<Boolean> T13_Data_Update_Stop;
		public final In<Boolean> T17_Data_Up_To_Date;
		public final In<Boolean> T4_Activating_item_i;
		public final Out<Boolean> T8_Preload_State;
		public final In<Boolean> T11_Data_Update_After_Booting;
		public final In<Integer> D1_Con_t_Ini_Def_Delay;
		public final Out<Boolean> T14_Data_installation_item_i;
		public CompState_SMI() {
			vertices = new HashSet<String>();
			T18_Data_Update_In_Initialising = new In<Boolean>(false);
			T6_Update_process_aborted = new In<Boolean>(false);
			DT10_State = new Out<String>("");
			T10_Operation_State = new Out<Boolean>(false);
			T2_Preload_item_i_started = new In<Boolean>(false);
			T5_Data_installation_item_i_finished = new Out<Boolean>(false);
			T9_Activation_State = new Out<Boolean>(false);
			DT9_State = new Out<String>("");
			DT8_State = new Out<String>("");
			T12_Data_Update_After_Operational = new In<Boolean>(false);
			D4_Con_tmax_Response_MDM = new In<Integer>(0);
			D16_SMI_Connection_established = new In<Boolean>(false);
			T1_Maintaining_finished = new In<Boolean>(false);
			T15_Data_Update_Finished = new Out<Boolean>(false);
			T3_Preload_item_i_finished = new In<Boolean>(false);
			T13_Data_Update_Stop = new In<Boolean>(false);
			T17_Data_Up_To_Date = new In<Boolean>(false);
			T4_Activating_item_i = new In<Boolean>(false);
			T8_Preload_State = new Out<Boolean>(false);
			T11_Data_Update_After_Booting = new In<Boolean>(false);
			D1_Con_t_Ini_Def_Delay = new In<Integer>(0);
			T14_Data_installation_item_i = new Out<Boolean>(false);
		}
		public CompState_SMI copyFrom(CompState_SMI source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			T18_Data_Update_In_Initialising.value = source.T18_Data_Update_In_Initialising.value;
			T6_Update_process_aborted.value = source.T6_Update_process_aborted.value;
			DT10_State.value = source.DT10_State.value;
			T10_Operation_State.value = source.T10_Operation_State.value;
			T2_Preload_item_i_started.value = source.T2_Preload_item_i_started.value;
			T5_Data_installation_item_i_finished.value = source.T5_Data_installation_item_i_finished.value;
			T9_Activation_State.value = source.T9_Activation_State.value;
			DT9_State.value = source.DT9_State.value;
			DT8_State.value = source.DT8_State.value;
			T12_Data_Update_After_Operational.value = source.T12_Data_Update_After_Operational.value;
			D4_Con_tmax_Response_MDM.value = source.D4_Con_tmax_Response_MDM.value;
			D16_SMI_Connection_established.value = source.D16_SMI_Connection_established.value;
			T1_Maintaining_finished.value = source.T1_Maintaining_finished.value;
			T15_Data_Update_Finished.value = source.T15_Data_Update_Finished.value;
			T3_Preload_item_i_finished.value = source.T3_Preload_item_i_finished.value;
			T13_Data_Update_Stop.value = source.T13_Data_Update_Stop.value;
			T17_Data_Up_To_Date.value = source.T17_Data_Up_To_Date.value;
			T4_Activating_item_i.value = source.T4_Activating_item_i.value;
			T8_Preload_State.value = source.T8_Preload_State.value;
			T11_Data_Update_After_Booting.value = source.T11_Data_Update_After_Booting.value;
			D1_Con_t_Ini_Def_Delay.value = source.D1_Con_t_Ini_Def_Delay.value;
			T14_Data_installation_item_i.value = source.T14_Data_installation_item_i.value;
			return this;
		}
		public static Set<CompState_SMI> create() {
			return new HashSet<CompState_SMI>();
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
	}
	public static class CompState_SEC {
		private final Set<String> vertices;
		public final Var<Boolean> T7_Cd_PDI_Version_Check;
		public final In<String> D4_Con_Checksum_Data;
		public final Var<Boolean> T5_SCP_Connection_Established;
		public final Var<Boolean> T9_Status_Report_Completed;
		public final In<Boolean> T22_Content_Telegram_Error;
		public final Var<Boolean> T8_Cd_Initialisation_Request;
		public final In<Boolean> T7_Invalid_Or_Missing_Basic_Data;
		public final In<Boolean> T6_Data_Invalid;
		public final In<Boolean> T8_Data_Installation_Complete;
		public final In<Boolean> T2_Power_Off_Detected;
		public final Var<Boolean> T10_SCP_Connection_Terminated;
		public final In<Boolean> T30_Reset_Connection;
		public final In<Boolean> T11_Data_Transmission_Timeout;
		public final In<Boolean> T3_Reset;
		public final In<Boolean> T4_Booted;
		public final In<String> D3_Con_PDI_Version;
		public final Var<Boolean> T1_Ready_For_PDI_Connection;
		public final In<Boolean> D23_Con_Checksum_Data_Used;
		public final In<Boolean> T9_PDI_Connection_Established;
		public final In<Boolean> T1_Power_On_Detected;
		public final Var<String> DT7_PDI_Version;
		public final Var<Boolean> T18_Not_Ready_For_PDI_Connection;
		public final In<Boolean> T5_SIL_Not_Fulfilled;
		public final In<Boolean> T21_Formal_Telegram_Error;
		public final In<Boolean> T20_Protocol_Error;
		public final Var<String> D50_PDI_Connection_State;
		public final Var<Boolean> T14_Msg_Start_Initialisation;
		public final Var<Boolean> T12_Terminate_SCP_Connection;
		public final Var<Boolean> T6_Start_Status_Report;
		public final Var<Boolean> T17_PDI_Connection_Closed;
		public final Var<String> DT13b_Checksum_Data;
		public final Var<Boolean> T11_PDI_Connection_Established;
		public final Var<String> DT13a_Result;
		public final Var<Boolean> T13_Msg_PDI_Version_Check;
		public final Var<Boolean> T15_Msg_Initialisation_Completed;
		public CompState_SEC() {
			vertices = new HashSet<String>();
			T7_Cd_PDI_Version_Check = new Var<Boolean>(false);
			D4_Con_Checksum_Data = new In<String>("");
			T5_SCP_Connection_Established = new Var<Boolean>(false);
			T9_Status_Report_Completed = new Var<Boolean>(false);
			T22_Content_Telegram_Error = new In<Boolean>(false);
			T8_Cd_Initialisation_Request = new Var<Boolean>(false);
			T7_Invalid_Or_Missing_Basic_Data = new In<Boolean>(false);
			T6_Data_Invalid = new In<Boolean>(false);
			T8_Data_Installation_Complete = new In<Boolean>(false);
			T2_Power_Off_Detected = new In<Boolean>(false);
			T10_SCP_Connection_Terminated = new Var<Boolean>(false);
			T30_Reset_Connection = new In<Boolean>(false);
			T11_Data_Transmission_Timeout = new In<Boolean>(false);
			T3_Reset = new In<Boolean>(false);
			T4_Booted = new In<Boolean>(false);
			D3_Con_PDI_Version = new In<String>("");
			T1_Ready_For_PDI_Connection = new Var<Boolean>(false);
			D23_Con_Checksum_Data_Used = new In<Boolean>(false);
			T9_PDI_Connection_Established = new In<Boolean>(false);
			T1_Power_On_Detected = new In<Boolean>(false);
			DT7_PDI_Version = new Var<String>("");
			T18_Not_Ready_For_PDI_Connection = new Var<Boolean>(false);
			T5_SIL_Not_Fulfilled = new In<Boolean>(false);
			T21_Formal_Telegram_Error = new In<Boolean>(false);
			T20_Protocol_Error = new In<Boolean>(false);
			D50_PDI_Connection_State = new Var<String>("");
			T14_Msg_Start_Initialisation = new Var<Boolean>(false);
			T12_Terminate_SCP_Connection = new Var<Boolean>(false);
			T6_Start_Status_Report = new Var<Boolean>(false);
			T17_PDI_Connection_Closed = new Var<Boolean>(false);
			DT13b_Checksum_Data = new Var<String>("");
			T11_PDI_Connection_Established = new Var<Boolean>(false);
			DT13a_Result = new Var<String>("");
			T13_Msg_PDI_Version_Check = new Var<Boolean>(false);
			T15_Msg_Initialisation_Completed = new Var<Boolean>(false);
		}
		public CompState_SEC copyFrom(CompState_SEC source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			T7_Cd_PDI_Version_Check.value = source.T7_Cd_PDI_Version_Check.value;
			D4_Con_Checksum_Data.value = source.D4_Con_Checksum_Data.value;
			T5_SCP_Connection_Established.value = source.T5_SCP_Connection_Established.value;
			T9_Status_Report_Completed.value = source.T9_Status_Report_Completed.value;
			T22_Content_Telegram_Error.value = source.T22_Content_Telegram_Error.value;
			T8_Cd_Initialisation_Request.value = source.T8_Cd_Initialisation_Request.value;
			T7_Invalid_Or_Missing_Basic_Data.value = source.T7_Invalid_Or_Missing_Basic_Data.value;
			T6_Data_Invalid.value = source.T6_Data_Invalid.value;
			T8_Data_Installation_Complete.value = source.T8_Data_Installation_Complete.value;
			T2_Power_Off_Detected.value = source.T2_Power_Off_Detected.value;
			T10_SCP_Connection_Terminated.value = source.T10_SCP_Connection_Terminated.value;
			T30_Reset_Connection.value = source.T30_Reset_Connection.value;
			T11_Data_Transmission_Timeout.value = source.T11_Data_Transmission_Timeout.value;
			T3_Reset.value = source.T3_Reset.value;
			T4_Booted.value = source.T4_Booted.value;
			D3_Con_PDI_Version.value = source.D3_Con_PDI_Version.value;
			T1_Ready_For_PDI_Connection.value = source.T1_Ready_For_PDI_Connection.value;
			D23_Con_Checksum_Data_Used.value = source.D23_Con_Checksum_Data_Used.value;
			T9_PDI_Connection_Established.value = source.T9_PDI_Connection_Established.value;
			T1_Power_On_Detected.value = source.T1_Power_On_Detected.value;
			DT7_PDI_Version.value = source.DT7_PDI_Version.value;
			T18_Not_Ready_For_PDI_Connection.value = source.T18_Not_Ready_For_PDI_Connection.value;
			T5_SIL_Not_Fulfilled.value = source.T5_SIL_Not_Fulfilled.value;
			T21_Formal_Telegram_Error.value = source.T21_Formal_Telegram_Error.value;
			T20_Protocol_Error.value = source.T20_Protocol_Error.value;
			D50_PDI_Connection_State.value = source.D50_PDI_Connection_State.value;
			T14_Msg_Start_Initialisation.value = source.T14_Msg_Start_Initialisation.value;
			T12_Terminate_SCP_Connection.value = source.T12_Terminate_SCP_Connection.value;
			T6_Start_Status_Report.value = source.T6_Start_Status_Report.value;
			T17_PDI_Connection_Closed.value = source.T17_PDI_Connection_Closed.value;
			DT13b_Checksum_Data.value = source.DT13b_Checksum_Data.value;
			T11_PDI_Connection_Established.value = source.T11_PDI_Connection_Established.value;
			DT13a_Result.value = source.DT13a_Result.value;
			T13_Msg_PDI_Version_Check.value = source.T13_Msg_PDI_Version_Check.value;
			T15_Msg_Initialisation_Completed.value = source.T15_Msg_Initialisation_Completed.value;
			return this;
		}
		public static Set<CompState_SEC> create() {
			return new HashSet<CompState_SEC>(new CompState_SEC().enterState("SCI_EfeS_Sec_STD_1"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private void cOp1_init() {
			this.D50_PDI_Connection_State.value = "";
			this.T11_PDI_Connection_Established.value = Boolean.FALSE;
			this.T13_Msg_PDI_Version_Check.value = Boolean.FALSE;
			this.DT13a_Result.value = "";
			this.DT13b_Checksum_Data.value = "";
			this.T14_Msg_Start_Initialisation.value = Boolean.FALSE;
			this.T15_Msg_Initialisation_Completed.value = Boolean.FALSE;
			this.T12_Terminate_SCP_Connection.value = Boolean.FALSE;
			this.T17_PDI_Connection_Closed.value = Boolean.FALSE;
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T21_Formal_Telegram_Error.value) return false;
					return true;
				/* Source: READY_FOR_INITIALISATION */
				/* Target: SENDING_STATUS */
				/* Event: when(T8_Cd_Initialisation_Request) */
				/* Statement: T14_Msg_Start_Initialisation := TRUE; -- */
				case "T1":
					if (checkVertices && !vertices.contains("READY_FOR_INITIALISATION")) return false;
					if (this.T8_Cd_Initialisation_Request.value) return false;
					return true;
				/* Source: Junction2 */
				/* Target: READY_FOR_INITIALISATION */
				/* Guard: not D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "match"; DT13b_Checksum_Data := "not applicable"; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T2":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					if (Boolean.valueOf(!this.D23_Con_Checksum_Data_Used.value)) return false;
					return true;
				/* Source: PDI_CONNECTION_IMPERMISSIBLE */
				/* Target: Final1 */
				/* Statement: -- */
				case "T3":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_IMPERMISSIBLE")) return false;
					return true;
				/* Source: Initial2 */
				/* Target: READY_FOR_VERSION_CHECK */
				/* Statement: -- */
				case "T4":
					if (checkVertices && !vertices.contains("Initial2")) return false;
					return true;
				/* Source: PDI_VERSION_UNEQUAL */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: T17_PDI_Connection_Closed := TRUE; -- */
				case "T5":
					if (checkVertices && !vertices.contains("PDI_VERSION_UNEQUAL")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: Initial0 */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Statement: -- */
				case "T6":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: PDI_CONNECTION_CLOSED */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(T5_SCP_Connection_Established) */
				/* Statement: -- */
				case "T7":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_CLOSED")) return false;
					if (this.T5_SCP_Connection_Established.value) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T8":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T22_Content_Telegram_Error.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T9":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T22_Content_Telegram_Error.value) return false;
					return true;
				/* Source: Junction1 */
				/* Target: PDI_VERSION_UNEQUAL */
				/* Guard: not D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "not match"; DT13b_Checksum_Data := "not applicable"; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T10":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (Boolean.valueOf(!this.D23_Con_Checksum_Data_Used.value)) return false;
					return true;
				/* Source: READY_FOR_CONNECTION */
				/* Target: NOT_READY_FOR_CONNECTION */
				/* Event: when(T18_Not_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T11":
					if (checkVertices && !vertices.contains("READY_FOR_CONNECTION")) return false;
					if (this.T18_Not_Ready_For_PDI_Connection.value) return false;
					return true;
				/* Source: Initial1 */
				/* Target: NOT_READY_FOR_CONNECTION */
				/* Statement: -- */
				case "T12":
					if (checkVertices && !vertices.contains("Initial1")) return false;
					return true;
				/* Source: Junction1 */
				/* Target: PDI_VERSION_UNEQUAL */
				/* Guard: D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "not match"; DT13b_Checksum_Data := D4_Con_Checksum_Data; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T13":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (this.D23_Con_Checksum_Data_Used.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: CLOSING_PDI_CONNECTION */
				/* Event: when(T18_Not_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T14":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T18_Not_Ready_For_PDI_Connection.value) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T15":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T20_Protocol_Error.value) return false;
					return true;
				/* Source: Junction2 */
				/* Target: READY_FOR_INITIALISATION */
				/* Guard: D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "match"; DT13b_Checksum_Data := D4_Con_Checksum_Data; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T16":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					if (this.D23_Con_Checksum_Data_Used.value) return false;
					return true;
				/* Source: Junction0 */
				/* Target: Junction2 */
				/* Guard: DT7_PDI_Version = D3_Con_PDI_Version */
				/* Statement: -- */
				case "T17":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (Boolean.valueOf(this.DT7_PDI_Version.value.equals(this.D3_Con_PDI_Version.value))) return false;
					return true;
				/* Source: NOT_READY_FOR_CONNECTION */
				/* Target: READY_FOR_CONNECTION */
				/* Event: when(T1_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T18":
					if (checkVertices && !vertices.contains("NOT_READY_FOR_CONNECTION")) return false;
					if (this.T1_Ready_For_PDI_Connection.value) return false;
					return true;
				/* Source: SENDING_STATUS */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(T9_Status_Report_Completed) */
				/* Statement: T15_Msg_Initialisation_Completed := TRUE; -- */
				case "T19":
					if (checkVertices && !vertices.contains("SENDING_STATUS")) return false;
					if (this.T9_Status_Report_Completed.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T20":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T21_Formal_Telegram_Error.value) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: CLOSING_PDI_CONNECTION */
				/* Event: when(T18_Not_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T21":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T18_Not_Ready_For_PDI_Connection.value) return false;
					return true;
				/* Source: PDI_TELEGRAM_ERROR */
				/* Target: PDI_CONNECTION_IMPERMISSIBLE */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T22":
					if (checkVertices && !vertices.contains("PDI_TELEGRAM_ERROR")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: Junction0 */
				/* Target: Junction1 */
				/* Guard: DT7_PDI_Version <> D3_Con_PDI_Version */
				/* Statement: -- */
				case "T23":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (Boolean.valueOf(!this.DT7_PDI_Version.value.equals(this.D3_Con_PDI_Version.value))) return false;
					return true;
				/* Source: PDI_PROTOCOL_ERROR */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: T17_PDI_Connection_Closed := TRUE; -- */
				case "T24":
					if (checkVertices && !vertices.contains("PDI_PROTOCOL_ERROR")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: READY_FOR_VERSION_CHECK */
				/* Target: Junction0 */
				/* Event: when(T7_Cd_PDI_Version_Check) */
				/* Statement: -- */
				case "T25":
					if (checkVertices && !vertices.contains("READY_FOR_VERSION_CHECK")) return false;
					if (this.T7_Cd_PDI_Version_Check.value) return false;
					return true;
				/* Source: CLOSING_PDI_CONNECTION */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: T17_PDI_Connection_Closed := TRUE; -- */
				case "T26":
					if (checkVertices && !vertices.contains("CLOSING_PDI_CONNECTION")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T27":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T20_Protocol_Error.value) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_SEC> enterState(String id) {
			Set<CompState_SEC> result = new HashSet<CompState_SEC>();
			CompState_SEC e0 = new CompState_SEC().copyFrom(this);
			switch (id) {
				case "PDI_CONNECTION_CLOSED":
					if (vertices.add("PDI_CONNECTION_CLOSED")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T12")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SEC> fringe = new HashSet<CompState_SEC>();
									Set<CompState_SEC> newFringe = new HashSet<CompState_SEC>();
									fringe.add(new CompState_SEC().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SEC f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "ESTABLISHING_PDI_CONNECTION":
					if (vertices.add("ESTABLISHING_PDI_CONNECTION")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T4")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SEC> fringe = new HashSet<CompState_SEC>();
									Set<CompState_SEC> newFringe = new HashSet<CompState_SEC>();
									fringe.add(new CompState_SEC().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SEC f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "SCI_EfeS_Sec_STD_1":
					if (vertices.add("SCI_EfeS_Sec_STD_1")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T6")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SEC> fringe = new HashSet<CompState_SEC>();
									Set<CompState_SEC> newFringe = new HashSet<CompState_SEC>();
									fringe.add(new CompState_SEC().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SEC f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "READY_FOR_INITIALISATION":
					if (vertices.add("READY_FOR_INITIALISATION")) {
						e0.D50_PDI_Connection_State.value = "READY_FOR_INITIALISATION";
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.add("PDI_CONNECTION_ESTABLISHED")) {
						e0.D50_PDI_Connection_State.value = "ESTABLISHED";
						e0.T11_PDI_Connection_Established.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "READY_FOR_CONNECTION":
					if (vertices.add("READY_FOR_CONNECTION")) {
						e0.D50_PDI_Connection_State.value = "CLOSED_READY";
						result.add(e0);
					}
					break;
				case "PDI_PROTOCOL_ERROR":
					if (vertices.add("PDI_PROTOCOL_ERROR")) {
						e0.D50_PDI_Connection_State.value = "PROTOCOL_ERROR";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "READY_FOR_VERSION_CHECK":
					if (vertices.add("READY_FOR_VERSION_CHECK")) {
						e0.D50_PDI_Connection_State.value = "READY_FOR_VERSION_CHECK";
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_IMPERMISSIBLE":
					if (vertices.add("PDI_CONNECTION_IMPERMISSIBLE")) {
						e0.D50_PDI_Connection_State.value = "IMPERMISSIBLE";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "PDI_TELEGRAM_ERROR":
					if (vertices.add("PDI_TELEGRAM_ERROR")) {
						e0.D50_PDI_Connection_State.value = "TELEGRAM_ERROR";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "PDI_VERSION_UNEQUAL":
					if (vertices.add("PDI_VERSION_UNEQUAL")) {
						e0.D50_PDI_Connection_State.value = "VERSION_UNEQUAL";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "SENDING_STATUS":
					if (vertices.add("SENDING_STATUS")) {
						e0.D50_PDI_Connection_State.value = "SENDING_STATUS";
						e0.T6_Start_Status_Report.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "CLOSING_PDI_CONNECTION":
					if (vertices.add("CLOSING_PDI_CONNECTION")) {
						e0.D50_PDI_Connection_State.value = "CLOSING";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "NOT_READY_FOR_CONNECTION":
					if (vertices.add("NOT_READY_FOR_CONNECTION")) {
						e0.D50_PDI_Connection_State.value = "CLOSED";
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SEC> exitState(String id) {
			Set<CompState_SEC> result = new HashSet<CompState_SEC>();
			CompState_SEC e0 = new CompState_SEC();
			switch (id) {
				case "PDI_CONNECTION_CLOSED":
					if (vertices.remove("PDI_CONNECTION_CLOSED")) {
						List<String> states = new ArrayList<String>();
						states.add("NOT_READY_FOR_CONNECTION");
						states.add("READY_FOR_CONNECTION");
						for (CompState_SEC e1 : e0.exitState(states.get(0))) {
							for (CompState_SEC e2 : e1.exitState(states.get(1))) {
								result.add(e2);
							}
						}
					}
					break;
				case "ESTABLISHING_PDI_CONNECTION":
					if (vertices.remove("ESTABLISHING_PDI_CONNECTION")) {
						List<String> states = new ArrayList<String>();
						states.add("READY_FOR_VERSION_CHECK");
						states.add("READY_FOR_INITIALISATION");
						states.add("SENDING_STATUS");
						for (CompState_SEC e1 : e0.exitState(states.get(0))) {
							for (CompState_SEC e2 : e1.exitState(states.get(1))) {
								for (CompState_SEC e3 : e2.exitState(states.get(2))) {
									result.add(e3);
								}
							}
						}
					}
					break;
				case "READY_FOR_INITIALISATION":
					if (vertices.remove("READY_FOR_INITIALISATION")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.remove("PDI_CONNECTION_ESTABLISHED")) {
						result.add(e0);
					}
					break;
				case "READY_FOR_CONNECTION":
					if (vertices.remove("READY_FOR_CONNECTION")) {
						result.add(e0);
					}
					break;
				case "PDI_PROTOCOL_ERROR":
					if (vertices.remove("PDI_PROTOCOL_ERROR")) {
						result.add(e0);
					}
					break;
				case "READY_FOR_VERSION_CHECK":
					if (vertices.remove("READY_FOR_VERSION_CHECK")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_IMPERMISSIBLE":
					if (vertices.remove("PDI_CONNECTION_IMPERMISSIBLE")) {
						result.add(e0);
					}
					break;
				case "PDI_TELEGRAM_ERROR":
					if (vertices.remove("PDI_TELEGRAM_ERROR")) {
						result.add(e0);
					}
					break;
				case "PDI_VERSION_UNEQUAL":
					if (vertices.remove("PDI_VERSION_UNEQUAL")) {
						result.add(e0);
					}
					break;
				case "SENDING_STATUS":
					if (vertices.remove("SENDING_STATUS")) {
						result.add(e0);
					}
					break;
				case "CLOSING_PDI_CONNECTION":
					if (vertices.remove("CLOSING_PDI_CONNECTION")) {
						result.add(e0);
					}
					break;
				case "NOT_READY_FOR_CONNECTION":
					if (vertices.remove("NOT_READY_FOR_CONNECTION")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SEC> firePostExitTransitions() {
			Set<CompState_SEC> result = new HashSet<CompState_SEC>();
			result.add(new CompState_SEC());
			return result;
		}
		private Set<CompState_SEC> fireTransition(String id) {
			Set<CompState_SEC> result = new HashSet<CompState_SEC>();
			switch (id) {
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_SEC e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: READY_FOR_INITIALISATION */
				/* Target: SENDING_STATUS */
				/* Event: when(T8_Cd_Initialisation_Request) */
				/* Statement: T14_Msg_Start_Initialisation := TRUE; -- */
				case "T1":
					for (CompState_SEC e0 : exitState("READY_FOR_INITIALISATION")) {
						e0.T14_Msg_Start_Initialisation.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("SENDING_STATUS")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction2 */
				/* Target: READY_FOR_INITIALISATION */
				/* Guard: not D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "match"; DT13b_Checksum_Data := "not applicable"; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T2":
					for (CompState_SEC e0 : exitState("Junction2")) {
						e0.DT13a_Result.value = "match";
						e0.DT13b_Checksum_Data.value = "not applicable";
						e0.T13_Msg_PDI_Version_Check.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("READY_FOR_INITIALISATION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_IMPERMISSIBLE */
				/* Target: Final1 */
				/* Statement: -- */
				case "T3":
					for (CompState_SEC e0 : exitState("PDI_CONNECTION_IMPERMISSIBLE")) {
						result.add(e0);
					}
					break;
				/* Source: Initial2 */
				/* Target: READY_FOR_VERSION_CHECK */
				/* Statement: -- */
				case "T4":
					for (CompState_SEC e0 : exitState("Initial2")) {
						for (CompState_SEC e1 : e0.enterState("READY_FOR_VERSION_CHECK")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_VERSION_UNEQUAL */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: T17_PDI_Connection_Closed := TRUE; -- */
				case "T5":
					for (CompState_SEC e0 : exitState("PDI_VERSION_UNEQUAL")) {
						e0.T17_PDI_Connection_Closed.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial0 */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Statement: -- */
				case "T6":
					for (CompState_SEC e0 : exitState("Initial0")) {
						for (CompState_SEC e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_CLOSED */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(T5_SCP_Connection_Established) */
				/* Statement: -- */
				case "T7":
					for (CompState_SEC e0 : exitState("PDI_CONNECTION_CLOSED")) {
						for (CompState_SEC e1 : e0.enterState("ESTABLISHING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T8":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_SEC e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T9":
					for (CompState_SEC e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_SEC e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: PDI_VERSION_UNEQUAL */
				/* Guard: not D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "not match"; DT13b_Checksum_Data := "not applicable"; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T10":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						e0.DT13a_Result.value = "not match";
						e0.DT13b_Checksum_Data.value = "not applicable";
						e0.T13_Msg_PDI_Version_Check.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("PDI_VERSION_UNEQUAL")) {
							result.add(e1);
						}
					}
					break;
				/* Source: READY_FOR_CONNECTION */
				/* Target: NOT_READY_FOR_CONNECTION */
				/* Event: when(T18_Not_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T11":
					for (CompState_SEC e0 : exitState("READY_FOR_CONNECTION")) {
						for (CompState_SEC e1 : e0.enterState("NOT_READY_FOR_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial1 */
				/* Target: NOT_READY_FOR_CONNECTION */
				/* Statement: -- */
				case "T12":
					for (CompState_SEC e0 : exitState("Initial1")) {
						for (CompState_SEC e1 : e0.enterState("NOT_READY_FOR_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: PDI_VERSION_UNEQUAL */
				/* Guard: D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "not match"; DT13b_Checksum_Data := D4_Con_Checksum_Data; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T13":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						e0.DT13a_Result.value = "not match";
						e0.DT13b_Checksum_Data.value = e0.D4_Con_Checksum_Data.value;
						e0.T13_Msg_PDI_Version_Check.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("PDI_VERSION_UNEQUAL")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: CLOSING_PDI_CONNECTION */
				/* Event: when(T18_Not_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T14":
					for (CompState_SEC e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_SEC e1 : e0.enterState("CLOSING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T15":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_SEC e1 : e0.enterState("PDI_PROTOCOL_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction2 */
				/* Target: READY_FOR_INITIALISATION */
				/* Guard: D23_Con_Checksum_Data_Used */
				/* Statement: DT13a_Result := "match"; DT13b_Checksum_Data := D4_Con_Checksum_Data; T13_Msg_PDI_Version_Check := TRUE; -- */
				case "T16":
					for (CompState_SEC e0 : exitState("Junction2")) {
						e0.DT13a_Result.value = "match";
						e0.DT13b_Checksum_Data.value = e0.D4_Con_Checksum_Data.value;
						e0.T13_Msg_PDI_Version_Check.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("READY_FOR_INITIALISATION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction0 */
				/* Target: Junction2 */
				/* Guard: DT7_PDI_Version = D3_Con_PDI_Version */
				/* Statement: -- */
				case "T17":
					for (CompState_SEC e0 : exitState("Junction0")) {
						result.add(e0);
					}
					break;
				/* Source: NOT_READY_FOR_CONNECTION */
				/* Target: READY_FOR_CONNECTION */
				/* Event: when(T1_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T18":
					for (CompState_SEC e0 : exitState("NOT_READY_FOR_CONNECTION")) {
						for (CompState_SEC e1 : e0.enterState("READY_FOR_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: SENDING_STATUS */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(T9_Status_Report_Completed) */
				/* Statement: T15_Msg_Initialisation_Completed := TRUE; -- */
				case "T19":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						e0.T15_Msg_Initialisation_Completed.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("PDI_CONNECTION_ESTABLISHED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T20":
					for (CompState_SEC e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_SEC e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: CLOSING_PDI_CONNECTION */
				/* Event: when(T18_Not_Ready_For_PDI_Connection) */
				/* Statement: -- */
				case "T21":
					for (CompState_SEC e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_SEC e1 : e0.enterState("CLOSING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_TELEGRAM_ERROR */
				/* Target: PDI_CONNECTION_IMPERMISSIBLE */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T22":
					for (CompState_SEC e0 : exitState("PDI_TELEGRAM_ERROR")) {
						for (CompState_SEC e1 : e0.enterState("PDI_CONNECTION_IMPERMISSIBLE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction0 */
				/* Target: Junction1 */
				/* Guard: DT7_PDI_Version <> D3_Con_PDI_Version */
				/* Statement: -- */
				case "T23":
					for (CompState_SEC e0 : exitState("Junction0")) {
						result.add(e0);
					}
					break;
				/* Source: PDI_PROTOCOL_ERROR */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: T17_PDI_Connection_Closed := TRUE; -- */
				case "T24":
					for (CompState_SEC e0 : exitState("PDI_PROTOCOL_ERROR")) {
						e0.T17_PDI_Connection_Closed.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: READY_FOR_VERSION_CHECK */
				/* Target: Junction0 */
				/* Event: when(T7_Cd_PDI_Version_Check) */
				/* Statement: -- */
				case "T25":
					for (CompState_SEC e0 : exitState("READY_FOR_VERSION_CHECK")) {
						result.add(e0);
					}
					break;
				/* Source: CLOSING_PDI_CONNECTION */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: T17_PDI_Connection_Closed := TRUE; -- */
				case "T26":
					for (CompState_SEC e0 : exitState("CLOSING_PDI_CONNECTION")) {
						e0.T17_PDI_Connection_Closed.value = Boolean.TRUE;
						for (CompState_SEC e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T27":
					for (CompState_SEC e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_SEC e1 : e0.enterState("PDI_PROTOCOL_ERROR")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_SCPPRIM {
		private final Set<String> vertices;
		public final In<Integer> D100_Mem_Tmax;
		public final Var<Boolean> T11_Disc_Req;
		public final Var<Boolean> T1_Establish_SCP_Connection;
		public final Var<Boolean> T2_Terminate_SCP_Connection;
		public final Var<Boolean> T7_Conn_Resp;
		public final In<Boolean> D10_Error;
		public final In<Boolean> T3_HB_inacceptable_delayed;
		public final Var<Boolean> T4_SCP_Connection_Established;
		public final Var<Boolean> T9_Disc_Req;
		public final Var<Boolean> T5_SCP_Connection_Terminated;
		public final Var<Boolean> T6_Conn_Req;
		public final Var<Boolean> T8_HB;
		public CompState_SCPPRIM() {
			vertices = new HashSet<String>();
			D100_Mem_Tmax = new In<Integer>(0);
			T11_Disc_Req = new Var<Boolean>(false);
			T1_Establish_SCP_Connection = new Var<Boolean>(false);
			T2_Terminate_SCP_Connection = new Var<Boolean>(false);
			T7_Conn_Resp = new Var<Boolean>(false);
			D10_Error = new In<Boolean>(false);
			T3_HB_inacceptable_delayed = new In<Boolean>(false);
			T4_SCP_Connection_Established = new Var<Boolean>(false);
			T9_Disc_Req = new Var<Boolean>(false);
			T5_SCP_Connection_Terminated = new Var<Boolean>(false);
			T6_Conn_Req = new Var<Boolean>(false);
			T8_HB = new Var<Boolean>(false);
		}
		public CompState_SCPPRIM copyFrom(CompState_SCPPRIM source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			D100_Mem_Tmax.value = source.D100_Mem_Tmax.value;
			T11_Disc_Req.value = source.T11_Disc_Req.value;
			T1_Establish_SCP_Connection.value = source.T1_Establish_SCP_Connection.value;
			T2_Terminate_SCP_Connection.value = source.T2_Terminate_SCP_Connection.value;
			T7_Conn_Resp.value = source.T7_Conn_Resp.value;
			D10_Error.value = source.D10_Error.value;
			T3_HB_inacceptable_delayed.value = source.T3_HB_inacceptable_delayed.value;
			T4_SCP_Connection_Established.value = source.T4_SCP_Connection_Established.value;
			T9_Disc_Req.value = source.T9_Disc_Req.value;
			T5_SCP_Connection_Terminated.value = source.T5_SCP_Connection_Terminated.value;
			T6_Conn_Req.value = source.T6_Conn_Req.value;
			T8_HB.value = source.T8_HB.value;
			return this;
		}
		public static Set<CompState_SCPPRIM> create() {
			return new HashSet<CompState_SCPPRIM>(new CompState_SCPPRIM().enterState("SCI_SCP_Prim_STD_1"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: CLOSED */
				/* Target: START */
				/* Event: when(T1_Establish_SCP_Connection) */
				/* Statement: T6_Conn_Req := TRUE; -- */
				case "T":
					if (checkVertices && !vertices.contains("CLOSED")) return false;
					if (this.T1_Establish_SCP_Connection.value) return false;
					return true;
				/* Source: UP */
				/* Target: Junction2 */
				/* Event: when(T11_Disc_Req) */
				/* Statement: -- */
				case "T1":
					if (checkVertices && !vertices.contains("UP")) return false;
					if (this.T11_Disc_Req.value) return false;
					return true;
				/* Source: Junction2 */
				/* Target: CLOSED */
				/* Statement: T5_SCP_Connection_Terminated := TRUE; -- */
				case "T2":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					return true;
				/* Source: START */
				/* Target: Junction1 */
				/* Event: when(T7_Conn_Resp) */
				/* Statement: -- */
				case "T3":
					if (checkVertices && !vertices.contains("START")) return false;
					if (this.T7_Conn_Resp.value) return false;
					return true;
				/* Source: UP */
				/* Target: Junction2 */
				/* Event: when(T3_HB_inacceptable_delayed) */
				/* Statement: -- */
				case "T4":
					if (checkVertices && !vertices.contains("UP")) return false;
					if (this.T3_HB_inacceptable_delayed.value) return false;
					return true;
				/* Source: Initial0 */
				/* Target: CLOSED */
				/* Statement: -- */
				case "T5":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: START */
				/* Target: Junction0 */
				/* Event: after(D100_Mem_Tmax) */
				/* Statement: -- */
				case "T6":
					if (checkVertices && !vertices.contains("START")) return false;
					// ... timeout event ...
					return true;
				/* Source: UP */
				/* Target: Junction0 */
				/* Event: when(T2_Terminate_SCP_Connection) */
				/* Statement: T5_SCP_Connection_Terminated := TRUE; -- */
				case "T7":
					if (checkVertices && !vertices.contains("UP")) return false;
					if (this.T2_Terminate_SCP_Connection.value) return false;
					return true;
				/* Source: Junction1 */
				/* Target: UP */
				/* Guard: not D10_Error */
				/* Statement: T4_SCP_Connection_Established := TRUE; T8_HB := TRUE; -- */
				case "T8":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (Boolean.valueOf(!this.D10_Error.value)) return false;
					return true;
				/* Source: Junction1 */
				/* Target: Junction0 */
				/* Guard: D10_Error */
				/* Statement: -- */
				case "T9":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (this.D10_Error.value) return false;
					return true;
				/* Source: Junction0 */
				/* Target: CLOSED */
				/* Statement: T9_Disc_Req := TRUE; -- */
				case "T10":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_SCPPRIM> enterState(String id) {
			Set<CompState_SCPPRIM> result = new HashSet<CompState_SCPPRIM>();
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(this);
			switch (id) {
				case "UP":
					if (vertices.add("UP")) {
						result.add(e0);
					}
					break;
				case "START":
					if (vertices.add("START")) {
						result.add(e0);
					}
					break;
				case "SCI_SCP_Prim_STD_1":
					if (vertices.add("SCI_SCP_Prim_STD_1")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T5")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SCPPRIM> fringe = new HashSet<CompState_SCPPRIM>();
									Set<CompState_SCPPRIM> newFringe = new HashSet<CompState_SCPPRIM>();
									fringe.add(new CompState_SCPPRIM().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SCPPRIM f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "CLOSED":
					if (vertices.add("CLOSED")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SCPPRIM> exitState(String id) {
			Set<CompState_SCPPRIM> result = new HashSet<CompState_SCPPRIM>();
			CompState_SCPPRIM e0 = new CompState_SCPPRIM();
			switch (id) {
				case "UP":
					if (vertices.remove("UP")) {
						result.add(e0);
					}
					break;
				case "START":
					if (vertices.remove("START")) {
						result.add(e0);
					}
					break;
				case "CLOSED":
					if (vertices.remove("CLOSED")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SCPPRIM> firePostExitTransitions() {
			Set<CompState_SCPPRIM> result = new HashSet<CompState_SCPPRIM>();
			result.add(new CompState_SCPPRIM());
			return result;
		}
		private Set<CompState_SCPPRIM> fireTransition(String id) {
			Set<CompState_SCPPRIM> result = new HashSet<CompState_SCPPRIM>();
			switch (id) {
				/* Source: CLOSED */
				/* Target: START */
				/* Event: when(T1_Establish_SCP_Connection) */
				/* Statement: T6_Conn_Req := TRUE; -- */
				case "T":
					for (CompState_SCPPRIM e0 : exitState("CLOSED")) {
						e0.T6_Conn_Req.value = Boolean.TRUE;
						for (CompState_SCPPRIM e1 : e0.enterState("START")) {
							result.add(e1);
						}
					}
					break;
				/* Source: UP */
				/* Target: Junction2 */
				/* Event: when(T11_Disc_Req) */
				/* Statement: -- */
				case "T1":
					for (CompState_SCPPRIM e0 : exitState("UP")) {
						result.add(e0);
					}
					break;
				/* Source: Junction2 */
				/* Target: CLOSED */
				/* Statement: T5_SCP_Connection_Terminated := TRUE; -- */
				case "T2":
					for (CompState_SCPPRIM e0 : exitState("Junction2")) {
						e0.T5_SCP_Connection_Terminated.value = Boolean.TRUE;
						for (CompState_SCPPRIM e1 : e0.enterState("CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: START */
				/* Target: Junction1 */
				/* Event: when(T7_Conn_Resp) */
				/* Statement: -- */
				case "T3":
					for (CompState_SCPPRIM e0 : exitState("START")) {
						result.add(e0);
					}
					break;
				/* Source: UP */
				/* Target: Junction2 */
				/* Event: when(T3_HB_inacceptable_delayed) */
				/* Statement: -- */
				case "T4":
					for (CompState_SCPPRIM e0 : exitState("UP")) {
						result.add(e0);
					}
					break;
				/* Source: Initial0 */
				/* Target: CLOSED */
				/* Statement: -- */
				case "T5":
					for (CompState_SCPPRIM e0 : exitState("Initial0")) {
						for (CompState_SCPPRIM e1 : e0.enterState("CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: START */
				/* Target: Junction0 */
				/* Event: after(D100_Mem_Tmax) */
				/* Statement: -- */
				case "T6":
					for (CompState_SCPPRIM e0 : exitState("START")) {
						result.add(e0);
					}
					break;
				/* Source: UP */
				/* Target: Junction0 */
				/* Event: when(T2_Terminate_SCP_Connection) */
				/* Statement: T5_SCP_Connection_Terminated := TRUE; -- */
				case "T7":
					for (CompState_SCPPRIM e0 : exitState("UP")) {
						e0.T5_SCP_Connection_Terminated.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				/* Source: Junction1 */
				/* Target: UP */
				/* Guard: not D10_Error */
				/* Statement: T4_SCP_Connection_Established := TRUE; T8_HB := TRUE; -- */
				case "T8":
					for (CompState_SCPPRIM e0 : exitState("Junction1")) {
						e0.T4_SCP_Connection_Established.value = Boolean.TRUE;
						e0.T8_HB.value = Boolean.TRUE;
						for (CompState_SCPPRIM e1 : e0.enterState("UP")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: Junction0 */
				/* Guard: D10_Error */
				/* Statement: -- */
				case "T9":
					for (CompState_SCPPRIM e0 : exitState("Junction1")) {
						result.add(e0);
					}
					break;
				/* Source: Junction0 */
				/* Target: CLOSED */
				/* Statement: T9_Disc_Req := TRUE; -- */
				case "T10":
					for (CompState_SCPPRIM e0 : exitState("Junction0")) {
						e0.T9_Disc_Req.value = Boolean.TRUE;
						for (CompState_SCPPRIM e1 : e0.enterState("CLOSED")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_P3 {
		private final Set<String> vertices;
		public final Var<String> D20_F_EST_EfeS_Gen_SR_State;
		public final Var<Boolean> T40_Report_Status;
		public final Var<String> DT1_Move_Target;
		public final In<Boolean> D36_Con_008300;
		public final In<Boolean> D32_Con_007600;
		public final In<String> D21_PM1_Position;
		public final In<Boolean> D38_Con_008500;
		public final In<String> D22_PM2_Position;
		public final In<Integer> D4_Con_tmax_Point_Operation;
		public final In<Boolean> D35_Con_008200;
		public final In<Boolean> D37_Con_008400;
		public final In<Boolean> D33_Con_007900;
		public final In<Boolean> D30_Con_007000;
		public final Var<Boolean> T1_Move;
		public final Var<Boolean> T2_Stop_Operation;
		public final In<Boolean> D34_Con_008000;
		public final In<String> D13_PM2_Activation;
		public final Var<Boolean> T30_Report_Timeout;
		public final Var<String> DT20_Point_Position;
		public final Out<Boolean> T4_Information_No_End_Position;
		public final Var<Boolean> T20_Point_Position;
		public final Out<Boolean> T7_Information_Out_Of_Sequence;
		public final Out<String> D5_Drive_State;
		public final Out<Boolean> T5_Info_End_Position_Arrived;
		public final Out<Boolean> T6_Information_Trailed_Point;
		public final Out<String> D6_Detection_State;
		public final Out<Boolean> D11_Move_Right;
		public final Out<Boolean> D10_Move_Left;
		public final Out<Boolean> D25_Redrive;
		public final Var<String> Mem_Current_Point_Position;
		public final Var<String> Mem_last_Target_Requested;
		public CompState_P3() {
			vertices = new HashSet<String>();
			D20_F_EST_EfeS_Gen_SR_State = new Var<String>("");
			T40_Report_Status = new Var<Boolean>(false);
			DT1_Move_Target = new Var<String>("");
			D36_Con_008300 = new In<Boolean>(false);
			D32_Con_007600 = new In<Boolean>(false);
			D21_PM1_Position = new In<String>("");
			D38_Con_008500 = new In<Boolean>(false);
			D22_PM2_Position = new In<String>("");
			D4_Con_tmax_Point_Operation = new In<Integer>(0);
			D35_Con_008200 = new In<Boolean>(false);
			D37_Con_008400 = new In<Boolean>(false);
			D33_Con_007900 = new In<Boolean>(false);
			D30_Con_007000 = new In<Boolean>(false);
			T1_Move = new Var<Boolean>(false);
			T2_Stop_Operation = new Var<Boolean>(false);
			D34_Con_008000 = new In<Boolean>(false);
			D13_PM2_Activation = new In<String>("");
			T30_Report_Timeout = new Var<Boolean>(false);
			DT20_Point_Position = new Var<String>("UNKNOWN");
			T4_Information_No_End_Position = new Out<Boolean>(false);
			T20_Point_Position = new Var<Boolean>(false);
			T7_Information_Out_Of_Sequence = new Out<Boolean>(false);
			D5_Drive_State = new Out<String>("STOPPED");
			T5_Info_End_Position_Arrived = new Out<Boolean>(false);
			T6_Information_Trailed_Point = new Out<Boolean>(false);
			D6_Detection_State = new Out<String>("");
			D11_Move_Right = new Out<Boolean>(false);
			D10_Move_Left = new Out<Boolean>(false);
			D25_Redrive = new Out<Boolean>(false);
			Mem_Current_Point_Position = new Var<String>("");
			Mem_last_Target_Requested = new Var<String>("");
		}
		public CompState_P3 copyFrom(CompState_P3 source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			D20_F_EST_EfeS_Gen_SR_State.value = source.D20_F_EST_EfeS_Gen_SR_State.value;
			T40_Report_Status.value = source.T40_Report_Status.value;
			DT1_Move_Target.value = source.DT1_Move_Target.value;
			D36_Con_008300.value = source.D36_Con_008300.value;
			D32_Con_007600.value = source.D32_Con_007600.value;
			D21_PM1_Position.value = source.D21_PM1_Position.value;
			D38_Con_008500.value = source.D38_Con_008500.value;
			D22_PM2_Position.value = source.D22_PM2_Position.value;
			D4_Con_tmax_Point_Operation.value = source.D4_Con_tmax_Point_Operation.value;
			D35_Con_008200.value = source.D35_Con_008200.value;
			D37_Con_008400.value = source.D37_Con_008400.value;
			D33_Con_007900.value = source.D33_Con_007900.value;
			D30_Con_007000.value = source.D30_Con_007000.value;
			T1_Move.value = source.T1_Move.value;
			T2_Stop_Operation.value = source.T2_Stop_Operation.value;
			D34_Con_008000.value = source.D34_Con_008000.value;
			D13_PM2_Activation.value = source.D13_PM2_Activation.value;
			T30_Report_Timeout.value = source.T30_Report_Timeout.value;
			DT20_Point_Position.value = source.DT20_Point_Position.value;
			T4_Information_No_End_Position.value = source.T4_Information_No_End_Position.value;
			T20_Point_Position.value = source.T20_Point_Position.value;
			T7_Information_Out_Of_Sequence.value = source.T7_Information_Out_Of_Sequence.value;
			D5_Drive_State.value = source.D5_Drive_State.value;
			T5_Info_End_Position_Arrived.value = source.T5_Info_End_Position_Arrived.value;
			T6_Information_Trailed_Point.value = source.T6_Information_Trailed_Point.value;
			D6_Detection_State.value = source.D6_Detection_State.value;
			D11_Move_Right.value = source.D11_Move_Right.value;
			D10_Move_Left.value = source.D10_Move_Left.value;
			D25_Redrive.value = source.D25_Redrive.value;
			Mem_Current_Point_Position.value = source.Mem_Current_Point_Position.value;
			Mem_last_Target_Requested.value = source.Mem_last_Target_Requested.value;
			return this;
		}
		public static Set<CompState_P3> create() {
			return new HashSet<CompState_P3>(new CompState_P3().enterState("F_P3_SR_STD_1"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private Boolean cOp13_Not_Initialised() {
			return Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(this.D20_F_EST_EfeS_Gen_SR_State.value.equals("NO_OPERATING_VOLTAGE")) || Boolean.valueOf(this.D20_F_EST_EfeS_Gen_SR_State.value.equals("BOOTING"))) || Boolean.valueOf(this.D20_F_EST_EfeS_Gen_SR_State.value.equals("FALLBACK_MODE")));
		}
		private Boolean cOp8_Supports_Multiple_PMs() {
			return Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(this.D30_Con_007000.value || this.D32_Con_007600.value) || this.D33_Con_007900.value) || this.D34_Con_008000.value) || this.D35_Con_008200.value) || this.D37_Con_008400.value);
		}
		private void cOp12_Timeout() {
			this.D5_Drive_State.value = "STOPPED";
			if (Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(this.D32_Con_007600.value || this.D33_Con_007900.value) || this.D34_Con_008000.value) || this.D35_Con_008200.value) || this.D37_Con_008400.value)) {
				this.T30_Report_Timeout.value = Boolean.TRUE;
			}
		}
		private Boolean cOp5_Trailed() {
			if (Boolean.valueOf(!cOp6_Error())) {
				if (cOp8_Supports_Multiple_PMs()) {
					return Boolean.valueOf(Boolean.valueOf(this.D21_PM1_Position.value.equals("TRAILED")) || Boolean.valueOf(this.D22_PM2_Position.value.equals("TRAILED")));
				} else {
					return Boolean.valueOf(this.D21_PM1_Position.value.equals("TRAILED"));
				}
			} else {
				return Boolean.FALSE;
			}
		}
		private void cOp1_Init() {
			this.T4_Information_No_End_Position.value = Boolean.FALSE;
			this.T5_Info_End_Position_Arrived.value = Boolean.FALSE;
			this.D5_Drive_State.value = "STOPPED";
			this.D6_Detection_State.value = "";
			this.T6_Information_Trailed_Point.value = Boolean.FALSE;
			this.T7_Information_Out_Of_Sequence.value = Boolean.FALSE;
			this.D10_Move_Left.value = Boolean.FALSE;
			this.D11_Move_Right.value = Boolean.FALSE;
			this.T20_Point_Position.value = Boolean.FALSE;
			this.DT20_Point_Position.value = "UNKNOWN";
			this.D25_Redrive.value = Boolean.FALSE;
			this.T30_Report_Timeout.value = Boolean.FALSE;
			this.Mem_last_Target_Requested.value = "";
			this.Mem_Current_Point_Position.value = "";
		}
		private Boolean cOp10_Redrive_Right() {
			return Boolean.valueOf(Boolean.valueOf(cOp3_No_End_Position() && Boolean.valueOf(this.Mem_last_Target_Requested.value.equals("RIGHT"))) && Boolean.valueOf(this.Mem_Current_Point_Position.value.equals("RIGHT")));
		}
		private Boolean cOp6_Error() {
			if (cOp8_Supports_Multiple_PMs()) {
				return Boolean.valueOf(Boolean.valueOf(this.D21_PM1_Position.value.equals("ERROR")) || Boolean.valueOf(this.D22_PM2_Position.value.equals("ERROR")));
			} else {
				return Boolean.valueOf(this.D21_PM1_Position.value.equals("ERROR"));
			}
		}
		private Boolean cOp9_Redrive_Enabled() {
			return this.D30_Con_007000.value;
		}
		private Boolean cOp2_All_Left() {
			if (cOp8_Supports_Multiple_PMs()) {
				return Boolean.valueOf(Boolean.valueOf(this.D21_PM1_Position.value.equals("LEFT")) && Boolean.valueOf(Boolean.valueOf(this.D22_PM2_Position.value.equals("LEFT")) || Boolean.valueOf(this.D13_PM2_Activation.value.equals("INACTIVE"))));
			} else {
				return Boolean.valueOf(this.D21_PM1_Position.value.equals("LEFT"));
			}
		}
		private Boolean cOp7_Is_Trailable() {
			return Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(this.D32_Con_007600.value || this.D33_Con_007900.value) || this.D34_Con_008000.value) || this.D35_Con_008200.value);
		}
		private Boolean cOp3_No_End_Position() {
			return Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(Boolean.valueOf(!cOp6_Error()) && Boolean.valueOf(!cOp5_Trailed())) && Boolean.valueOf(!cOp2_All_Left())) && Boolean.valueOf(!cOp4_All_Right()));
		}
		private Boolean cOp4_All_Right() {
			if (cOp8_Supports_Multiple_PMs()) {
				return Boolean.valueOf(Boolean.valueOf(this.D21_PM1_Position.value.equals("RIGHT")) && Boolean.valueOf(Boolean.valueOf(this.D22_PM2_Position.value.equals("RIGHT")) || Boolean.valueOf(this.D13_PM2_Activation.value.equals("INACTIVE"))));
			} else {
				return Boolean.valueOf(this.D21_PM1_Position.value.equals("RIGHT"));
			}
		}
		private Boolean cOp11_Redrive_Left() {
			return Boolean.valueOf(Boolean.valueOf(cOp3_No_End_Position() && Boolean.valueOf(this.Mem_last_Target_Requested.value.equals("LEFT"))) && Boolean.valueOf(this.Mem_Current_Point_Position.value.equals("LEFT")));
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: Initial2 */
				/* Target: STOPPED */
				/* Statement: -- */
				case "T":
					if (checkVertices && !vertices.contains("Initial2")) return false;
					return true;
				/* Source: MOVING_LEFT */
				/* Target: STOPPED */
				/* Guard: cOp13_Not_Initialised() */
				/* Statement: -- */
				case "T1":
					if (checkVertices && !vertices.contains("MOVING_LEFT")) return false;
					if (cOp13_Not_Initialised()) return false;
					return true;
				/* Source: ALL_RIGHT */
				/* Target: TRAILED */
				/* Event: when(cOp5_Trailed()) */
				/* Guard: cOp7_Is_Trailable() */
				/* Statement: -- */
				case "T2":
					if (checkVertices && !vertices.contains("ALL_RIGHT")) return false;
					if (cOp5_Trailed()) return false;
					if (cOp7_Is_Trailable()) return false;
					return true;
				/* Source: Junction1 */
				/* Target: STOPPED */
				/* Guard: DT1_Move_Target = Mem_Current_Point_Position */
				/* Statement: T20_Point_Position := TRUE; -- */
				case "T3":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (Boolean.valueOf(this.DT1_Move_Target.value.equals(this.Mem_Current_Point_Position.value))) return false;
					return true;
				/* Source: ALL_LEFT */
				/* Target: NO_END_POSITION */
				/* Event: when(cOp3_No_End_Position()) */
				/* Statement: -- */
				case "T4":
					if (checkVertices && !vertices.contains("ALL_LEFT")) return false;
					if (cOp3_No_End_Position()) return false;
					return true;
				/* Source: NO_END_POSITION */
				/* Target: ALL_RIGHT */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T5":
					if (checkVertices && !vertices.contains("NO_END_POSITION")) return false;
					if (cOp4_All_Right()) return false;
					return true;
				/* Source: MOVING_RIGHT */
				/* Target: MOVING_LEFT */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "LEFT" */
				/* Statement: -- */
				case "T6":
					if (checkVertices && !vertices.contains("MOVING_RIGHT")) return false;
					if (this.T1_Move.value) return false;
					if (Boolean.valueOf(this.DT1_Move_Target.value.equals("LEFT"))) return false;
					return true;
				/* Source: NO_END_POSITION */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T7":
					if (checkVertices && !vertices.contains("NO_END_POSITION")) return false;
					if (cOp13_Not_Initialised()) return false;
					return true;
				/* Source: Initial0 */
				/* Target: OPERATING */
				/* Statement: -- */
				case "T8":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: Junction2 */
				/* Target: STOPPED */
				/* Guard: DT1_Move_Target = Mem_Current_Point_Position */
				/* Statement: T20_Point_Position := TRUE; -- */
				case "T9":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					if (Boolean.valueOf(this.DT1_Move_Target.value.equals(this.Mem_Current_Point_Position.value))) return false;
					return true;
				/* Source: Junction0 */
				/* Target: TRAILED */
				/* Guard: cOp5_Trailed() and cOp7_Is_Trailable() */
				/* Statement: -- */
				case "T10":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (Boolean.valueOf(cOp5_Trailed() && cOp7_Is_Trailable())) return false;
					return true;
				/* Source: ALL_RIGHT */
				/* Target: ALL_LEFT */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T11":
					if (checkVertices && !vertices.contains("ALL_RIGHT")) return false;
					if (cOp2_All_Left()) return false;
					return true;
				/* Source: TRAILED */
				/* Target: ALL_RIGHT */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T12":
					if (checkVertices && !vertices.contains("TRAILED")) return false;
					if (cOp4_All_Right()) return false;
					return true;
				/* Source: Junction0 */
				/* Target: ALL_RIGHT */
				/* Guard: cOp4_All_Right() */
				/* Statement: -- */
				case "T13":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (cOp4_All_Right()) return false;
					return true;
				/* Source: MOVING_RIGHT */
				/* Target: STOPPED */
				/* Guard: cOp13_Not_Initialised() */
				/* Statement: -- */
				case "T14":
					if (checkVertices && !vertices.contains("MOVING_RIGHT")) return false;
					if (cOp13_Not_Initialised()) return false;
					return true;
				/* Source: ALL_LEFT */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T15":
					if (checkVertices && !vertices.contains("ALL_LEFT")) return false;
					if (cOp13_Not_Initialised()) return false;
					return true;
				/* Source: MOVING_LEFT */
				/* Target: MOVING_RIGHT */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "RIGHT" */
				/* Statement: -- */
				case "T16":
					if (checkVertices && !vertices.contains("MOVING_LEFT")) return false;
					if (this.T1_Move.value) return false;
					if (Boolean.valueOf(this.DT1_Move_Target.value.equals("RIGHT"))) return false;
					return true;
				/* Source: TRAILED */
				/* Target: ALL_LEFT */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T17":
					if (checkVertices && !vertices.contains("TRAILED")) return false;
					if (cOp2_All_Left()) return false;
					return true;
				/* Source: NO_END_POSITION */
				/* Target: ALL_LEFT */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T18":
					if (checkVertices && !vertices.contains("NO_END_POSITION")) return false;
					if (cOp2_All_Left()) return false;
					return true;
				/* Source: ALL_RIGHT */
				/* Target: NO_END_POSITION */
				/* Event: when(cOp3_No_End_Position()) */
				/* Statement: -- */
				case "T19":
					if (checkVertices && !vertices.contains("ALL_RIGHT")) return false;
					if (cOp3_No_End_Position()) return false;
					return true;
				/* Source: STOPPED */
				/* Target: Junction2 */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "RIGHT" */
				/* Statement: -- */
				case "T20":
					if (checkVertices && !vertices.contains("STOPPED")) return false;
					if (this.T1_Move.value) return false;
					if (Boolean.valueOf(this.DT1_Move_Target.value.equals("RIGHT"))) return false;
					return true;
				/* Source: Junction0 */
				/* Target: NO_END_POSITION */
				/* Guard: cOp3_No_End_Position() */
				/* Statement: -- */
				case "T21":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (cOp3_No_End_Position()) return false;
					return true;
				/* Source: MOVING_LEFT */
				/* Target: STOPPED */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T22":
					if (checkVertices && !vertices.contains("MOVING_LEFT")) return false;
					if (cOp2_All_Left()) return false;
					return true;
				/* Source: ALL_RIGHT */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T23":
					if (checkVertices && !vertices.contains("ALL_RIGHT")) return false;
					if (cOp13_Not_Initialised()) return false;
					return true;
				/* Source: ALL_LEFT */
				/* Target: ALL_RIGHT */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T24":
					if (checkVertices && !vertices.contains("ALL_LEFT")) return false;
					if (cOp4_All_Right()) return false;
					return true;
				/* Source: Initial1 */
				/* Target: WAITING_FOR_INITIALISING */
				/* Statement: -- */
				case "T25":
					if (checkVertices && !vertices.contains("Initial1")) return false;
					return true;
				/* Source: STOPPED */
				/* Target: MOVING_LEFT */
				/* Event: when(cOp11_Redrive_Left()) */
				/* Guard: cOp9_Redrive_Enabled() */
				/* Statement: D25_Redrive := TRUE; -- */
				case "T26":
					if (checkVertices && !vertices.contains("STOPPED")) return false;
					if (cOp11_Redrive_Left()) return false;
					if (cOp9_Redrive_Enabled()) return false;
					return true;
				/* Source: STOPPED */
				/* Target: MOVING_RIGHT */
				/* Event: when(cOp10_Redrive_Right()) */
				/* Guard: cOp9_Redrive_Enabled() */
				/* Statement: D25_Redrive := TRUE; -- */
				case "T27":
					if (checkVertices && !vertices.contains("STOPPED")) return false;
					if (cOp10_Redrive_Right()) return false;
					if (cOp9_Redrive_Enabled()) return false;
					return true;
				/* Source: MOVING_LEFT */
				/* Target: STOPPED */
				/* Event: after(D4_Con_tmax_Point_Operation) */
				/* Statement: cOp12_Timeout() -- */
				case "T28":
					if (checkVertices && !vertices.contains("MOVING_LEFT")) return false;
					// ... timeout event ...
					return true;
				/* Source: Junction2 */
				/* Target: MOVING_RIGHT */
				/* Guard: DT1_Move_Target <> Mem_Current_Point_Position */
				/* Statement: -- */
				case "T29":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					if (Boolean.valueOf(!this.DT1_Move_Target.value.equals(this.Mem_Current_Point_Position.value))) return false;
					return true;
				/* Source: TRAILED */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T30":
					if (checkVertices && !vertices.contains("TRAILED")) return false;
					if (cOp13_Not_Initialised()) return false;
					return true;
				/* Source: ALL_LEFT */
				/* Target: TRAILED */
				/* Event: when(cOp5_Trailed()) */
				/* Guard: cOp7_Is_Trailable() */
				/* Statement: -- */
				case "T31":
					if (checkVertices && !vertices.contains("ALL_LEFT")) return false;
					if (cOp5_Trailed()) return false;
					if (cOp7_Is_Trailable()) return false;
					return true;
				/* Source: TRAILED */
				/* Target: NO_END_POSITION */
				/* Event: when(cOp3_No_End_Position()) */
				/* Statement: -- */
				case "T32":
					if (checkVertices && !vertices.contains("TRAILED")) return false;
					if (cOp3_No_End_Position()) return false;
					return true;
				/* Source: MOVING_RIGHT */
				/* Target: STOPPED */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T33":
					if (checkVertices && !vertices.contains("MOVING_RIGHT")) return false;
					if (cOp4_All_Right()) return false;
					return true;
				/* Source: MOVING_RIGHT */
				/* Target: STOPPED */
				/* Event: after(D4_Con_tmax_Point_Operation) */
				/* Statement: cOp12_Timeout() -- */
				case "T34":
					if (checkVertices && !vertices.contains("MOVING_RIGHT")) return false;
					// ... timeout event ...
					return true;
				/* Source: Junction1 */
				/* Target: MOVING_LEFT */
				/* Guard: DT1_Move_Target <> Mem_Current_Point_Position */
				/* Statement: -- */
				case "T35":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (Boolean.valueOf(!this.DT1_Move_Target.value.equals(this.Mem_Current_Point_Position.value))) return false;
					return true;
				/* Source: STOPPED */
				/* Target: Junction1 */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "LEFT" */
				/* Statement: -- */
				case "T36":
					if (checkVertices && !vertices.contains("STOPPED")) return false;
					if (this.T1_Move.value) return false;
					if (Boolean.valueOf(this.DT1_Move_Target.value.equals("LEFT"))) return false;
					return true;
				/* Source: WAITING_FOR_INITIALISING */
				/* Target: Junction0 */
				/* Event: when(D20_F_EST_EfeS_Gen_SR_State = "INITIALISING") */
				/* Statement: -- */
				case "T37":
					if (checkVertices && !vertices.contains("WAITING_FOR_INITIALISING")) return false;
					if (Boolean.valueOf(this.D20_F_EST_EfeS_Gen_SR_State.value.equals("INITIALISING"))) return false;
					return true;
				/* Source: Junction0 */
				/* Target: ALL_LEFT */
				/* Guard: cOp2_All_Left() */
				/* Statement: -- */
				case "T38":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (cOp2_All_Left()) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_P3> enterState(String id) {
			Set<CompState_P3> result = new HashSet<CompState_P3>();
			CompState_P3 e0 = new CompState_P3().copyFrom(this);
			switch (id) {
				case "ALL_RIGHT":
					if (vertices.add("ALL_RIGHT")) {
						e0.DT20_Point_Position.value = "RIGHT";
						e0.T20_Point_Position.value = Boolean.TRUE;
						e0.Mem_Current_Point_Position.value = "RIGHT";
						e0.T5_Info_End_Position_Arrived.value = Boolean.TRUE;
						e0.D6_Detection_State.value = "END_POSITION";
						result.add(e0);
					}
					break;
				case "WAITING_FOR_INITIALISING":
					if (vertices.add("WAITING_FOR_INITIALISING")) {
						result.add(e0);
					}
					break;
				case "MOVING_LEFT":
					if (vertices.add("MOVING_LEFT")) {
						e0.D10_Move_Left.value = Boolean.TRUE;
						e0.D5_Drive_State.value = "MOVING";
						e0.Mem_last_Target_Requested.value = "LEFT";
						result.add(e0);
					}
					break;
				case "STOPPED":
					if (vertices.add("STOPPED")) {
						e0.D25_Redrive.value = Boolean.FALSE;
						e0.D5_Drive_State.value = "STOPPED";
						result.add(e0);
					}
					break;
				case "MOVING_RIGHT":
					if (vertices.add("MOVING_RIGHT")) {
						e0.D11_Move_Right.value = Boolean.TRUE;
						e0.D5_Drive_State.value = "MOVING";
						e0.Mem_last_Target_Requested.value = "RIGHT";
						result.add(e0);
					}
					break;
				case "TRAILED":
					if (vertices.add("TRAILED")) {
						e0.DT20_Point_Position.value = "TRAILED";
						e0.T20_Point_Position.value = Boolean.TRUE;
						e0.Mem_Current_Point_Position.value = "TRAILED";
						e0.T6_Information_Trailed_Point.value = Boolean.TRUE;
						e0.D6_Detection_State.value = "TRAILED";
						result.add(e0);
					}
					break;
				case "ALL_LEFT":
					if (vertices.add("ALL_LEFT")) {
						e0.DT20_Point_Position.value = "LEFT";
						e0.T20_Point_Position.value = Boolean.TRUE;
						e0.Mem_Current_Point_Position.value = "LEFT";
						e0.T5_Info_End_Position_Arrived.value = Boolean.TRUE;
						e0.D6_Detection_State.value = "END_POSITION";
						result.add(e0);
					}
					break;
				case "F_P3_SR_STD_1":
					if (vertices.add("F_P3_SR_STD_1")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T8")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_P3> fringe = new HashSet<CompState_P3>();
									Set<CompState_P3> newFringe = new HashSet<CompState_P3>();
									fringe.add(new CompState_P3().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_P3 f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "NO_END_POSITION":
					if (vertices.add("NO_END_POSITION")) {
						e0.DT20_Point_Position.value = "NO_END_POSITION";
						e0.T20_Point_Position.value = Boolean.TRUE;
						e0.Mem_Current_Point_Position.value = "NO_END_POSITION";
						e0.T4_Information_No_End_Position.value = Boolean.TRUE;
						e0.D6_Detection_State.value = "NO_END_POSITION";
						result.add(e0);
					}
					break;
				case "OPERATING":
					if (vertices.add("OPERATING")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T")), Arrays.asList(Arrays.asList("T25")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_P3> fringe = new HashSet<CompState_P3>();
									Set<CompState_P3> newFringe = new HashSet<CompState_P3>();
									fringe.add(new CompState_P3().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_P3 f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_P3> exitState(String id) {
			Set<CompState_P3> result = new HashSet<CompState_P3>();
			CompState_P3 e0 = new CompState_P3();
			switch (id) {
				case "ALL_RIGHT":
					if (vertices.remove("ALL_RIGHT")) {
						e0.T5_Info_End_Position_Arrived.value = Boolean.FALSE;
						result.add(e0);
					}
					break;
				case "WAITING_FOR_INITIALISING":
					if (vertices.remove("WAITING_FOR_INITIALISING")) {
						result.add(e0);
					}
					break;
				case "MOVING_LEFT":
					if (vertices.remove("MOVING_LEFT")) {
						e0.D10_Move_Left.value = Boolean.FALSE;
						result.add(e0);
					}
					break;
				case "STOPPED":
					if (vertices.remove("STOPPED")) {
						result.add(e0);
					}
					break;
				case "MOVING_RIGHT":
					if (vertices.remove("MOVING_RIGHT")) {
						e0.D11_Move_Right.value = Boolean.FALSE;
						result.add(e0);
					}
					break;
				case "TRAILED":
					if (vertices.remove("TRAILED")) {
						e0.T6_Information_Trailed_Point.value = Boolean.FALSE;
						result.add(e0);
					}
					break;
				case "ALL_LEFT":
					if (vertices.remove("ALL_LEFT")) {
						e0.T5_Info_End_Position_Arrived.value = Boolean.FALSE;
						result.add(e0);
					}
					break;
				case "NO_END_POSITION":
					if (vertices.remove("NO_END_POSITION")) {
						e0.T4_Information_No_End_Position.value = Boolean.FALSE;
						result.add(e0);
					}
					break;
				case "OPERATING":
					if (vertices.remove("OPERATING")) {
						List<String> states = new ArrayList<String>();
						states.add("MOVING_LEFT");
						states.add("ALL_LEFT");
						states.add("STOPPED");
						states.add("MOVING_RIGHT");
						states.add("WAITING_FOR_INITIALISING");
						states.add("NO_END_POSITION");
						states.add("TRAILED");
						states.add("ALL_RIGHT");
						for (CompState_P3 e1 : e0.exitState(states.get(0))) {
							for (CompState_P3 e2 : e1.exitState(states.get(1))) {
								for (CompState_P3 e3 : e2.exitState(states.get(2))) {
									for (CompState_P3 e4 : e3.exitState(states.get(3))) {
										for (CompState_P3 e5 : e4.exitState(states.get(4))) {
											for (CompState_P3 e6 : e5.exitState(states.get(5))) {
												for (CompState_P3 e7 : e6.exitState(states.get(6))) {
													for (CompState_P3 e8 : e7.exitState(states.get(7))) {
														result.add(e8);
													}
												}
											}
										}
									}
								}
							}
						}
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_P3> firePostExitTransitions() {
			Set<CompState_P3> result = new HashSet<CompState_P3>();
			result.add(new CompState_P3());
			return result;
		}
		private Set<CompState_P3> fireTransition(String id) {
			Set<CompState_P3> result = new HashSet<CompState_P3>();
			switch (id) {
				/* Source: Initial2 */
				/* Target: STOPPED */
				/* Statement: -- */
				case "T":
					for (CompState_P3 e0 : exitState("Initial2")) {
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_LEFT */
				/* Target: STOPPED */
				/* Guard: cOp13_Not_Initialised() */
				/* Statement: -- */
				case "T1":
					for (CompState_P3 e0 : exitState("MOVING_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_RIGHT */
				/* Target: TRAILED */
				/* Event: when(cOp5_Trailed()) */
				/* Guard: cOp7_Is_Trailable() */
				/* Statement: -- */
				case "T2":
					for (CompState_P3 e0 : exitState("ALL_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("TRAILED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: STOPPED */
				/* Guard: DT1_Move_Target = Mem_Current_Point_Position */
				/* Statement: T20_Point_Position := TRUE; -- */
				case "T3":
					for (CompState_P3 e0 : exitState("Junction1")) {
						e0.T20_Point_Position.value = Boolean.TRUE;
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_LEFT */
				/* Target: NO_END_POSITION */
				/* Event: when(cOp3_No_End_Position()) */
				/* Statement: -- */
				case "T4":
					for (CompState_P3 e0 : exitState("ALL_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("NO_END_POSITION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: NO_END_POSITION */
				/* Target: ALL_RIGHT */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T5":
					for (CompState_P3 e0 : exitState("NO_END_POSITION")) {
						for (CompState_P3 e1 : e0.enterState("ALL_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_RIGHT */
				/* Target: MOVING_LEFT */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "LEFT" */
				/* Statement: -- */
				case "T6":
					for (CompState_P3 e0 : exitState("MOVING_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("MOVING_LEFT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: NO_END_POSITION */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T7":
					for (CompState_P3 e0 : exitState("NO_END_POSITION")) {
						for (CompState_P3 e1 : e0.enterState("WAITING_FOR_INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial0 */
				/* Target: OPERATING */
				/* Statement: -- */
				case "T8":
					for (CompState_P3 e0 : exitState("Initial0")) {
						for (CompState_P3 e1 : e0.enterState("OPERATING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction2 */
				/* Target: STOPPED */
				/* Guard: DT1_Move_Target = Mem_Current_Point_Position */
				/* Statement: T20_Point_Position := TRUE; -- */
				case "T9":
					for (CompState_P3 e0 : exitState("Junction2")) {
						e0.T20_Point_Position.value = Boolean.TRUE;
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction0 */
				/* Target: TRAILED */
				/* Guard: cOp5_Trailed() and cOp7_Is_Trailable() */
				/* Statement: -- */
				case "T10":
					for (CompState_P3 e0 : exitState("Junction0")) {
						for (CompState_P3 e1 : e0.enterState("TRAILED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_RIGHT */
				/* Target: ALL_LEFT */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T11":
					for (CompState_P3 e0 : exitState("ALL_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("ALL_LEFT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: TRAILED */
				/* Target: ALL_RIGHT */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T12":
					for (CompState_P3 e0 : exitState("TRAILED")) {
						for (CompState_P3 e1 : e0.enterState("ALL_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction0 */
				/* Target: ALL_RIGHT */
				/* Guard: cOp4_All_Right() */
				/* Statement: -- */
				case "T13":
					for (CompState_P3 e0 : exitState("Junction0")) {
						for (CompState_P3 e1 : e0.enterState("ALL_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_RIGHT */
				/* Target: STOPPED */
				/* Guard: cOp13_Not_Initialised() */
				/* Statement: -- */
				case "T14":
					for (CompState_P3 e0 : exitState("MOVING_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_LEFT */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T15":
					for (CompState_P3 e0 : exitState("ALL_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("WAITING_FOR_INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_LEFT */
				/* Target: MOVING_RIGHT */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "RIGHT" */
				/* Statement: -- */
				case "T16":
					for (CompState_P3 e0 : exitState("MOVING_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("MOVING_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: TRAILED */
				/* Target: ALL_LEFT */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T17":
					for (CompState_P3 e0 : exitState("TRAILED")) {
						for (CompState_P3 e1 : e0.enterState("ALL_LEFT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: NO_END_POSITION */
				/* Target: ALL_LEFT */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T18":
					for (CompState_P3 e0 : exitState("NO_END_POSITION")) {
						for (CompState_P3 e1 : e0.enterState("ALL_LEFT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_RIGHT */
				/* Target: NO_END_POSITION */
				/* Event: when(cOp3_No_End_Position()) */
				/* Statement: -- */
				case "T19":
					for (CompState_P3 e0 : exitState("ALL_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("NO_END_POSITION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STOPPED */
				/* Target: Junction2 */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "RIGHT" */
				/* Statement: -- */
				case "T20":
					for (CompState_P3 e0 : exitState("STOPPED")) {
						result.add(e0);
					}
					break;
				/* Source: Junction0 */
				/* Target: NO_END_POSITION */
				/* Guard: cOp3_No_End_Position() */
				/* Statement: -- */
				case "T21":
					for (CompState_P3 e0 : exitState("Junction0")) {
						for (CompState_P3 e1 : e0.enterState("NO_END_POSITION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_LEFT */
				/* Target: STOPPED */
				/* Event: when(cOp2_All_Left()) */
				/* Statement: -- */
				case "T22":
					for (CompState_P3 e0 : exitState("MOVING_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_RIGHT */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T23":
					for (CompState_P3 e0 : exitState("ALL_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("WAITING_FOR_INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_LEFT */
				/* Target: ALL_RIGHT */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T24":
					for (CompState_P3 e0 : exitState("ALL_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("ALL_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial1 */
				/* Target: WAITING_FOR_INITIALISING */
				/* Statement: -- */
				case "T25":
					for (CompState_P3 e0 : exitState("Initial1")) {
						for (CompState_P3 e1 : e0.enterState("WAITING_FOR_INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STOPPED */
				/* Target: MOVING_LEFT */
				/* Event: when(cOp11_Redrive_Left()) */
				/* Guard: cOp9_Redrive_Enabled() */
				/* Statement: D25_Redrive := TRUE; -- */
				case "T26":
					for (CompState_P3 e0 : exitState("STOPPED")) {
						e0.D25_Redrive.value = Boolean.TRUE;
						for (CompState_P3 e1 : e0.enterState("MOVING_LEFT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STOPPED */
				/* Target: MOVING_RIGHT */
				/* Event: when(cOp10_Redrive_Right()) */
				/* Guard: cOp9_Redrive_Enabled() */
				/* Statement: D25_Redrive := TRUE; -- */
				case "T27":
					for (CompState_P3 e0 : exitState("STOPPED")) {
						e0.D25_Redrive.value = Boolean.TRUE;
						for (CompState_P3 e1 : e0.enterState("MOVING_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_LEFT */
				/* Target: STOPPED */
				/* Event: after(D4_Con_tmax_Point_Operation) */
				/* Statement: cOp12_Timeout() -- */
				case "T28":
					for (CompState_P3 e0 : exitState("MOVING_LEFT")) {
						cOp12_Timeout();
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction2 */
				/* Target: MOVING_RIGHT */
				/* Guard: DT1_Move_Target <> Mem_Current_Point_Position */
				/* Statement: -- */
				case "T29":
					for (CompState_P3 e0 : exitState("Junction2")) {
						for (CompState_P3 e1 : e0.enterState("MOVING_RIGHT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: TRAILED */
				/* Target: WAITING_FOR_INITIALISING */
				/* Event: when(cOp13_Not_Initialised()) */
				/* Statement: -- */
				case "T30":
					for (CompState_P3 e0 : exitState("TRAILED")) {
						for (CompState_P3 e1 : e0.enterState("WAITING_FOR_INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ALL_LEFT */
				/* Target: TRAILED */
				/* Event: when(cOp5_Trailed()) */
				/* Guard: cOp7_Is_Trailable() */
				/* Statement: -- */
				case "T31":
					for (CompState_P3 e0 : exitState("ALL_LEFT")) {
						for (CompState_P3 e1 : e0.enterState("TRAILED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: TRAILED */
				/* Target: NO_END_POSITION */
				/* Event: when(cOp3_No_End_Position()) */
				/* Statement: -- */
				case "T32":
					for (CompState_P3 e0 : exitState("TRAILED")) {
						for (CompState_P3 e1 : e0.enterState("NO_END_POSITION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_RIGHT */
				/* Target: STOPPED */
				/* Event: when(cOp4_All_Right()) */
				/* Statement: -- */
				case "T33":
					for (CompState_P3 e0 : exitState("MOVING_RIGHT")) {
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: MOVING_RIGHT */
				/* Target: STOPPED */
				/* Event: after(D4_Con_tmax_Point_Operation) */
				/* Statement: cOp12_Timeout() -- */
				case "T34":
					for (CompState_P3 e0 : exitState("MOVING_RIGHT")) {
						cOp12_Timeout();
						for (CompState_P3 e1 : e0.enterState("STOPPED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: MOVING_LEFT */
				/* Guard: DT1_Move_Target <> Mem_Current_Point_Position */
				/* Statement: -- */
				case "T35":
					for (CompState_P3 e0 : exitState("Junction1")) {
						for (CompState_P3 e1 : e0.enterState("MOVING_LEFT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STOPPED */
				/* Target: Junction1 */
				/* Event: when(T1_Move) */
				/* Guard: DT1_Move_Target = "LEFT" */
				/* Statement: -- */
				case "T36":
					for (CompState_P3 e0 : exitState("STOPPED")) {
						result.add(e0);
					}
					break;
				/* Source: WAITING_FOR_INITIALISING */
				/* Target: Junction0 */
				/* Event: when(D20_F_EST_EfeS_Gen_SR_State = "INITIALISING") */
				/* Statement: -- */
				case "T37":
					for (CompState_P3 e0 : exitState("WAITING_FOR_INITIALISING")) {
						result.add(e0);
					}
					break;
				/* Source: Junction0 */
				/* Target: ALL_LEFT */
				/* Guard: cOp2_All_Left() */
				/* Statement: -- */
				case "T38":
					for (CompState_P3 e0 : exitState("Junction0")) {
						for (CompState_P3 e1 : e0.enterState("ALL_LEFT")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_SCPSEC {
		private final Set<String> vertices;
		public final In<Integer> D100_Mem_Tmax;
		public final Var<Boolean> T7_HB;
		public final Var<Boolean> T4_Terminate_SCP_Connection;
		public final In<Boolean> T3_HB_inacceptable_delayed;
		public final Var<Boolean> T8_Disc_Requ;
		public final Var<Boolean> T5_Conn_Req;
		public final Var<Boolean> T9_Disc_Requ;
		public final Var<Boolean> T1_SCP_Connection_Established;
		public final Var<Boolean> T2_SCP_Connection_Terminated;
		public final Var<Boolean> T6_Conn_Resp;
		public CompState_SCPSEC() {
			vertices = new HashSet<String>();
			D100_Mem_Tmax = new In<Integer>(0);
			T7_HB = new Var<Boolean>(false);
			T4_Terminate_SCP_Connection = new Var<Boolean>(false);
			T3_HB_inacceptable_delayed = new In<Boolean>(false);
			T8_Disc_Requ = new Var<Boolean>(false);
			T5_Conn_Req = new Var<Boolean>(false);
			T9_Disc_Requ = new Var<Boolean>(false);
			T1_SCP_Connection_Established = new Var<Boolean>(false);
			T2_SCP_Connection_Terminated = new Var<Boolean>(false);
			T6_Conn_Resp = new Var<Boolean>(false);
		}
		public CompState_SCPSEC copyFrom(CompState_SCPSEC source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			D100_Mem_Tmax.value = source.D100_Mem_Tmax.value;
			T7_HB.value = source.T7_HB.value;
			T4_Terminate_SCP_Connection.value = source.T4_Terminate_SCP_Connection.value;
			T3_HB_inacceptable_delayed.value = source.T3_HB_inacceptable_delayed.value;
			T8_Disc_Requ.value = source.T8_Disc_Requ.value;
			T5_Conn_Req.value = source.T5_Conn_Req.value;
			T9_Disc_Requ.value = source.T9_Disc_Requ.value;
			T1_SCP_Connection_Established.value = source.T1_SCP_Connection_Established.value;
			T2_SCP_Connection_Terminated.value = source.T2_SCP_Connection_Terminated.value;
			T6_Conn_Resp.value = source.T6_Conn_Resp.value;
			return this;
		}
		public static Set<CompState_SCPSEC> create() {
			return new HashSet<CompState_SCPSEC>(new CompState_SCPSEC().enterState("SCI_SCP_Sec_STD_1"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: UP */
				/* Target: Junction0 */
				/* Event: when(T8_Disc_Requ) */
				/* Statement: T2_SCP_Connection_Terminated := TRUE; -- */
				case "T":
					if (checkVertices && !vertices.contains("UP")) return false;
					if (this.T8_Disc_Requ.value) return false;
					return true;
				/* Source: START */
				/* Target: Junction0 */
				/* Event: after(D100_Mem_Tmax) */
				/* Statement: -- */
				case "T1":
					if (checkVertices && !vertices.contains("START")) return false;
					// ... timeout event ...
					return true;
				/* Source: Initial0 */
				/* Target: CLOSED */
				/* Statement: -- */
				case "T2":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: Junction1 */
				/* Target: CLOSED */
				/* Statement: T2_SCP_Connection_Terminated := TRUE; -- */
				case "T3":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					return true;
				/* Source: UP */
				/* Target: Junction1 */
				/* Event: when(T4_Terminate_SCP_Connection) */
				/* Statement: T9_Disc_Requ := TRUE; -- */
				case "T4":
					if (checkVertices && !vertices.contains("UP")) return false;
					if (this.T4_Terminate_SCP_Connection.value) return false;
					return true;
				/* Source: Junction0 */
				/* Target: CLOSED */
				/* Statement: -- */
				case "T5":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					return true;
				/* Source: START */
				/* Target: UP */
				/* Event: when(T7_HB) */
				/* Statement: T1_SCP_Connection_Established := TRUE; -- */
				case "T6":
					if (checkVertices && !vertices.contains("START")) return false;
					if (this.T7_HB.value) return false;
					return true;
				/* Source: CLOSED */
				/* Target: START */
				/* Event: when(T5_Conn_Req) */
				/* Statement: T6_Conn_Resp := TRUE; -- */
				case "T7":
					if (checkVertices && !vertices.contains("CLOSED")) return false;
					if (this.T5_Conn_Req.value) return false;
					return true;
				/* Source: UP */
				/* Target: Junction1 */
				/* Event: when(T3_HB_inacceptable_delayed) */
				/* Statement: -- */
				case "T8":
					if (checkVertices && !vertices.contains("UP")) return false;
					if (this.T3_HB_inacceptable_delayed.value) return false;
					return true;
				/* Source: START */
				/* Target: Junction0 */
				/* Event: when(T8_Disc_Requ) */
				/* Statement: -- */
				case "T9":
					if (checkVertices && !vertices.contains("START")) return false;
					if (this.T8_Disc_Requ.value) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_SCPSEC> enterState(String id) {
			Set<CompState_SCPSEC> result = new HashSet<CompState_SCPSEC>();
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(this);
			switch (id) {
				case "CLOSED":
					if (vertices.add("CLOSED")) {
						result.add(e0);
					}
					break;
				case "UP":
					if (vertices.add("UP")) {
						result.add(e0);
					}
					break;
				case "SCI_SCP_Sec_STD_1":
					if (vertices.add("SCI_SCP_Sec_STD_1")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T2")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SCPSEC> fringe = new HashSet<CompState_SCPSEC>();
									Set<CompState_SCPSEC> newFringe = new HashSet<CompState_SCPSEC>();
									fringe.add(new CompState_SCPSEC().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SCPSEC f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "START":
					if (vertices.add("START")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SCPSEC> exitState(String id) {
			Set<CompState_SCPSEC> result = new HashSet<CompState_SCPSEC>();
			CompState_SCPSEC e0 = new CompState_SCPSEC();
			switch (id) {
				case "CLOSED":
					if (vertices.remove("CLOSED")) {
						result.add(e0);
					}
					break;
				case "UP":
					if (vertices.remove("UP")) {
						result.add(e0);
					}
					break;
				case "START":
					if (vertices.remove("START")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SCPSEC> firePostExitTransitions() {
			Set<CompState_SCPSEC> result = new HashSet<CompState_SCPSEC>();
			result.add(new CompState_SCPSEC());
			return result;
		}
		private Set<CompState_SCPSEC> fireTransition(String id) {
			Set<CompState_SCPSEC> result = new HashSet<CompState_SCPSEC>();
			switch (id) {
				/* Source: UP */
				/* Target: Junction0 */
				/* Event: when(T8_Disc_Requ) */
				/* Statement: T2_SCP_Connection_Terminated := TRUE; -- */
				case "T":
					for (CompState_SCPSEC e0 : exitState("UP")) {
						e0.T2_SCP_Connection_Terminated.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				/* Source: START */
				/* Target: Junction0 */
				/* Event: after(D100_Mem_Tmax) */
				/* Statement: -- */
				case "T1":
					for (CompState_SCPSEC e0 : exitState("START")) {
						result.add(e0);
					}
					break;
				/* Source: Initial0 */
				/* Target: CLOSED */
				/* Statement: -- */
				case "T2":
					for (CompState_SCPSEC e0 : exitState("Initial0")) {
						for (CompState_SCPSEC e1 : e0.enterState("CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: CLOSED */
				/* Statement: T2_SCP_Connection_Terminated := TRUE; -- */
				case "T3":
					for (CompState_SCPSEC e0 : exitState("Junction1")) {
						e0.T2_SCP_Connection_Terminated.value = Boolean.TRUE;
						for (CompState_SCPSEC e1 : e0.enterState("CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: UP */
				/* Target: Junction1 */
				/* Event: when(T4_Terminate_SCP_Connection) */
				/* Statement: T9_Disc_Requ := TRUE; -- */
				case "T4":
					for (CompState_SCPSEC e0 : exitState("UP")) {
						e0.T9_Disc_Requ.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				/* Source: Junction0 */
				/* Target: CLOSED */
				/* Statement: -- */
				case "T5":
					for (CompState_SCPSEC e0 : exitState("Junction0")) {
						for (CompState_SCPSEC e1 : e0.enterState("CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: START */
				/* Target: UP */
				/* Event: when(T7_HB) */
				/* Statement: T1_SCP_Connection_Established := TRUE; -- */
				case "T6":
					for (CompState_SCPSEC e0 : exitState("START")) {
						e0.T1_SCP_Connection_Established.value = Boolean.TRUE;
						for (CompState_SCPSEC e1 : e0.enterState("UP")) {
							result.add(e1);
						}
					}
					break;
				/* Source: CLOSED */
				/* Target: START */
				/* Event: when(T5_Conn_Req) */
				/* Statement: T6_Conn_Resp := TRUE; -- */
				case "T7":
					for (CompState_SCPSEC e0 : exitState("CLOSED")) {
						e0.T6_Conn_Resp.value = Boolean.TRUE;
						for (CompState_SCPSEC e1 : e0.enterState("START")) {
							result.add(e1);
						}
					}
					break;
				/* Source: UP */
				/* Target: Junction1 */
				/* Event: when(T3_HB_inacceptable_delayed) */
				/* Statement: -- */
				case "T8":
					for (CompState_SCPSEC e0 : exitState("UP")) {
						result.add(e0);
					}
					break;
				/* Source: START */
				/* Target: Junction0 */
				/* Event: when(T8_Disc_Requ) */
				/* Statement: -- */
				case "T9":
					for (CompState_SCPSEC e0 : exitState("START")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_EST {
		private final Set<String> vertices;
		public final In<Boolean> T4_Booted;
		public final Var<Boolean> T16_Data_Installation_Complete;
		public final Var<Boolean> T9_PDI_Connection_Established;
		public final In<Boolean> T1_Power_On_Detected;
		public final Var<Boolean> T10_PDI_Connection_Closed;
		public final Var<Boolean> T17_Data_Update_Finished;
		public final In<Boolean> T7_Invalid_Or_Missing_Basic_Data;
		public final In<Boolean> T5_SIL_Not_Fulfilled;
		public final In<Boolean> T6_Data_Invalid;
		public final In<Boolean> T8_Data_Installation_Complete;
		public final In<Boolean> T2_Power_Off_Detected;
		public final In<Boolean> T10_SCP_Connection_Terminated;
		public final In<Boolean> T11_Data_Transmission_Timeout;
		public final In<Boolean> T3_Reset;
		public final Out<Boolean> T12_Terminate_SCP_Connection;
		public final Var<String> D51_EST_EfeS_State;
		public final Out<Boolean> D20_Con_MDM_Used;
		public final Var<Boolean> T15_Data_Update_In_Initialising;
		public final Var<Boolean> T22_Data_Update_Stop;
		public final Var<Boolean> T14_Data_Update_After_Operational;
		public final Var<Boolean> T21_Ready_For_PDI_Connection;
		public final Var<Boolean> T13_Data_Update_After_Booting;
		public final Var<Boolean> T18_Not_Ready_For_PDI_Connection;
		public CompState_EST() {
			vertices = new HashSet<String>();
			T4_Booted = new In<Boolean>(false);
			T16_Data_Installation_Complete = new Var<Boolean>(false);
			T9_PDI_Connection_Established = new Var<Boolean>(false);
			T1_Power_On_Detected = new In<Boolean>(false);
			T10_PDI_Connection_Closed = new Var<Boolean>(false);
			T17_Data_Update_Finished = new Var<Boolean>(false);
			T7_Invalid_Or_Missing_Basic_Data = new In<Boolean>(false);
			T5_SIL_Not_Fulfilled = new In<Boolean>(false);
			T6_Data_Invalid = new In<Boolean>(false);
			T8_Data_Installation_Complete = new In<Boolean>(false);
			T2_Power_Off_Detected = new In<Boolean>(false);
			T10_SCP_Connection_Terminated = new In<Boolean>(false);
			T11_Data_Transmission_Timeout = new In<Boolean>(false);
			T3_Reset = new In<Boolean>(false);
			T12_Terminate_SCP_Connection = new Out<Boolean>(false);
			D51_EST_EfeS_State = new Var<String>("");
			D20_Con_MDM_Used = new Out<Boolean>(false);
			T15_Data_Update_In_Initialising = new Var<Boolean>(false);
			T22_Data_Update_Stop = new Var<Boolean>(false);
			T14_Data_Update_After_Operational = new Var<Boolean>(false);
			T21_Ready_For_PDI_Connection = new Var<Boolean>(false);
			T13_Data_Update_After_Booting = new Var<Boolean>(false);
			T18_Not_Ready_For_PDI_Connection = new Var<Boolean>(false);
		}
		public CompState_EST copyFrom(CompState_EST source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			T4_Booted.value = source.T4_Booted.value;
			T16_Data_Installation_Complete.value = source.T16_Data_Installation_Complete.value;
			T9_PDI_Connection_Established.value = source.T9_PDI_Connection_Established.value;
			T1_Power_On_Detected.value = source.T1_Power_On_Detected.value;
			T10_PDI_Connection_Closed.value = source.T10_PDI_Connection_Closed.value;
			T17_Data_Update_Finished.value = source.T17_Data_Update_Finished.value;
			T7_Invalid_Or_Missing_Basic_Data.value = source.T7_Invalid_Or_Missing_Basic_Data.value;
			T5_SIL_Not_Fulfilled.value = source.T5_SIL_Not_Fulfilled.value;
			T6_Data_Invalid.value = source.T6_Data_Invalid.value;
			T8_Data_Installation_Complete.value = source.T8_Data_Installation_Complete.value;
			T2_Power_Off_Detected.value = source.T2_Power_Off_Detected.value;
			T10_SCP_Connection_Terminated.value = source.T10_SCP_Connection_Terminated.value;
			T11_Data_Transmission_Timeout.value = source.T11_Data_Transmission_Timeout.value;
			T3_Reset.value = source.T3_Reset.value;
			T12_Terminate_SCP_Connection.value = source.T12_Terminate_SCP_Connection.value;
			D51_EST_EfeS_State.value = source.D51_EST_EfeS_State.value;
			D20_Con_MDM_Used.value = source.D20_Con_MDM_Used.value;
			T15_Data_Update_In_Initialising.value = source.T15_Data_Update_In_Initialising.value;
			T22_Data_Update_Stop.value = source.T22_Data_Update_Stop.value;
			T14_Data_Update_After_Operational.value = source.T14_Data_Update_After_Operational.value;
			T21_Ready_For_PDI_Connection.value = source.T21_Ready_For_PDI_Connection.value;
			T13_Data_Update_After_Booting.value = source.T13_Data_Update_After_Booting.value;
			T18_Not_Ready_For_PDI_Connection.value = source.T18_Not_Ready_For_PDI_Connection.value;
			return this;
		}
		public static Set<CompState_EST> create() {
			return new HashSet<CompState_EST>(new CompState_EST().enterState("EST_EfeS_STD_2"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private void cOp1_Init1() {
			this.T18_Not_Ready_For_PDI_Connection.value = Boolean.FALSE;
			this.T13_Data_Update_After_Booting.value = Boolean.FALSE;
			this.T14_Data_Update_After_Operational.value = Boolean.FALSE;
			this.T15_Data_Update_In_Initialising.value = Boolean.FALSE;
			this.D51_EST_EfeS_State.value = "";
			this.T21_Ready_For_PDI_Connection.value = Boolean.FALSE;
			this.T22_Data_Update_Stop.value = Boolean.FALSE;
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: Initial0 */
				/* Target: NO_OPERATING_VOLTAGE */
				/* Statement: -- */
				case "T":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: Junction0 */
				/* Target: INITIALISING */
				/* Guard: not D20_Con_MDM_Used */
				/* Statement: T21_Ready_For_PDI_Connection := TRUE; -- */
				case "T1":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (Boolean.valueOf(!this.D20_Con_MDM_Used.value)) return false;
					return true;
				/* Source: INITIALISING */
				/* Target: FALLBACK_MODE */
				/* Event: when(T5_SIL_Not_Fulfilled) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; T22_Data_Update_Stop := TRUE; -- */
				case "T2":
					if (checkVertices && !vertices.contains("INITIALISING")) return false;
					if (this.T5_SIL_Not_Fulfilled.value) return false;
					return true;
				/* Source: Junction0 */
				/* Target: INITIALISING */
				/* Guard: D20_Con_MDM_Used */
				/* Statement: T13_Data_Update_After_Booting := TRUE; -- */
				case "T3":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (this.D20_Con_MDM_Used.value) return false;
					return true;
				/* Source: BOOTING */
				/* Target: FALLBACK_MODE */
				/* Event: when(T7_Invalid_Or_Missing_Basic_Data) */
				/* Statement: -- */
				case "T4":
					if (checkVertices && !vertices.contains("BOOTING")) return false;
					if (this.T7_Invalid_Or_Missing_Basic_Data.value) return false;
					return true;
				/* Source: OPERATIONAL */
				/* Target: BOOTING */
				/* Event: when(T3_Reset) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; -- */
				case "T5":
					if (checkVertices && !vertices.contains("OPERATIONAL")) return false;
					if (this.T3_Reset.value) return false;
					return true;
				/* Source: OPERATIONAL */
				/* Target: FALLBACK_MODE */
				/* Event: when(T5_SIL_Not_Fulfilled) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; -- */
				case "T6":
					if (checkVertices && !vertices.contains("OPERATIONAL")) return false;
					if (this.T5_SIL_Not_Fulfilled.value) return false;
					return true;
				/* Source: Junction1 */
				/* Target: INITIALISING */
				/* Guard: not D20_Con_MDM_Used */
				/* Statement: T21_Ready_For_PDI_Connection := TRUE; -- */
				case "T7":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (Boolean.valueOf(!this.D20_Con_MDM_Used.value)) return false;
					return true;
				/* Source: Initial1 */
				/* Target: BOOTING */
				/* Statement: -- */
				case "T8":
					if (checkVertices && !vertices.contains("Initial1")) return false;
					return true;
				/* Source: BOOTING */
				/* Target: FALLBACK_MODE */
				/* Event: when(T5_SIL_Not_Fulfilled) */
				/* Statement: -- */
				case "T9":
					if (checkVertices && !vertices.contains("BOOTING")) return false;
					if (this.T5_SIL_Not_Fulfilled.value) return false;
					return true;
				/* Source: FALLBACK_MODE */
				/* Target: BOOTING */
				/* Event: when(T3_Reset) */
				/* Statement: -- */
				case "T10":
					if (checkVertices && !vertices.contains("FALLBACK_MODE")) return false;
					if (this.T3_Reset.value) return false;
					return true;
				/* Source: INITIALISING */
				/* Target: OPERATIONAL */
				/* Event: when(T9_PDI_Connection_Established) */
				/* Statement: -- */
				case "T11":
					if (checkVertices && !vertices.contains("INITIALISING")) return false;
					if (this.T9_PDI_Connection_Established.value) return false;
					return true;
				/* Source: OPERATING_VOLTAGE_SUPPLIED */
				/* Target: NO_OPERATING_VOLTAGE */
				/* Event: when(T2_Power_Off_Detected) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; T22_Data_Update_Stop := TRUE; -- */
				case "T12":
					if (checkVertices && !vertices.contains("OPERATING_VOLTAGE_SUPPLIED")) return false;
					if (this.T2_Power_Off_Detected.value) return false;
					return true;
				/* Source: INITIALISING */
				/* Target: BOOTING */
				/* Event: when(T3_Reset) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; T22_Data_Update_Stop := TRUE; -- */
				case "T13":
					if (checkVertices && !vertices.contains("INITIALISING")) return false;
					if (this.T3_Reset.value) return false;
					return true;
				/* Source: NO_OPERATING_VOLTAGE */
				/* Target: OPERATING_VOLTAGE_SUPPLIED */
				/* Event: when(T1_Power_On_Detected) */
				/* Statement: -- */
				case "T14":
					if (checkVertices && !vertices.contains("NO_OPERATING_VOLTAGE")) return false;
					if (this.T1_Power_On_Detected.value) return false;
					return true;
				/* Source: OPERATIONAL */
				/* Target: Junction1 */
				/* Event: when(T10_PDI_Connection_Closed) */
				/* Statement: -- */
				case "T15":
					if (checkVertices && !vertices.contains("OPERATIONAL")) return false;
					if (this.T10_PDI_Connection_Closed.value) return false;
					return true;
				/* Source: Junction1 */
				/* Target: INITIALISING */
				/* Guard: D20_Con_MDM_Used */
				/* Statement: T14_Data_Update_After_Operational := TRUE; -- */
				case "T16":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (this.D20_Con_MDM_Used.value) return false;
					return true;
				/* Source: BOOTING */
				/* Target: Junction0 */
				/* Event: when(T4_Booted) */
				/* Statement: -- */
				case "T17":
					if (checkVertices && !vertices.contains("BOOTING")) return false;
					if (this.T4_Booted.value) return false;
					return true;
				/* Source: INITIALISING */
				/* Target: BOOTING */
				/* Event: when(T16_Data_Installation_Complete) */
				/* Guard: D20_Con_MDM_Used */
				/* Statement: -- */
				case "T18":
					if (checkVertices && !vertices.contains("INITIALISING")) return false;
					if (this.T16_Data_Installation_Complete.value) return false;
					if (this.D20_Con_MDM_Used.value) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_EST> enterState(String id) {
			Set<CompState_EST> result = new HashSet<CompState_EST>();
			CompState_EST e0 = new CompState_EST().copyFrom(this);
			switch (id) {
				case "BOOTING":
					if (vertices.add("BOOTING")) {
						e0.D51_EST_EfeS_State.value = "BOOTING";
						result.add(e0);
					}
					break;
				case "FALLBACK_MODE":
					if (vertices.add("FALLBACK_MODE")) {
						e0.D51_EST_EfeS_State.value = "FALLBACK_MODE";
						result.add(e0);
					}
					break;
				case "NO_OPERATING_VOLTAGE":
					if (vertices.add("NO_OPERATING_VOLTAGE")) {
						e0.D51_EST_EfeS_State.value = "NO_OPERATING_VOLTAGE;";
						result.add(e0);
					}
					break;
				case "EST_EfeS_STD_2":
					if (vertices.add("EST_EfeS_STD_2")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_EST> fringe = new HashSet<CompState_EST>();
									Set<CompState_EST> newFringe = new HashSet<CompState_EST>();
									fringe.add(new CompState_EST().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_EST f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "INITIALISING":
					if (vertices.add("INITIALISING")) {
						e0.D51_EST_EfeS_State.value = "OPERATIONAL";
						result.add(e0);
					}
					break;
				case "OPERATING_VOLTAGE_SUPPLIED":
					if (vertices.add("OPERATING_VOLTAGE_SUPPLIED")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T8")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_EST> fringe = new HashSet<CompState_EST>();
									Set<CompState_EST> newFringe = new HashSet<CompState_EST>();
									fringe.add(new CompState_EST().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_EST f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "OPERATIONAL":
					if (vertices.add("OPERATIONAL")) {
						e0.D51_EST_EfeS_State.value = "OPERATIONAL";
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_EST> exitState(String id) {
			Set<CompState_EST> result = new HashSet<CompState_EST>();
			CompState_EST e0 = new CompState_EST();
			switch (id) {
				case "BOOTING":
					if (vertices.remove("BOOTING")) {
						result.add(e0);
					}
					break;
				case "FALLBACK_MODE":
					if (vertices.remove("FALLBACK_MODE")) {
						result.add(e0);
					}
					break;
				case "NO_OPERATING_VOLTAGE":
					if (vertices.remove("NO_OPERATING_VOLTAGE")) {
						result.add(e0);
					}
					break;
				case "INITIALISING":
					if (vertices.remove("INITIALISING")) {
						result.add(e0);
					}
					break;
				case "OPERATING_VOLTAGE_SUPPLIED":
					if (vertices.remove("OPERATING_VOLTAGE_SUPPLIED")) {
						List<String> states = new ArrayList<String>();
						states.add("FALLBACK_MODE");
						states.add("BOOTING");
						states.add("INITIALISING");
						states.add("OPERATIONAL");
						for (CompState_EST e1 : e0.exitState(states.get(0))) {
							for (CompState_EST e2 : e1.exitState(states.get(1))) {
								for (CompState_EST e3 : e2.exitState(states.get(2))) {
									for (CompState_EST e4 : e3.exitState(states.get(3))) {
										result.add(e4);
									}
								}
							}
						}
					}
					break;
				case "OPERATIONAL":
					if (vertices.remove("OPERATIONAL")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_EST> firePostExitTransitions() {
			Set<CompState_EST> result = new HashSet<CompState_EST>();
			result.add(new CompState_EST());
			return result;
		}
		private Set<CompState_EST> fireTransition(String id) {
			Set<CompState_EST> result = new HashSet<CompState_EST>();
			switch (id) {
				/* Source: Initial0 */
				/* Target: NO_OPERATING_VOLTAGE */
				/* Statement: -- */
				case "T":
					for (CompState_EST e0 : exitState("Initial0")) {
						for (CompState_EST e1 : e0.enterState("NO_OPERATING_VOLTAGE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction0 */
				/* Target: INITIALISING */
				/* Guard: not D20_Con_MDM_Used */
				/* Statement: T21_Ready_For_PDI_Connection := TRUE; -- */
				case "T1":
					for (CompState_EST e0 : exitState("Junction0")) {
						e0.T21_Ready_For_PDI_Connection.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: INITIALISING */
				/* Target: FALLBACK_MODE */
				/* Event: when(T5_SIL_Not_Fulfilled) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; T22_Data_Update_Stop := TRUE; -- */
				case "T2":
					for (CompState_EST e0 : exitState("INITIALISING")) {
						e0.T18_Not_Ready_For_PDI_Connection.value = Boolean.TRUE;
						e0.T22_Data_Update_Stop.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("FALLBACK_MODE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction0 */
				/* Target: INITIALISING */
				/* Guard: D20_Con_MDM_Used */
				/* Statement: T13_Data_Update_After_Booting := TRUE; -- */
				case "T3":
					for (CompState_EST e0 : exitState("Junction0")) {
						e0.T13_Data_Update_After_Booting.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: BOOTING */
				/* Target: FALLBACK_MODE */
				/* Event: when(T7_Invalid_Or_Missing_Basic_Data) */
				/* Statement: -- */
				case "T4":
					for (CompState_EST e0 : exitState("BOOTING")) {
						for (CompState_EST e1 : e0.enterState("FALLBACK_MODE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: OPERATIONAL */
				/* Target: BOOTING */
				/* Event: when(T3_Reset) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; -- */
				case "T5":
					for (CompState_EST e0 : exitState("OPERATIONAL")) {
						e0.T18_Not_Ready_For_PDI_Connection.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("BOOTING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: OPERATIONAL */
				/* Target: FALLBACK_MODE */
				/* Event: when(T5_SIL_Not_Fulfilled) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; -- */
				case "T6":
					for (CompState_EST e0 : exitState("OPERATIONAL")) {
						e0.T18_Not_Ready_For_PDI_Connection.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("FALLBACK_MODE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: INITIALISING */
				/* Guard: not D20_Con_MDM_Used */
				/* Statement: T21_Ready_For_PDI_Connection := TRUE; -- */
				case "T7":
					for (CompState_EST e0 : exitState("Junction1")) {
						e0.T21_Ready_For_PDI_Connection.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial1 */
				/* Target: BOOTING */
				/* Statement: -- */
				case "T8":
					for (CompState_EST e0 : exitState("Initial1")) {
						for (CompState_EST e1 : e0.enterState("BOOTING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: BOOTING */
				/* Target: FALLBACK_MODE */
				/* Event: when(T5_SIL_Not_Fulfilled) */
				/* Statement: -- */
				case "T9":
					for (CompState_EST e0 : exitState("BOOTING")) {
						for (CompState_EST e1 : e0.enterState("FALLBACK_MODE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: FALLBACK_MODE */
				/* Target: BOOTING */
				/* Event: when(T3_Reset) */
				/* Statement: -- */
				case "T10":
					for (CompState_EST e0 : exitState("FALLBACK_MODE")) {
						for (CompState_EST e1 : e0.enterState("BOOTING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: INITIALISING */
				/* Target: OPERATIONAL */
				/* Event: when(T9_PDI_Connection_Established) */
				/* Statement: -- */
				case "T11":
					for (CompState_EST e0 : exitState("INITIALISING")) {
						for (CompState_EST e1 : e0.enterState("OPERATIONAL")) {
							result.add(e1);
						}
					}
					break;
				/* Source: OPERATING_VOLTAGE_SUPPLIED */
				/* Target: NO_OPERATING_VOLTAGE */
				/* Event: when(T2_Power_Off_Detected) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; T22_Data_Update_Stop := TRUE; -- */
				case "T12":
					for (CompState_EST e0 : exitState("OPERATING_VOLTAGE_SUPPLIED")) {
						e0.T18_Not_Ready_For_PDI_Connection.value = Boolean.TRUE;
						e0.T22_Data_Update_Stop.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("NO_OPERATING_VOLTAGE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: INITIALISING */
				/* Target: BOOTING */
				/* Event: when(T3_Reset) */
				/* Statement: T18_Not_Ready_For_PDI_Connection := TRUE; T22_Data_Update_Stop := TRUE; -- */
				case "T13":
					for (CompState_EST e0 : exitState("INITIALISING")) {
						e0.T18_Not_Ready_For_PDI_Connection.value = Boolean.TRUE;
						e0.T22_Data_Update_Stop.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("BOOTING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: NO_OPERATING_VOLTAGE */
				/* Target: OPERATING_VOLTAGE_SUPPLIED */
				/* Event: when(T1_Power_On_Detected) */
				/* Statement: -- */
				case "T14":
					for (CompState_EST e0 : exitState("NO_OPERATING_VOLTAGE")) {
						for (CompState_EST e1 : e0.enterState("OPERATING_VOLTAGE_SUPPLIED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: OPERATIONAL */
				/* Target: Junction1 */
				/* Event: when(T10_PDI_Connection_Closed) */
				/* Statement: -- */
				case "T15":
					for (CompState_EST e0 : exitState("OPERATIONAL")) {
						result.add(e0);
					}
					break;
				/* Source: Junction1 */
				/* Target: INITIALISING */
				/* Guard: D20_Con_MDM_Used */
				/* Statement: T14_Data_Update_After_Operational := TRUE; -- */
				case "T16":
					for (CompState_EST e0 : exitState("Junction1")) {
						e0.T14_Data_Update_After_Operational.value = Boolean.TRUE;
						for (CompState_EST e1 : e0.enterState("INITIALISING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: BOOTING */
				/* Target: Junction0 */
				/* Event: when(T4_Booted) */
				/* Statement: -- */
				case "T17":
					for (CompState_EST e0 : exitState("BOOTING")) {
						result.add(e0);
					}
					break;
				/* Source: INITIALISING */
				/* Target: BOOTING */
				/* Event: when(T16_Data_Installation_Complete) */
				/* Guard: D20_Con_MDM_Used */
				/* Statement: -- */
				case "T18":
					for (CompState_EST e0 : exitState("INITIALISING")) {
						for (CompState_EST e1 : e0.enterState("BOOTING")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_PRIM {
		private final Set<String> vertices;
		public final In<String> D3_Con_PDI_Version;
		public final Var<Boolean> T14_Msg_Start_Initialisation;
		public final In<Boolean> D23_Con_Checksum_Data_Used;
		public final In<String> D4_Con_Checksum_Data;
		public final Var<Boolean> T5_SCP_Connection_Established;
		public final In<Boolean> T22_Content_Telegram_Error;
		public final Var<String> DT13a_Result;
		public final In<Boolean> T21_Formal_Telegram_Error;
		public final Var<Boolean> T10_SCP_Connection_Terminated;
		public final In<Integer> D2_Con_tmax_PDI_Connection;
		public final Var<String> DT13b_Checksum_Data;
		public final In<Boolean> T30_Reset_Connection;
		public final Var<Boolean> T13_Msg_PDI_Version_Check;
		public final Var<Boolean> T15_Msg_Initialisation_Completed;
		public final In<Boolean> T20_Protocol_Error;
		public final Var<String> D50_PDI_Connection_State;
		public final Var<Boolean> T6_Establish_SCP_Connection;
		public final Var<Boolean> T12_Terminate_SCP_Connection;
		public final Var<Boolean> T7_Cd_PDI_Version_Check;
		public final Var<String> DT7_PDI_Version;
		public final Var<Boolean> T8_Cd_Initialisation_Request;
		public CompState_PRIM() {
			vertices = new HashSet<String>();
			D3_Con_PDI_Version = new In<String>("");
			T14_Msg_Start_Initialisation = new Var<Boolean>(false);
			D23_Con_Checksum_Data_Used = new In<Boolean>(false);
			D4_Con_Checksum_Data = new In<String>("");
			T5_SCP_Connection_Established = new Var<Boolean>(false);
			T22_Content_Telegram_Error = new In<Boolean>(false);
			DT13a_Result = new Var<String>("");
			T21_Formal_Telegram_Error = new In<Boolean>(false);
			T10_SCP_Connection_Terminated = new Var<Boolean>(false);
			D2_Con_tmax_PDI_Connection = new In<Integer>(0);
			DT13b_Checksum_Data = new Var<String>("");
			T30_Reset_Connection = new In<Boolean>(false);
			T13_Msg_PDI_Version_Check = new Var<Boolean>(false);
			T15_Msg_Initialisation_Completed = new Var<Boolean>(false);
			T20_Protocol_Error = new In<Boolean>(false);
			D50_PDI_Connection_State = new Var<String>("");
			T6_Establish_SCP_Connection = new Var<Boolean>(false);
			T12_Terminate_SCP_Connection = new Var<Boolean>(false);
			T7_Cd_PDI_Version_Check = new Var<Boolean>(false);
			DT7_PDI_Version = new Var<String>("");
			T8_Cd_Initialisation_Request = new Var<Boolean>(false);
		}
		public CompState_PRIM copyFrom(CompState_PRIM source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			D3_Con_PDI_Version.value = source.D3_Con_PDI_Version.value;
			T14_Msg_Start_Initialisation.value = source.T14_Msg_Start_Initialisation.value;
			D23_Con_Checksum_Data_Used.value = source.D23_Con_Checksum_Data_Used.value;
			D4_Con_Checksum_Data.value = source.D4_Con_Checksum_Data.value;
			T5_SCP_Connection_Established.value = source.T5_SCP_Connection_Established.value;
			T22_Content_Telegram_Error.value = source.T22_Content_Telegram_Error.value;
			DT13a_Result.value = source.DT13a_Result.value;
			T21_Formal_Telegram_Error.value = source.T21_Formal_Telegram_Error.value;
			T10_SCP_Connection_Terminated.value = source.T10_SCP_Connection_Terminated.value;
			D2_Con_tmax_PDI_Connection.value = source.D2_Con_tmax_PDI_Connection.value;
			DT13b_Checksum_Data.value = source.DT13b_Checksum_Data.value;
			T30_Reset_Connection.value = source.T30_Reset_Connection.value;
			T13_Msg_PDI_Version_Check.value = source.T13_Msg_PDI_Version_Check.value;
			T15_Msg_Initialisation_Completed.value = source.T15_Msg_Initialisation_Completed.value;
			T20_Protocol_Error.value = source.T20_Protocol_Error.value;
			D50_PDI_Connection_State.value = source.D50_PDI_Connection_State.value;
			T6_Establish_SCP_Connection.value = source.T6_Establish_SCP_Connection.value;
			T12_Terminate_SCP_Connection.value = source.T12_Terminate_SCP_Connection.value;
			T7_Cd_PDI_Version_Check.value = source.T7_Cd_PDI_Version_Check.value;
			DT7_PDI_Version.value = source.DT7_PDI_Version.value;
			T8_Cd_Initialisation_Request.value = source.T8_Cd_Initialisation_Request.value;
			return this;
		}
		public static Set<CompState_PRIM> create() {
			return new HashSet<CompState_PRIM>(new CompState_PRIM().enterState("SCI_EfeS_Prim_STD_1"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private void cOp1_init1() {
			this.D50_PDI_Connection_State.value = "";
			this.T12_Terminate_SCP_Connection.value = Boolean.FALSE;
			this.T7_Cd_PDI_Version_Check.value = Boolean.FALSE;
			this.DT7_PDI_Version.value = "";
			this.T8_Cd_Initialisation_Request.value = Boolean.FALSE;
			this.T6_Establish_SCP_Connection.value = Boolean.FALSE;
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: Junction0 */
				/* Target: Junction1 */
				/* Guard: DT13a_Result = "match" */
				/* Statement: -- */
				case "T":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (Boolean.valueOf(this.DT13a_Result.value.equals("match"))) return false;
					return true;
				/* Source: Junction0 */
				/* Target: PDI_VERSION_UNEQUAL */
				/* Guard: DT13a_Result <> "match" */
				/* Statement: -- */
				case "T1":
					if (checkVertices && !vertices.contains("Junction0")) return false;
					if (Boolean.valueOf(!this.DT13a_Result.value.equals("match"))) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T2":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T20_Protocol_Error.value) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T3":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T22_Content_Telegram_Error.value) return false;
					return true;
				/* Source: PDI_PROTOCOL_ERROR */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T4":
					if (checkVertices && !vertices.contains("PDI_PROTOCOL_ERROR")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_INIT_TIMEOUT */
				/* Event: after(D2_Con_tmax_PDI_Connection) */
				/* Statement: -- */
				case "T5":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					// ... timeout event ...
					return true;
				/* Source: PDI_CHECKSUM_UNEQUAL */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T6":
					if (checkVertices && !vertices.contains("PDI_CHECKSUM_UNEQUAL")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T7":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T21_Formal_Telegram_Error.value) return false;
					return true;
				/* Source: PDI_CONNECTION_CLOSED */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(T5_SCP_Connection_Established) */
				/* Statement: -- */
				case "T8":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_CLOSED")) return false;
					if (this.T5_SCP_Connection_Established.value) return false;
					return true;
				/* Source: Initial0 */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Statement: -- */
				case "T9":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T10":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: WAITING_FOR_INITIALISATION */
				/* Target: RECEIVING_STATUS */
				/* Event: when(T14_Msg_Start_Initialisation) */
				/* Statement: -- */
				case "T11":
					if (checkVertices && !vertices.contains("WAITING_FOR_INITIALISATION")) return false;
					if (this.T14_Msg_Start_Initialisation.value) return false;
					return true;
				/* Source: Junction2 */
				/* Target: PDI_CHECKSUM_UNEQUAL */
				/* Guard: DT13b_Checksum_Data <> D4_Con_Checksum_Data */
				/* Statement: -- */
				case "T12":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					if (Boolean.valueOf(!this.DT13b_Checksum_Data.value.equals(this.D4_Con_Checksum_Data.value))) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T13":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (this.T21_Formal_Telegram_Error.value) return false;
					return true;
				/* Source: RECEIVING_STATUS */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(T15_Msg_Initialisation_Completed) */
				/* Statement: -- */
				case "T14":
					if (checkVertices && !vertices.contains("RECEIVING_STATUS")) return false;
					if (this.T15_Msg_Initialisation_Completed.value) return false;
					return true;
				/* Source: Junction1 */
				/* Target: WAITING_FOR_INITIALISATION */
				/* Guard: not D23_Con_Checksum_Data_Used */
				/* Statement: T8_Cd_Initialisation_Request := TRUE; -- */
				case "T15":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (Boolean.valueOf(!this.D23_Con_Checksum_Data_Used.value)) return false;
					return true;
				/* Source: PDI_TELEGRAM_ERROR */
				/* Target: PDI_CONNECTION_IMPERMISSIBLE */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T16":
					if (checkVertices && !vertices.contains("PDI_TELEGRAM_ERROR")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: PDI_VERSION_UNEQUAL */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T17":
					if (checkVertices && !vertices.contains("PDI_VERSION_UNEQUAL")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: WAITING_FOR_VERSION_CHECK */
				/* Target: Junction0 */
				/* Event: when(T13_Msg_PDI_Version_Check) */
				/* Statement: -- */
				case "T18":
					if (checkVertices && !vertices.contains("WAITING_FOR_VERSION_CHECK")) return false;
					if (this.T13_Msg_PDI_Version_Check.value) return false;
					return true;
				/* Source: PDI_INIT_TIMEOUT */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T19":
					if (checkVertices && !vertices.contains("PDI_INIT_TIMEOUT")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: Junction2 */
				/* Target: WAITING_FOR_INITIALISATION */
				/* Guard: DT13b_Checksum_Data = D4_Con_Checksum_Data */
				/* Statement: T8_Cd_Initialisation_Request := TRUE; -- */
				case "T20":
					if (checkVertices && !vertices.contains("Junction2")) return false;
					if (Boolean.valueOf(this.DT13b_Checksum_Data.value.equals(this.D4_Con_Checksum_Data.value))) return false;
					return true;
				/* Source: PDI_CONNECTION_IMPERMISSIBLE */
				/* Target: Final0 */
				/* Statement: -- */
				case "T21":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_IMPERMISSIBLE")) return false;
					return true;
				/* Source: Junction1 */
				/* Target: Junction2 */
				/* Guard: D23_Con_Checksum_Data_Used */
				/* Statement: -- */
				case "T22":
					if (checkVertices && !vertices.contains("Junction1")) return false;
					if (this.D23_Con_Checksum_Data_Used.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T23":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T20_Protocol_Error.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T24":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T22_Content_Telegram_Error.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T25":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (this.T10_SCP_Connection_Terminated.value) return false;
					return true;
				/* Source: Initial1 */
				/* Target: WAITING_FOR_VERSION_CHECK */
				/* Statement: DT7_PDI_Version := D3_Con_PDI_Version; T7_Cd_PDI_Version_Check := TRUE; -- */
				case "T26":
					if (checkVertices && !vertices.contains("Initial1")) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_PRIM> enterState(String id) {
			Set<CompState_PRIM> result = new HashSet<CompState_PRIM>();
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(this);
			switch (id) {
				case "RECEIVING_STATUS":
					if (vertices.add("RECEIVING_STATUS")) {
						e0.D50_PDI_Connection_State.value = "RECEIVING_STATUS";
						result.add(e0);
					}
					break;
				case "PDI_VERSION_UNEQUAL":
					if (vertices.add("PDI_VERSION_UNEQUAL")) {
						e0.D50_PDI_Connection_State.value = "VERSION_UNEQUAL";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "ESTABLISHING_PDI_CONNECTION":
					if (vertices.add("ESTABLISHING_PDI_CONNECTION")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T26")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_PRIM> fringe = new HashSet<CompState_PRIM>();
									Set<CompState_PRIM> newFringe = new HashSet<CompState_PRIM>();
									fringe.add(new CompState_PRIM().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_PRIM f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "WAITING_FOR_VERSION_CHECK":
					if (vertices.add("WAITING_FOR_VERSION_CHECK")) {
						e0.D50_PDI_Connection_State.value = "WAITING_FOR_VERSION_CHECK";
						result.add(e0);
					}
					break;
				case "SCI_EfeS_Prim_STD_1":
					if (vertices.add("SCI_EfeS_Prim_STD_1")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T9")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_PRIM> fringe = new HashSet<CompState_PRIM>();
									Set<CompState_PRIM> newFringe = new HashSet<CompState_PRIM>();
									fringe.add(new CompState_PRIM().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_PRIM f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "PDI_CONNECTION_CLOSED":
					if (vertices.add("PDI_CONNECTION_CLOSED")) {
						e0.D50_PDI_Connection_State.value = "CLOSED_REQUESTED";
						e0.T6_Establish_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.add("PDI_CONNECTION_ESTABLISHED")) {
						e0.D50_PDI_Connection_State.value = "ESTABLISHED";
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_IMPERMISSIBLE":
					if (vertices.add("PDI_CONNECTION_IMPERMISSIBLE")) {
						e0.D50_PDI_Connection_State.value = "IMPERMISSIBLE";
						result.add(e0);
					}
					break;
				case "PDI_INIT_TIMEOUT":
					if (vertices.add("PDI_INIT_TIMEOUT")) {
						e0.D50_PDI_Connection_State.value = "TIMEOUT";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "PDI_PROTOCOL_ERROR":
					if (vertices.add("PDI_PROTOCOL_ERROR")) {
						e0.D50_PDI_Connection_State.value = "PROTOCOL_ERROR";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "PDI_TELEGRAM_ERROR":
					if (vertices.add("PDI_TELEGRAM_ERROR")) {
						e0.D50_PDI_Connection_State.value = "TELEGRAM_ERROR";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				case "WAITING_FOR_INITIALISATION":
					if (vertices.add("WAITING_FOR_INITIALISATION")) {
						e0.D50_PDI_Connection_State.value = "WAITING_FOR_INITIALISATION";
						result.add(e0);
					}
					break;
				case "PDI_CHECKSUM_UNEQUAL":
					if (vertices.add("PDI_CHECKSUM_UNEQUAL")) {
						e0.D50_PDI_Connection_State.value = "CHECKSUM_UNEQUAL";
						e0.T12_Terminate_SCP_Connection.value = Boolean.TRUE;
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_PRIM> exitState(String id) {
			Set<CompState_PRIM> result = new HashSet<CompState_PRIM>();
			CompState_PRIM e0 = new CompState_PRIM();
			switch (id) {
				case "RECEIVING_STATUS":
					if (vertices.remove("RECEIVING_STATUS")) {
						result.add(e0);
					}
					break;
				case "PDI_VERSION_UNEQUAL":
					if (vertices.remove("PDI_VERSION_UNEQUAL")) {
						result.add(e0);
					}
					break;
				case "ESTABLISHING_PDI_CONNECTION":
					if (vertices.remove("ESTABLISHING_PDI_CONNECTION")) {
						List<String> states = new ArrayList<String>();
						states.add("WAITING_FOR_VERSION_CHECK");
						states.add("RECEIVING_STATUS");
						states.add("WAITING_FOR_INITIALISATION");
						for (CompState_PRIM e1 : e0.exitState(states.get(0))) {
							for (CompState_PRIM e2 : e1.exitState(states.get(1))) {
								for (CompState_PRIM e3 : e2.exitState(states.get(2))) {
									result.add(e3);
								}
							}
						}
					}
					break;
				case "WAITING_FOR_VERSION_CHECK":
					if (vertices.remove("WAITING_FOR_VERSION_CHECK")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_CLOSED":
					if (vertices.remove("PDI_CONNECTION_CLOSED")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.remove("PDI_CONNECTION_ESTABLISHED")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_IMPERMISSIBLE":
					if (vertices.remove("PDI_CONNECTION_IMPERMISSIBLE")) {
						result.add(e0);
					}
					break;
				case "PDI_INIT_TIMEOUT":
					if (vertices.remove("PDI_INIT_TIMEOUT")) {
						result.add(e0);
					}
					break;
				case "PDI_PROTOCOL_ERROR":
					if (vertices.remove("PDI_PROTOCOL_ERROR")) {
						result.add(e0);
					}
					break;
				case "PDI_TELEGRAM_ERROR":
					if (vertices.remove("PDI_TELEGRAM_ERROR")) {
						result.add(e0);
					}
					break;
				case "WAITING_FOR_INITIALISATION":
					if (vertices.remove("WAITING_FOR_INITIALISATION")) {
						result.add(e0);
					}
					break;
				case "PDI_CHECKSUM_UNEQUAL":
					if (vertices.remove("PDI_CHECKSUM_UNEQUAL")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_PRIM> firePostExitTransitions() {
			Set<CompState_PRIM> result = new HashSet<CompState_PRIM>();
			result.add(new CompState_PRIM());
			return result;
		}
		private Set<CompState_PRIM> fireTransition(String id) {
			Set<CompState_PRIM> result = new HashSet<CompState_PRIM>();
			switch (id) {
				/* Source: Junction0 */
				/* Target: Junction1 */
				/* Guard: DT13a_Result = "match" */
				/* Statement: -- */
				case "T":
					for (CompState_PRIM e0 : exitState("Junction0")) {
						result.add(e0);
					}
					break;
				/* Source: Junction0 */
				/* Target: PDI_VERSION_UNEQUAL */
				/* Guard: DT13a_Result <> "match" */
				/* Statement: -- */
				case "T1":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_VERSION_UNEQUAL")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T2":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_PROTOCOL_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T3":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_PROTOCOL_ERROR */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T4":
					for (CompState_PRIM e0 : exitState("PDI_PROTOCOL_ERROR")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_INIT_TIMEOUT */
				/* Event: after(D2_Con_tmax_PDI_Connection) */
				/* Statement: -- */
				case "T5":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_INIT_TIMEOUT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CHECKSUM_UNEQUAL */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T6":
					for (CompState_PRIM e0 : exitState("PDI_CHECKSUM_UNEQUAL")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T7":
					for (CompState_PRIM e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_CLOSED */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(T5_SCP_Connection_Established) */
				/* Statement: -- */
				case "T8":
					for (CompState_PRIM e0 : exitState("PDI_CONNECTION_CLOSED")) {
						for (CompState_PRIM e1 : e0.enterState("ESTABLISHING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial0 */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Statement: -- */
				case "T9":
					for (CompState_PRIM e0 : exitState("Initial0")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T10":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: WAITING_FOR_INITIALISATION */
				/* Target: RECEIVING_STATUS */
				/* Event: when(T14_Msg_Start_Initialisation) */
				/* Statement: -- */
				case "T11":
					for (CompState_PRIM e0 : exitState("WAITING_FOR_INITIALISATION")) {
						for (CompState_PRIM e1 : e0.enterState("RECEIVING_STATUS")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction2 */
				/* Target: PDI_CHECKSUM_UNEQUAL */
				/* Guard: DT13b_Checksum_Data <> D4_Con_Checksum_Data */
				/* Statement: -- */
				case "T12":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CHECKSUM_UNEQUAL")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T21_Formal_Telegram_Error) */
				/* Statement: -- */
				case "T13":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: RECEIVING_STATUS */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(T15_Msg_Initialisation_Completed) */
				/* Statement: -- */
				case "T14":
					for (CompState_PRIM e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_ESTABLISHED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction1 */
				/* Target: WAITING_FOR_INITIALISATION */
				/* Guard: not D23_Con_Checksum_Data_Used */
				/* Statement: T8_Cd_Initialisation_Request := TRUE; -- */
				case "T15":
					for (CompState_PRIM e0 : exitState("Junction1")) {
						e0.T8_Cd_Initialisation_Request.value = Boolean.TRUE;
						for (CompState_PRIM e1 : e0.enterState("WAITING_FOR_INITIALISATION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_TELEGRAM_ERROR */
				/* Target: PDI_CONNECTION_IMPERMISSIBLE */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T16":
					for (CompState_PRIM e0 : exitState("PDI_TELEGRAM_ERROR")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_IMPERMISSIBLE")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_VERSION_UNEQUAL */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T17":
					for (CompState_PRIM e0 : exitState("PDI_VERSION_UNEQUAL")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: WAITING_FOR_VERSION_CHECK */
				/* Target: Junction0 */
				/* Event: when(T13_Msg_PDI_Version_Check) */
				/* Statement: -- */
				case "T18":
					for (CompState_PRIM e0 : exitState("WAITING_FOR_VERSION_CHECK")) {
						result.add(e0);
					}
					break;
				/* Source: PDI_INIT_TIMEOUT */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T19":
					for (CompState_PRIM e0 : exitState("PDI_INIT_TIMEOUT")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Junction2 */
				/* Target: WAITING_FOR_INITIALISATION */
				/* Guard: DT13b_Checksum_Data = D4_Con_Checksum_Data */
				/* Statement: T8_Cd_Initialisation_Request := TRUE; -- */
				case "T20":
					for (CompState_PRIM e0 : exitState("Junction2")) {
						e0.T8_Cd_Initialisation_Request.value = Boolean.TRUE;
						for (CompState_PRIM e1 : e0.enterState("WAITING_FOR_INITIALISATION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_IMPERMISSIBLE */
				/* Target: Final0 */
				/* Statement: -- */
				case "T21":
					for (CompState_PRIM e0 : exitState("PDI_CONNECTION_IMPERMISSIBLE")) {
						result.add(e0);
					}
					break;
				/* Source: Junction1 */
				/* Target: Junction2 */
				/* Guard: D23_Con_Checksum_Data_Used */
				/* Statement: -- */
				case "T22":
					for (CompState_PRIM e0 : exitState("Junction1")) {
						result.add(e0);
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_PROTOCOL_ERROR */
				/* Event: when(T20_Protocol_Error) */
				/* Statement: -- */
				case "T23":
					for (CompState_PRIM e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_PROTOCOL_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_TELEGRAM_ERROR */
				/* Event: when(T22_Content_Telegram_Error) */
				/* Statement: -- */
				case "T24":
					for (CompState_PRIM e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_TELEGRAM_ERROR")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: PDI_CONNECTION_CLOSED */
				/* Event: when(T10_SCP_Connection_Terminated) */
				/* Statement: -- */
				case "T25":
					for (CompState_PRIM e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_PRIM e1 : e0.enterState("PDI_CONNECTION_CLOSED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial1 */
				/* Target: WAITING_FOR_VERSION_CHECK */
				/* Statement: DT7_PDI_Version := D3_Con_PDI_Version; T7_Cd_PDI_Version_Check := TRUE; -- */
				case "T26":
					for (CompState_PRIM e0 : exitState("Initial1")) {
						e0.DT7_PDI_Version.value = e0.D3_Con_PDI_Version.value;
						e0.T7_Cd_PDI_Version_Check.value = Boolean.TRUE;
						for (CompState_PRIM e1 : e0.enterState("WAITING_FOR_VERSION_CHECK")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_FP {
		private final Set<String> vertices;
		public final Var<Boolean> T30_Report_Timeout;
		public final Var<String> DT20_Point_Position;
		public final Var<String> DT1_Move_Point_Target;
		public final Var<String> D21_F_SCI_EfeS_Gen_SR_State;
		public final Var<Boolean> T1_Cd_Move_Point;
		public final Var<Boolean> T20_Point_Position;
		public final Var<Boolean> T18_Start_Status_Report;
		public final Var<Boolean> T10_Move;
		public final Var<String> DT2_Point_Position;
		public final Var<Boolean> T11_Stop_Operation;
		public final Var<Boolean> T40_Send_Status_Report;
		public final Var<Boolean> T23_Sending_Status_Report_Completed;
		public final Var<Boolean> T3_Msg_Timeout;
		public final Var<String> DT10_Move_Target;
		public final Var<Boolean> T2_Msg_Point_Position;
		public final Var<String> Mem_Point_Position;
		public final Var<String> Mem_Move_Point;
		public CompState_FP() {
			vertices = new HashSet<String>();
			T30_Report_Timeout = new Var<Boolean>(false);
			DT20_Point_Position = new Var<String>("");
			DT1_Move_Point_Target = new Var<String>("");
			D21_F_SCI_EfeS_Gen_SR_State = new Var<String>("");
			T1_Cd_Move_Point = new Var<Boolean>(false);
			T20_Point_Position = new Var<Boolean>(false);
			T18_Start_Status_Report = new Var<Boolean>(false);
			T10_Move = new Var<Boolean>(false);
			DT2_Point_Position = new Var<String>("");
			T11_Stop_Operation = new Var<Boolean>(false);
			T40_Send_Status_Report = new Var<Boolean>(false);
			T23_Sending_Status_Report_Completed = new Var<Boolean>(false);
			T3_Msg_Timeout = new Var<Boolean>(false);
			DT10_Move_Target = new Var<String>("");
			T2_Msg_Point_Position = new Var<Boolean>(false);
			Mem_Point_Position = new Var<String>("");
			Mem_Move_Point = new Var<String>("");
		}
		public CompState_FP copyFrom(CompState_FP source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			T30_Report_Timeout.value = source.T30_Report_Timeout.value;
			DT20_Point_Position.value = source.DT20_Point_Position.value;
			DT1_Move_Point_Target.value = source.DT1_Move_Point_Target.value;
			D21_F_SCI_EfeS_Gen_SR_State.value = source.D21_F_SCI_EfeS_Gen_SR_State.value;
			T1_Cd_Move_Point.value = source.T1_Cd_Move_Point.value;
			T20_Point_Position.value = source.T20_Point_Position.value;
			T18_Start_Status_Report.value = source.T18_Start_Status_Report.value;
			T10_Move.value = source.T10_Move.value;
			DT2_Point_Position.value = source.DT2_Point_Position.value;
			T11_Stop_Operation.value = source.T11_Stop_Operation.value;
			T40_Send_Status_Report.value = source.T40_Send_Status_Report.value;
			T23_Sending_Status_Report_Completed.value = source.T23_Sending_Status_Report_Completed.value;
			T3_Msg_Timeout.value = source.T3_Msg_Timeout.value;
			DT10_Move_Target.value = source.DT10_Move_Target.value;
			T2_Msg_Point_Position.value = source.T2_Msg_Point_Position.value;
			Mem_Point_Position.value = source.Mem_Point_Position.value;
			Mem_Move_Point.value = source.Mem_Move_Point.value;
			return this;
		}
		public static Set<CompState_FP> create() {
			return new HashSet<CompState_FP>(new CompState_FP().enterState("SCI_P_STD_2"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private void cOp1_init2() {
			this.T2_Msg_Point_Position.value = Boolean.FALSE;
			this.DT2_Point_Position.value = "";
			this.T3_Msg_Timeout.value = Boolean.FALSE;
			this.DT10_Move_Target.value = "";
			this.T11_Stop_Operation.value = Boolean.FALSE;
			this.T23_Sending_Status_Report_Completed.value = Boolean.FALSE;
			this.T40_Send_Status_Report.value = Boolean.FALSE;
			this.Mem_Move_Point.value = "";
			this.Mem_Point_Position.value = "";
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position = DT20_Point_Position */
				/* Statement: -- */
				case "T":
					if (checkVertices && !vertices.contains("STATUS_REPORTED")) return false;
					if (Boolean.valueOf(this.D21_F_SCI_EfeS_Gen_SR_State.value.equals("ESTABLISHED"))) return false;
					if (Boolean.valueOf(this.Mem_Point_Position.value.equals(this.DT20_Point_Position.value))) return false;
					return true;
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position <> DT20_Point_Position */
				/* Statement: Mem_Point_Position := DT20_Point_Position; DT2_Point_Position := DT20_Point_Position; T2_Msg_Point_Position := TRUE; -- */
				case "T1":
					if (checkVertices && !vertices.contains("STATUS_REPORTED")) return false;
					if (Boolean.valueOf(this.D21_F_SCI_EfeS_Gen_SR_State.value.equals("ESTABLISHED"))) return false;
					if (Boolean.valueOf(!this.Mem_Point_Position.value.equals(this.DT20_Point_Position.value))) return false;
					return true;
				/* Source: Initial1 */
				/* Target: WATING */
				/* Statement: -- */
				case "T2":
					if (checkVertices && !vertices.contains("Initial1")) return false;
					return true;
				/* Source: REPORT_STATUS */
				/* Target: STATUS_REPORTED */
				/* Event: when(T20_Point_Position) */
				/* Statement: DT2_Point_Position := DT20_Point_Position; T2_Msg_Point_Position := TRUE; Mem_Point_Position := DT20_Point_Position; T23_Sending_Status_Report_Completed := TRUE; -- */
				case "T3":
					if (checkVertices && !vertices.contains("REPORT_STATUS")) return false;
					if (this.T20_Point_Position.value) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State <> "ESTABLISHED") */
				/* Statement: -- */
				case "T4":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (Boolean.valueOf(!this.D21_F_SCI_EfeS_Gen_SR_State.value.equals("ESTABLISHED"))) return false;
					return true;
				/* Source: WATING */
				/* Target: REPORT_STATUS */
				/* Event: when(T18_Start_Status_Report) */
				/* Statement: T40_Send_Status_Report := TRUE; -- */
				case "T5":
					if (checkVertices && !vertices.contains("WATING")) return false;
					if (this.T18_Start_Status_Report.value) return false;
					return true;
				/* Source: Initial0 */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Statement: -- */
				case "T6":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State = "CLOSED") */
				/* Statement: -- */
				case "T7":
					if (checkVertices && !vertices.contains("ESTABLISHING_PDI_CONNECTION")) return false;
					if (Boolean.valueOf(this.D21_F_SCI_EfeS_Gen_SR_State.value.equals("CLOSED"))) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_FP> enterState(String id) {
			Set<CompState_FP> result = new HashSet<CompState_FP>();
			CompState_FP e0 = new CompState_FP().copyFrom(this);
			switch (id) {
				case "WATING":
					if (vertices.add("WATING")) {
						result.add(e0);
					}
					break;
				case "SCI_P_STD_2":
					if (vertices.add("SCI_P_STD_2")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T6")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_FP> fringe = new HashSet<CompState_FP>();
									Set<CompState_FP> newFringe = new HashSet<CompState_FP>();
									fringe.add(new CompState_FP().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_FP f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "STATUS_REPORTED":
					if (vertices.add("STATUS_REPORTED")) {
						result.add(e0);
					}
					break;
				case "ESTABLISHING_PDI_CONNECTION":
					if (vertices.add("ESTABLISHING_PDI_CONNECTION")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T2")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_FP> fringe = new HashSet<CompState_FP>();
									Set<CompState_FP> newFringe = new HashSet<CompState_FP>();
									fringe.add(new CompState_FP().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_FP f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "REPORT_STATUS":
					if (vertices.add("REPORT_STATUS")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.add("PDI_CONNECTION_ESTABLISHED")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_FP> exitState(String id) {
			Set<CompState_FP> result = new HashSet<CompState_FP>();
			CompState_FP e0 = new CompState_FP();
			switch (id) {
				case "WATING":
					if (vertices.remove("WATING")) {
						result.add(e0);
					}
					break;
				case "STATUS_REPORTED":
					if (vertices.remove("STATUS_REPORTED")) {
						result.add(e0);
					}
					break;
				case "ESTABLISHING_PDI_CONNECTION":
					if (vertices.remove("ESTABLISHING_PDI_CONNECTION")) {
						List<String> states = new ArrayList<String>();
						states.add("WATING");
						states.add("STATUS_REPORTED");
						states.add("REPORT_STATUS");
						for (CompState_FP e1 : e0.exitState(states.get(0))) {
							for (CompState_FP e2 : e1.exitState(states.get(1))) {
								for (CompState_FP e3 : e2.exitState(states.get(2))) {
									result.add(e3);
								}
							}
						}
					}
					break;
				case "REPORT_STATUS":
					if (vertices.remove("REPORT_STATUS")) {
						result.add(e0);
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.remove("PDI_CONNECTION_ESTABLISHED")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_FP> firePostExitTransitions() {
			Set<CompState_FP> result = new HashSet<CompState_FP>();
			result.add(new CompState_FP());
			return result;
		}
		private Set<CompState_FP> fireTransition(String id) {
			Set<CompState_FP> result = new HashSet<CompState_FP>();
			switch (id) {
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position = DT20_Point_Position */
				/* Statement: -- */
				case "T":
					for (CompState_FP e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_FP e1 : e0.enterState("PDI_CONNECTION_ESTABLISHED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position <> DT20_Point_Position */
				/* Statement: Mem_Point_Position := DT20_Point_Position; DT2_Point_Position := DT20_Point_Position; T2_Msg_Point_Position := TRUE; -- */
				case "T1":
					for (CompState_FP e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						e0.Mem_Point_Position.value = e0.DT20_Point_Position.value;
						e0.DT2_Point_Position.value = e0.DT20_Point_Position.value;
						e0.T2_Msg_Point_Position.value = Boolean.TRUE;
						for (CompState_FP e1 : e0.enterState("PDI_CONNECTION_ESTABLISHED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial1 */
				/* Target: WATING */
				/* Statement: -- */
				case "T2":
					for (CompState_FP e0 : exitState("Initial1")) {
						for (CompState_FP e1 : e0.enterState("WATING")) {
							result.add(e1);
						}
					}
					break;
				/* Source: REPORT_STATUS */
				/* Target: STATUS_REPORTED */
				/* Event: when(T20_Point_Position) */
				/* Statement: DT2_Point_Position := DT20_Point_Position; T2_Msg_Point_Position := TRUE; Mem_Point_Position := DT20_Point_Position; T23_Sending_Status_Report_Completed := TRUE; -- */
				case "T3":
					for (CompState_FP e0 : exitState("REPORT_STATUS")) {
						e0.DT2_Point_Position.value = e0.DT20_Point_Position.value;
						e0.T2_Msg_Point_Position.value = Boolean.TRUE;
						e0.Mem_Point_Position.value = e0.DT20_Point_Position.value;
						e0.T23_Sending_Status_Report_Completed.value = Boolean.TRUE;
						for (CompState_FP e1 : e0.enterState("STATUS_REPORTED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State <> "ESTABLISHED") */
				/* Statement: -- */
				case "T4":
					for (CompState_FP e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_FP e1 : e0.enterState("ESTABLISHING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: WATING */
				/* Target: REPORT_STATUS */
				/* Event: when(T18_Start_Status_Report) */
				/* Statement: T40_Send_Status_Report := TRUE; -- */
				case "T5":
					for (CompState_FP e0 : exitState("WATING")) {
						e0.T40_Send_Status_Report.value = Boolean.TRUE;
						for (CompState_FP e1 : e0.enterState("REPORT_STATUS")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial0 */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Statement: -- */
				case "T6":
					for (CompState_FP e0 : exitState("Initial0")) {
						for (CompState_FP e1 : e0.enterState("ESTABLISHING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				/* Source: ESTABLISHING_PDI_CONNECTION */
				/* Target: ESTABLISHING_PDI_CONNECTION */
				/* Event: when(D21_F_SCI_EfeS_Gen_SR_State = "CLOSED") */
				/* Statement: -- */
				case "T7":
					for (CompState_FP e0 : exitState("ESTABLISHING_PDI_CONNECTION")) {
						for (CompState_FP e1 : e0.enterState("ESTABLISHING_PDI_CONNECTION")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public static class CompState_SP {
		private final Set<String> vertices;
		public final Var<String> DT2_Point_Position;
		public final Var<Boolean> T3_Msg_Timeout;
		public final Var<String> D21_S_SCI_EfeS_Gen_SR_State;
		public final In<String> DT10_Move_Point;
		public final Var<Boolean> T2_Msg_Point_Position;
		public final In<Boolean> T10_Move_Point;
		public final Out<Boolean> T30_Timeout;
		public final Out<String> DT20_Point_Position;
		public final Var<Boolean> T1_Cd_Move_Point;
		public final Var<String> DT1_Move_Point_Target;
		public final Out<Boolean> T20_Point_Position;
		public final Var<String> Mem_Point_Position;
		public final Var<String> Mem_Move_Point;
		public CompState_SP() {
			vertices = new HashSet<String>();
			DT2_Point_Position = new Var<String>("");
			T3_Msg_Timeout = new Var<Boolean>(false);
			D21_S_SCI_EfeS_Gen_SR_State = new Var<String>("");
			DT10_Move_Point = new In<String>("");
			T2_Msg_Point_Position = new Var<Boolean>(false);
			T10_Move_Point = new In<Boolean>(false);
			T30_Timeout = new Out<Boolean>(false);
			DT20_Point_Position = new Out<String>("");
			T1_Cd_Move_Point = new Var<Boolean>(false);
			DT1_Move_Point_Target = new Var<String>("");
			T20_Point_Position = new Out<Boolean>(false);
			Mem_Point_Position = new Var<String>("");
			Mem_Move_Point = new Var<String>("");
		}
		public CompState_SP copyFrom(CompState_SP source) {
			vertices.clear();
			vertices.addAll(source.vertices);
			DT2_Point_Position.value = source.DT2_Point_Position.value;
			T3_Msg_Timeout.value = source.T3_Msg_Timeout.value;
			D21_S_SCI_EfeS_Gen_SR_State.value = source.D21_S_SCI_EfeS_Gen_SR_State.value;
			DT10_Move_Point.value = source.DT10_Move_Point.value;
			T2_Msg_Point_Position.value = source.T2_Msg_Point_Position.value;
			T10_Move_Point.value = source.T10_Move_Point.value;
			T30_Timeout.value = source.T30_Timeout.value;
			DT20_Point_Position.value = source.DT20_Point_Position.value;
			T1_Cd_Move_Point.value = source.T1_Cd_Move_Point.value;
			DT1_Move_Point_Target.value = source.DT1_Move_Point_Target.value;
			T20_Point_Position.value = source.T20_Point_Position.value;
			Mem_Point_Position.value = source.Mem_Point_Position.value;
			Mem_Move_Point.value = source.Mem_Move_Point.value;
			return this;
		}
		public static Set<CompState_SP> create() {
			return new HashSet<CompState_SP>(new CompState_SP().enterState("SCI_P_STD_1"));
		}
		public Set<String> getVertices() {
			return Collections.unmodifiableSet(vertices);
		}
		private void cOp1_Init2() {
			this.T1_Cd_Move_Point.value = Boolean.FALSE;
			this.DT1_Move_Point_Target.value = "";
			this.T20_Point_Position.value = Boolean.FALSE;
			this.DT20_Point_Position.value = "";
			this.T30_Timeout.value = Boolean.FALSE;
			this.Mem_Move_Point.value = "";
			this.Mem_Point_Position.value = "";
		}
		private boolean isTransitionEnabled(String id, boolean checkVertices) {
			switch (id) {
				/* Source: REPORT_STATUS */
				/* Target: STATUS_REPORTED */
				/* Event: when(T2_Msg_Point_Position) */
				/* Statement: DT20_Point_Position := DT2_Point_Position; T20_Point_Position := TRUE; Mem_Point_Position := DT2_Point_Position; -- */
				case "T":
					if (checkVertices && !vertices.contains("REPORT_STATUS")) return false;
					if (this.T2_Msg_Point_Position.value) return false;
					return true;
				/* Source: RECEIVING_STATUS_REPORT */
				/* Target: RECEIVING_STATUS_REPORT */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State = "CLOSED") */
				/* Statement: -- */
				case "T1":
					if (checkVertices && !vertices.contains("RECEIVING_STATUS_REPORT")) return false;
					if (Boolean.valueOf(this.D21_S_SCI_EfeS_Gen_SR_State.value.equals("CLOSED"))) return false;
					return true;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: RECEIVING_STATUS_REPORT */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State <> "ESTABLISHED") */
				/* Statement: -- */
				case "T2":
					if (checkVertices && !vertices.contains("PDI_CONNECTION_ESTABLISHED")) return false;
					if (Boolean.valueOf(!this.D21_S_SCI_EfeS_Gen_SR_State.value.equals("ESTABLISHED"))) return false;
					return true;
				/* Source: Initial1 */
				/* Target: REPORT_STATUS */
				/* Statement: -- */
				case "T3":
					if (checkVertices && !vertices.contains("Initial1")) return false;
					return true;
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position <> DT2_Point_Position */
				/* Statement: Mem_Point_Position := DT2_Point_Position; DT20_Point_Position := DT2_Point_Position; T20_Point_Position := TRUE; -- */
				case "T4":
					if (checkVertices && !vertices.contains("STATUS_REPORTED")) return false;
					if (Boolean.valueOf(this.D21_S_SCI_EfeS_Gen_SR_State.value.equals("ESTABLISHED"))) return false;
					if (Boolean.valueOf(!this.Mem_Point_Position.value.equals(this.DT2_Point_Position.value))) return false;
					return true;
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position = DT2_Point_Position */
				/* Statement: -- */
				case "T5":
					if (checkVertices && !vertices.contains("STATUS_REPORTED")) return false;
					if (Boolean.valueOf(this.D21_S_SCI_EfeS_Gen_SR_State.value.equals("ESTABLISHED"))) return false;
					if (Boolean.valueOf(this.Mem_Point_Position.value.equals(this.DT2_Point_Position.value))) return false;
					return true;
				/* Source: Initial0 */
				/* Target: RECEIVING_STATUS_REPORT */
				/* Statement: -- */
				case "T6":
					if (checkVertices && !vertices.contains("Initial0")) return false;
					return true;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
		}
		private Set<CompState_SP> enterState(String id) {
			Set<CompState_SP> result = new HashSet<CompState_SP>();
			CompState_SP e0 = new CompState_SP().copyFrom(this);
			switch (id) {
				case "RECEIVING_STATUS_REPORT":
					if (vertices.add("RECEIVING_STATUS_REPORT")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T3")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SP> fringe = new HashSet<CompState_SP>();
									Set<CompState_SP> newFringe = new HashSet<CompState_SP>();
									fringe.add(new CompState_SP().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SP f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.add("PDI_CONNECTION_ESTABLISHED")) {
						result.add(e0);
					}
					break;
				case "STATUS_REPORTED":
					if (vertices.add("STATUS_REPORTED")) {
						result.add(e0);
					}
					break;
				case "SCI_P_STD_1":
					if (vertices.add("SCI_P_STD_1")) {
						List<List<List<String>>> routesPerInitialVertex = Arrays.asList(Arrays.asList(Arrays.asList("T6")));
						for (List<List<List<String>>> rts : getAllOrderings(routesPerInitialVertex)) {
							for (List<List<String>> rt : getAllPermutations(rts)) {
								boolean add = true;
								for (List<String> r : rt) {
									for (String step : r) {
										if (!e0.isTransitionEnabled(step, false)) {
											add = false;
											break;
										}
									}
									if (!add) break;
								}
								if (add) {
									Set<CompState_SP> fringe = new HashSet<CompState_SP>();
									Set<CompState_SP> newFringe = new HashSet<CompState_SP>();
									fringe.add(new CompState_SP().copyFrom(e0));
									for (List<String> r : rt) {
										for (String step : r) {
											newFringe.clear();
											for (CompState_SP f : fringe) {
												newFringe.addAll(f.fireTransition(step));
											}
											fringe.clear();
											fringe.addAll(newFringe);
										}
									}
									result.addAll(fringe);
								}
							}
						}
					}
					break;
				case "REPORT_STATUS":
					if (vertices.add("REPORT_STATUS")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SP> exitState(String id) {
			Set<CompState_SP> result = new HashSet<CompState_SP>();
			CompState_SP e0 = new CompState_SP();
			switch (id) {
				case "RECEIVING_STATUS_REPORT":
					if (vertices.remove("RECEIVING_STATUS_REPORT")) {
						List<String> states = new ArrayList<String>();
						states.add("STATUS_REPORTED");
						states.add("REPORT_STATUS");
						for (CompState_SP e1 : e0.exitState(states.get(0))) {
							for (CompState_SP e2 : e1.exitState(states.get(1))) {
								result.add(e2);
							}
						}
					}
					break;
				case "PDI_CONNECTION_ESTABLISHED":
					if (vertices.remove("PDI_CONNECTION_ESTABLISHED")) {
						result.add(e0);
					}
					break;
				case "STATUS_REPORTED":
					if (vertices.remove("STATUS_REPORTED")) {
						result.add(e0);
					}
					break;
				case "REPORT_STATUS":
					if (vertices.remove("REPORT_STATUS")) {
						result.add(e0);
					}
					break;
				default:
					throw new Error("Should not happen; state " + id + " not found!");
			}
			if (result.isEmpty()) result.add(e0);
			return result;
		}
		private Set<CompState_SP> firePostExitTransitions() {
			Set<CompState_SP> result = new HashSet<CompState_SP>();
			result.add(new CompState_SP());
			return result;
		}
		private Set<CompState_SP> fireTransition(String id) {
			Set<CompState_SP> result = new HashSet<CompState_SP>();
			switch (id) {
				/* Source: REPORT_STATUS */
				/* Target: STATUS_REPORTED */
				/* Event: when(T2_Msg_Point_Position) */
				/* Statement: DT20_Point_Position := DT2_Point_Position; T20_Point_Position := TRUE; Mem_Point_Position := DT2_Point_Position; -- */
				case "T":
					for (CompState_SP e0 : exitState("REPORT_STATUS")) {
						e0.DT20_Point_Position.value = e0.DT2_Point_Position.value;
						e0.T20_Point_Position.value = Boolean.TRUE;
						e0.Mem_Point_Position.value = e0.DT2_Point_Position.value;
						for (CompState_SP e1 : e0.enterState("STATUS_REPORTED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: RECEIVING_STATUS_REPORT */
				/* Target: RECEIVING_STATUS_REPORT */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State = "CLOSED") */
				/* Statement: -- */
				case "T1":
					for (CompState_SP e0 : exitState("RECEIVING_STATUS_REPORT")) {
						for (CompState_SP e1 : e0.enterState("RECEIVING_STATUS_REPORT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: PDI_CONNECTION_ESTABLISHED */
				/* Target: RECEIVING_STATUS_REPORT */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State <> "ESTABLISHED") */
				/* Statement: -- */
				case "T2":
					for (CompState_SP e0 : exitState("PDI_CONNECTION_ESTABLISHED")) {
						for (CompState_SP e1 : e0.enterState("RECEIVING_STATUS_REPORT")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial1 */
				/* Target: REPORT_STATUS */
				/* Statement: -- */
				case "T3":
					for (CompState_SP e0 : exitState("Initial1")) {
						for (CompState_SP e1 : e0.enterState("REPORT_STATUS")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position <> DT2_Point_Position */
				/* Statement: Mem_Point_Position := DT2_Point_Position; DT20_Point_Position := DT2_Point_Position; T20_Point_Position := TRUE; -- */
				case "T4":
					for (CompState_SP e0 : exitState("RECEIVING_STATUS_REPORT")) {
						e0.Mem_Point_Position.value = e0.DT2_Point_Position.value;
						e0.DT20_Point_Position.value = e0.DT2_Point_Position.value;
						e0.T20_Point_Position.value = Boolean.TRUE;
						for (CompState_SP e1 : e0.enterState("PDI_CONNECTION_ESTABLISHED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: STATUS_REPORTED */
				/* Target: PDI_CONNECTION_ESTABLISHED */
				/* Event: when(D21_S_SCI_EfeS_Gen_SR_State = "ESTABLISHED") */
				/* Guard: Mem_Point_Position = DT2_Point_Position */
				/* Statement: -- */
				case "T5":
					for (CompState_SP e0 : exitState("RECEIVING_STATUS_REPORT")) {
						for (CompState_SP e1 : e0.enterState("PDI_CONNECTION_ESTABLISHED")) {
							result.add(e1);
						}
					}
					break;
				/* Source: Initial0 */
				/* Target: RECEIVING_STATUS_REPORT */
				/* Statement: -- */
				case "T6":
					for (CompState_SP e0 : exitState("Initial0")) {
						for (CompState_SP e1 : e0.enterState("RECEIVING_STATUS_REPORT")) {
							result.add(e1);
						}
					}
					break;
				default:
					throw new Error("Should not happen; transition " + id + " not found!");
			}
			return result;
		}
	}
	public final CompState_SMI comp_smi;
	public final CompState_SEC comp_sec;
	public final CompState_SCPPRIM comp_scpPrim;
	public final CompState_P3 comp_p3;
	public final CompState_SCPSEC comp_scpSec;
	public final CompState_EST comp_est;
	public final CompState_PRIM comp_prim;
	public final CompState_FP comp_fp;
	public final CompState_SP comp_sp;
	public JavaSimClass() {
		comp_smi = new CompState_SMI();
		comp_sec = new CompState_SEC();
		comp_scpPrim = new CompState_SCPPRIM();
		comp_p3 = new CompState_P3();
		comp_scpSec = new CompState_SCPSEC();
		comp_est = new CompState_EST();
		comp_prim = new CompState_PRIM();
		comp_fp = new CompState_FP();
		comp_sp = new CompState_SP();
	}
	public JavaSimClass copyFrom(JavaSimClass source) {
		comp_smi.copyFrom(source.comp_smi);
		comp_sec.copyFrom(source.comp_sec);
		comp_scpPrim.copyFrom(source.comp_scpPrim);
		comp_p3.copyFrom(source.comp_p3);
		comp_scpSec.copyFrom(source.comp_scpSec);
		comp_est.copyFrom(source.comp_est);
		comp_prim.copyFrom(source.comp_prim);
		comp_fp.copyFrom(source.comp_fp);
		comp_sp.copyFrom(source.comp_sp);
		return this;
	}
	public Set<JavaSimClass> getInitialStates() {
		Set<JavaSimClass> result = new HashSet<JavaSimClass>();
		for (CompState_SMI e0 : CompState_SMI.create()) {
			for (CompState_SEC e1 : CompState_SEC.create()) {
				for (CompState_SCPPRIM e2 : CompState_SCPPRIM.create()) {
					for (CompState_P3 e3 : CompState_P3.create()) {
						for (CompState_SCPSEC e4 : CompState_SCPSEC.create()) {
							for (CompState_EST e5 : CompState_EST.create()) {
								for (CompState_PRIM e6 : CompState_PRIM.create()) {
									for (CompState_FP e7 : CompState_FP.create()) {
										for (CompState_SP e8 : CompState_SP.create()) {
											JavaSimClass a = new JavaSimClass();
											a.comp_smi.copyFrom(e0);
											a.comp_sec.copyFrom(e1);
											a.comp_scpPrim.copyFrom(e2);
											a.comp_p3.copyFrom(e3);
											a.comp_scpSec.copyFrom(e4);
											a.comp_est.copyFrom(e5);
											a.comp_prim.copyFrom(e6);
											a.comp_fp.copyFrom(e7);
											a.comp_sp.copyFrom(e8);
											result.add(a);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return result;
	}
	public Set<JavaSimClass> getPossibleNextStates() {
		Set<JavaSimClass> result = new HashSet<JavaSimClass>();
		if (comp_sec.isTransitionEnabled("T", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T1", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T1")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T3", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T3")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T5", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T5")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T7", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T7")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T8", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T8")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T9", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T9")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T11", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T11")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T14", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T14")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T15", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T15")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T18", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T18")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T19", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T19")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T20", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T20")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T21", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T21")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T22", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T22")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T24", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T24")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T26", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T26")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T27", true)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T27")) {
				for (CompState_SEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T25", true) && comp_sec.isTransitionEnabled("T17", false) && comp_sec.isTransitionEnabled("T2", false)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T25")) {
				for (CompState_SEC e2 : e1.fireTransition("T17")) {
					for (CompState_SEC e3 : e2.fireTransition("T2")) {
						for (CompState_SEC e4 : e3.firePostExitTransitions()) {
							JavaSimClass a = new JavaSimClass().copyFrom(this);
							a.comp_sec.copyFrom(e4);
							result.add(a);
						}
					}
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T25", true) && comp_sec.isTransitionEnabled("T17", false) && comp_sec.isTransitionEnabled("T16", false)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T25")) {
				for (CompState_SEC e2 : e1.fireTransition("T17")) {
					for (CompState_SEC e3 : e2.fireTransition("T16")) {
						for (CompState_SEC e4 : e3.firePostExitTransitions()) {
							JavaSimClass a = new JavaSimClass().copyFrom(this);
							a.comp_sec.copyFrom(e4);
							result.add(a);
						}
					}
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T25", true) && comp_sec.isTransitionEnabled("T23", false) && comp_sec.isTransitionEnabled("T10", false)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T25")) {
				for (CompState_SEC e2 : e1.fireTransition("T23")) {
					for (CompState_SEC e3 : e2.fireTransition("T10")) {
						for (CompState_SEC e4 : e3.firePostExitTransitions()) {
							JavaSimClass a = new JavaSimClass().copyFrom(this);
							a.comp_sec.copyFrom(e4);
							result.add(a);
						}
					}
				}
			}
		}
		if (comp_sec.isTransitionEnabled("T25", true) && comp_sec.isTransitionEnabled("T23", false) && comp_sec.isTransitionEnabled("T13", false)) {
			CompState_SEC e0 = new CompState_SEC().copyFrom(comp_sec);
			for (CompState_SEC e1 : e0.fireTransition("T25")) {
				for (CompState_SEC e2 : e1.fireTransition("T23")) {
					for (CompState_SEC e3 : e2.fireTransition("T13")) {
						for (CompState_SEC e4 : e3.firePostExitTransitions()) {
							JavaSimClass a = new JavaSimClass().copyFrom(this);
							a.comp_sec.copyFrom(e4);
							result.add(a);
						}
					}
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T", true)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T")) {
				for (CompState_SCPPRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_scpPrim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T1", true) && comp_scpPrim.isTransitionEnabled("T2", false)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T1")) {
				for (CompState_SCPPRIM e2 : e1.fireTransition("T2")) {
					for (CompState_SCPPRIM e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpPrim.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T3", true) && comp_scpPrim.isTransitionEnabled("T8", false)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T3")) {
				for (CompState_SCPPRIM e2 : e1.fireTransition("T8")) {
					for (CompState_SCPPRIM e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpPrim.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T4", true) && comp_scpPrim.isTransitionEnabled("T2", false)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T4")) {
				for (CompState_SCPPRIM e2 : e1.fireTransition("T2")) {
					for (CompState_SCPPRIM e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpPrim.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T6", true) && comp_scpPrim.isTransitionEnabled("T10", false)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T6")) {
				for (CompState_SCPPRIM e2 : e1.fireTransition("T10")) {
					for (CompState_SCPPRIM e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpPrim.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T7", true) && comp_scpPrim.isTransitionEnabled("T10", false)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T7")) {
				for (CompState_SCPPRIM e2 : e1.fireTransition("T10")) {
					for (CompState_SCPPRIM e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpPrim.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpPrim.isTransitionEnabled("T3", true) && comp_scpPrim.isTransitionEnabled("T9", false) && comp_scpPrim.isTransitionEnabled("T10", false)) {
			CompState_SCPPRIM e0 = new CompState_SCPPRIM().copyFrom(comp_scpPrim);
			for (CompState_SCPPRIM e1 : e0.fireTransition("T3")) {
				for (CompState_SCPPRIM e2 : e1.fireTransition("T9")) {
					for (CompState_SCPPRIM e3 : e2.fireTransition("T10")) {
						for (CompState_SCPPRIM e4 : e3.firePostExitTransitions()) {
							JavaSimClass a = new JavaSimClass().copyFrom(this);
							a.comp_scpPrim.copyFrom(e4);
							result.add(a);
						}
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T1", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T1")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T2", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T2")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T4", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T4")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T5", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T5")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T6", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T6")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T7", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T7")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T11", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T11")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T12", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T12")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T14", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T14")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T15", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T15")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T16", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T16")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T17", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T17")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T18", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T18")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T19", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T19")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T22", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T22")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T23", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T23")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T24", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T24")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T26", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T26")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T27", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T27")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T28", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T28")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T30", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T30")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T31", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T31")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T32", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T32")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T33", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T33")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T34", true)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T34")) {
				for (CompState_P3 e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_p3.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T20", true) && comp_p3.isTransitionEnabled("T9", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T20")) {
				for (CompState_P3 e2 : e1.fireTransition("T9")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T20", true) && comp_p3.isTransitionEnabled("T29", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T20")) {
				for (CompState_P3 e2 : e1.fireTransition("T29")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T36", true) && comp_p3.isTransitionEnabled("T3", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T36")) {
				for (CompState_P3 e2 : e1.fireTransition("T3")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T36", true) && comp_p3.isTransitionEnabled("T35", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T36")) {
				for (CompState_P3 e2 : e1.fireTransition("T35")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T37", true) && comp_p3.isTransitionEnabled("T10", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T37")) {
				for (CompState_P3 e2 : e1.fireTransition("T10")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T37", true) && comp_p3.isTransitionEnabled("T13", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T37")) {
				for (CompState_P3 e2 : e1.fireTransition("T13")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T37", true) && comp_p3.isTransitionEnabled("T21", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T37")) {
				for (CompState_P3 e2 : e1.fireTransition("T21")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_p3.isTransitionEnabled("T37", true) && comp_p3.isTransitionEnabled("T38", false)) {
			CompState_P3 e0 = new CompState_P3().copyFrom(comp_p3);
			for (CompState_P3 e1 : e0.fireTransition("T37")) {
				for (CompState_P3 e2 : e1.fireTransition("T38")) {
					for (CompState_P3 e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_p3.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T6", true)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T6")) {
				for (CompState_SCPSEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_scpSec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T7", true)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T7")) {
				for (CompState_SCPSEC e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_scpSec.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T", true) && comp_scpSec.isTransitionEnabled("T5", false)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T")) {
				for (CompState_SCPSEC e2 : e1.fireTransition("T5")) {
					for (CompState_SCPSEC e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpSec.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T1", true) && comp_scpSec.isTransitionEnabled("T5", false)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T1")) {
				for (CompState_SCPSEC e2 : e1.fireTransition("T5")) {
					for (CompState_SCPSEC e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpSec.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T4", true) && comp_scpSec.isTransitionEnabled("T3", false)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T4")) {
				for (CompState_SCPSEC e2 : e1.fireTransition("T3")) {
					for (CompState_SCPSEC e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpSec.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T8", true) && comp_scpSec.isTransitionEnabled("T3", false)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T8")) {
				for (CompState_SCPSEC e2 : e1.fireTransition("T3")) {
					for (CompState_SCPSEC e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpSec.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_scpSec.isTransitionEnabled("T9", true) && comp_scpSec.isTransitionEnabled("T5", false)) {
			CompState_SCPSEC e0 = new CompState_SCPSEC().copyFrom(comp_scpSec);
			for (CompState_SCPSEC e1 : e0.fireTransition("T9")) {
				for (CompState_SCPSEC e2 : e1.fireTransition("T5")) {
					for (CompState_SCPSEC e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_scpSec.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_est.isTransitionEnabled("T2", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T2")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T4", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T4")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T5", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T5")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T6", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T6")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T9", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T9")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T10", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T10")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T11", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T11")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T12", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T12")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T13", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T13")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T14", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T14")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T18", true)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T18")) {
				for (CompState_EST e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_est.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_est.isTransitionEnabled("T15", true) && comp_est.isTransitionEnabled("T7", false)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T15")) {
				for (CompState_EST e2 : e1.fireTransition("T7")) {
					for (CompState_EST e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_est.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_est.isTransitionEnabled("T15", true) && comp_est.isTransitionEnabled("T16", false)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T15")) {
				for (CompState_EST e2 : e1.fireTransition("T16")) {
					for (CompState_EST e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_est.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_est.isTransitionEnabled("T17", true) && comp_est.isTransitionEnabled("T1", false)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T17")) {
				for (CompState_EST e2 : e1.fireTransition("T1")) {
					for (CompState_EST e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_est.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_est.isTransitionEnabled("T17", true) && comp_est.isTransitionEnabled("T3", false)) {
			CompState_EST e0 = new CompState_EST().copyFrom(comp_est);
			for (CompState_EST e1 : e0.fireTransition("T17")) {
				for (CompState_EST e2 : e1.fireTransition("T3")) {
					for (CompState_EST e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_est.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T2", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T2")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T3", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T3")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T4", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T4")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T5", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T5")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T6", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T6")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T7", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T7")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T8", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T8")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T10", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T10")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T11", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T11")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T13", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T13")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T14", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T14")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T16", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T16")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T17", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T17")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T19", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T19")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T21", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T21")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T23", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T23")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T24", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T24")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T25", true)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T25")) {
				for (CompState_PRIM e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_prim.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T18", true) && comp_prim.isTransitionEnabled("T1", false)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T18")) {
				for (CompState_PRIM e2 : e1.fireTransition("T1")) {
					for (CompState_PRIM e3 : e2.firePostExitTransitions()) {
						JavaSimClass a = new JavaSimClass().copyFrom(this);
						a.comp_prim.copyFrom(e3);
						result.add(a);
					}
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T18", true) && comp_prim.isTransitionEnabled("T", false) && comp_prim.isTransitionEnabled("T15", false)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T18")) {
				for (CompState_PRIM e2 : e1.fireTransition("T")) {
					for (CompState_PRIM e3 : e2.fireTransition("T15")) {
						for (CompState_PRIM e4 : e3.firePostExitTransitions()) {
							JavaSimClass a = new JavaSimClass().copyFrom(this);
							a.comp_prim.copyFrom(e4);
							result.add(a);
						}
					}
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T18", true) && comp_prim.isTransitionEnabled("T", false) && comp_prim.isTransitionEnabled("T22", false) && comp_prim.isTransitionEnabled("T12", false)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T18")) {
				for (CompState_PRIM e2 : e1.fireTransition("T")) {
					for (CompState_PRIM e3 : e2.fireTransition("T22")) {
						for (CompState_PRIM e4 : e3.fireTransition("T12")) {
							for (CompState_PRIM e5 : e4.firePostExitTransitions()) {
								JavaSimClass a = new JavaSimClass().copyFrom(this);
								a.comp_prim.copyFrom(e5);
								result.add(a);
							}
						}
					}
				}
			}
		}
		if (comp_prim.isTransitionEnabled("T18", true) && comp_prim.isTransitionEnabled("T", false) && comp_prim.isTransitionEnabled("T22", false) && comp_prim.isTransitionEnabled("T20", false)) {
			CompState_PRIM e0 = new CompState_PRIM().copyFrom(comp_prim);
			for (CompState_PRIM e1 : e0.fireTransition("T18")) {
				for (CompState_PRIM e2 : e1.fireTransition("T")) {
					for (CompState_PRIM e3 : e2.fireTransition("T22")) {
						for (CompState_PRIM e4 : e3.fireTransition("T20")) {
							for (CompState_PRIM e5 : e4.firePostExitTransitions()) {
								JavaSimClass a = new JavaSimClass().copyFrom(this);
								a.comp_prim.copyFrom(e5);
								result.add(a);
							}
						}
					}
				}
			}
		}
		if (comp_fp.isTransitionEnabled("T", true)) {
			CompState_FP e0 = new CompState_FP().copyFrom(comp_fp);
			for (CompState_FP e1 : e0.fireTransition("T")) {
				for (CompState_FP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_fp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_fp.isTransitionEnabled("T1", true)) {
			CompState_FP e0 = new CompState_FP().copyFrom(comp_fp);
			for (CompState_FP e1 : e0.fireTransition("T1")) {
				for (CompState_FP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_fp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_fp.isTransitionEnabled("T3", true)) {
			CompState_FP e0 = new CompState_FP().copyFrom(comp_fp);
			for (CompState_FP e1 : e0.fireTransition("T3")) {
				for (CompState_FP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_fp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_fp.isTransitionEnabled("T4", true)) {
			CompState_FP e0 = new CompState_FP().copyFrom(comp_fp);
			for (CompState_FP e1 : e0.fireTransition("T4")) {
				for (CompState_FP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_fp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_fp.isTransitionEnabled("T5", true)) {
			CompState_FP e0 = new CompState_FP().copyFrom(comp_fp);
			for (CompState_FP e1 : e0.fireTransition("T5")) {
				for (CompState_FP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_fp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_fp.isTransitionEnabled("T7", true)) {
			CompState_FP e0 = new CompState_FP().copyFrom(comp_fp);
			for (CompState_FP e1 : e0.fireTransition("T7")) {
				for (CompState_FP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_fp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sp.isTransitionEnabled("T", true)) {
			CompState_SP e0 = new CompState_SP().copyFrom(comp_sp);
			for (CompState_SP e1 : e0.fireTransition("T")) {
				for (CompState_SP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sp.isTransitionEnabled("T1", true)) {
			CompState_SP e0 = new CompState_SP().copyFrom(comp_sp);
			for (CompState_SP e1 : e0.fireTransition("T1")) {
				for (CompState_SP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sp.isTransitionEnabled("T2", true)) {
			CompState_SP e0 = new CompState_SP().copyFrom(comp_sp);
			for (CompState_SP e1 : e0.fireTransition("T2")) {
				for (CompState_SP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sp.isTransitionEnabled("T4", true)) {
			CompState_SP e0 = new CompState_SP().copyFrom(comp_sp);
			for (CompState_SP e1 : e0.fireTransition("T4")) {
				for (CompState_SP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (comp_sp.isTransitionEnabled("T5", true)) {
			CompState_SP e0 = new CompState_SP().copyFrom(comp_sp);
			for (CompState_SP e1 : e0.fireTransition("T5")) {
				for (CompState_SP e2 : e1.firePostExitTransitions()) {
					JavaSimClass a = new JavaSimClass().copyFrom(this);
					a.comp_sp.copyFrom(e2);
					result.add(a);
				}
			}
		}
		if (!comp_scpPrim.T7_Conn_Resp.value.equals(comp_scpSec.T6_Conn_Resp.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpPrim.T7_Conn_Resp.value = a.comp_scpSec.T6_Conn_Resp.value;
			result.add(a);
		}
		if (!comp_p3.T1_Move.value.equals(comp_fp.T10_Move.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_p3.T1_Move.value = a.comp_fp.T10_Move.value;
			result.add(a);
		}
		if (!comp_sp.T3_Msg_Timeout.value.equals(comp_fp.T3_Msg_Timeout.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sp.T3_Msg_Timeout.value = a.comp_fp.T3_Msg_Timeout.value;
			result.add(a);
		}
		if (!comp_fp.T30_Report_Timeout.value.equals(comp_p3.T30_Report_Timeout.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.T30_Report_Timeout.value = a.comp_p3.T30_Report_Timeout.value;
			result.add(a);
		}
		if (!comp_fp.D21_F_SCI_EfeS_Gen_SR_State.value.equals(comp_sec.D50_PDI_Connection_State.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.D21_F_SCI_EfeS_Gen_SR_State.value = a.comp_sec.D50_PDI_Connection_State.value;
			result.add(a);
		}
		if (!comp_scpSec.T5_Conn_Req.value.equals(comp_scpPrim.T6_Conn_Req.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpSec.T5_Conn_Req.value = a.comp_scpPrim.T6_Conn_Req.value;
			result.add(a);
		}
		if (!comp_est.T10_PDI_Connection_Closed.value.equals(comp_sec.T17_PDI_Connection_Closed.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_est.T10_PDI_Connection_Closed.value = a.comp_sec.T17_PDI_Connection_Closed.value;
			result.add(a);
		}
		if (!comp_scpSec.T4_Terminate_SCP_Connection.value.equals(comp_sec.T12_Terminate_SCP_Connection.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpSec.T4_Terminate_SCP_Connection.value = a.comp_sec.T12_Terminate_SCP_Connection.value;
			result.add(a);
		}
		if (!comp_scpSec.T8_Disc_Requ.value.equals(comp_scpPrim.T9_Disc_Req.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpSec.T8_Disc_Requ.value = a.comp_scpPrim.T9_Disc_Req.value;
			result.add(a);
		}
		if (!comp_sec.DT7_PDI_Version.value.equals(comp_prim.DT7_PDI_Version.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.DT7_PDI_Version.value = a.comp_prim.DT7_PDI_Version.value;
			result.add(a);
		}
		if (!comp_sec.T8_Cd_Initialisation_Request.value.equals(comp_prim.T8_Cd_Initialisation_Request.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T8_Cd_Initialisation_Request.value = a.comp_prim.T8_Cd_Initialisation_Request.value;
			result.add(a);
		}
		if (!comp_scpSec.T7_HB.value.equals(comp_scpPrim.T8_HB.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpSec.T7_HB.value = a.comp_scpPrim.T8_HB.value;
			result.add(a);
		}
		if (!comp_p3.D20_F_EST_EfeS_Gen_SR_State.value.equals(comp_est.D51_EST_EfeS_State.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_p3.D20_F_EST_EfeS_Gen_SR_State.value = a.comp_est.D51_EST_EfeS_State.value;
			result.add(a);
		}
		if (!comp_sp.T2_Msg_Point_Position.value.equals(comp_fp.T2_Msg_Point_Position.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sp.T2_Msg_Point_Position.value = a.comp_fp.T2_Msg_Point_Position.value;
			result.add(a);
		}
		if (!comp_sp.D21_S_SCI_EfeS_Gen_SR_State.value.equals(comp_prim.D50_PDI_Connection_State.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sp.D21_S_SCI_EfeS_Gen_SR_State.value = a.comp_prim.D50_PDI_Connection_State.value;
			result.add(a);
		}
		if (!comp_prim.T13_Msg_PDI_Version_Check.value.equals(comp_sec.T13_Msg_PDI_Version_Check.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.T13_Msg_PDI_Version_Check.value = a.comp_sec.T13_Msg_PDI_Version_Check.value;
			result.add(a);
		}
		if (!comp_sec.T5_SCP_Connection_Established.value.equals(comp_scpSec.T1_SCP_Connection_Established.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T5_SCP_Connection_Established.value = a.comp_scpSec.T1_SCP_Connection_Established.value;
			result.add(a);
		}
		if (!comp_p3.DT1_Move_Target.value.equals(comp_fp.DT10_Move_Target.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_p3.DT1_Move_Target.value = a.comp_fp.DT10_Move_Target.value;
			result.add(a);
		}
		if (!comp_prim.T15_Msg_Initialisation_Completed.value.equals(comp_sec.T15_Msg_Initialisation_Completed.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.T15_Msg_Initialisation_Completed.value = a.comp_sec.T15_Msg_Initialisation_Completed.value;
			result.add(a);
		}
		if (!comp_sec.T7_Cd_PDI_Version_Check.value.equals(comp_prim.T7_Cd_PDI_Version_Check.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T7_Cd_PDI_Version_Check.value = a.comp_prim.T7_Cd_PDI_Version_Check.value;
			result.add(a);
		}
		if (!comp_smi.T13_Data_Update_Stop.value.equals(comp_est.T22_Data_Update_Stop.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_smi.T13_Data_Update_Stop.value = a.comp_est.T22_Data_Update_Stop.value;
			result.add(a);
		}
		if (!comp_fp.DT20_Point_Position.value.equals(comp_p3.DT20_Point_Position.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.DT20_Point_Position.value = a.comp_p3.DT20_Point_Position.value;
			result.add(a);
		}
		if (!comp_prim.T14_Msg_Start_Initialisation.value.equals(comp_sec.T14_Msg_Start_Initialisation.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.T14_Msg_Start_Initialisation.value = a.comp_sec.T14_Msg_Start_Initialisation.value;
			result.add(a);
		}
		if (!comp_est.T16_Data_Installation_Complete.value.equals(comp_smi.T5_Data_installation_item_i_finished.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_est.T16_Data_Installation_Complete.value = a.comp_smi.T5_Data_installation_item_i_finished.value;
			result.add(a);
		}
		if (!comp_fp.DT1_Move_Point_Target.value.equals(comp_sp.DT1_Move_Point_Target.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.DT1_Move_Point_Target.value = a.comp_sp.DT1_Move_Point_Target.value;
			result.add(a);
		}
		if (!comp_sp.DT2_Point_Position.value.equals(comp_fp.DT2_Point_Position.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sp.DT2_Point_Position.value = a.comp_fp.DT2_Point_Position.value;
			result.add(a);
		}
		if (!comp_prim.T10_SCP_Connection_Terminated.value.equals(comp_scpPrim.T5_SCP_Connection_Terminated.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.T10_SCP_Connection_Terminated.value = a.comp_scpPrim.T5_SCP_Connection_Terminated.value;
			result.add(a);
		}
		if (!comp_prim.DT13b_Checksum_Data.value.equals(comp_sec.DT13b_Checksum_Data.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.DT13b_Checksum_Data.value = a.comp_sec.DT13b_Checksum_Data.value;
			result.add(a);
		}
		if (!comp_prim.T5_SCP_Connection_Established.value.equals(comp_scpPrim.T4_SCP_Connection_Established.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.T5_SCP_Connection_Established.value = a.comp_scpPrim.T4_SCP_Connection_Established.value;
			result.add(a);
		}
		if (!comp_scpPrim.T2_Terminate_SCP_Connection.value.equals(comp_prim.T12_Terminate_SCP_Connection.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpPrim.T2_Terminate_SCP_Connection.value = a.comp_prim.T12_Terminate_SCP_Connection.value;
			result.add(a);
		}
		if (!comp_sec.T9_Status_Report_Completed.value.equals(comp_fp.T23_Sending_Status_Report_Completed.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T9_Status_Report_Completed.value = a.comp_fp.T23_Sending_Status_Report_Completed.value;
			result.add(a);
		}
		if (!comp_p3.T2_Stop_Operation.value.equals(comp_fp.T11_Stop_Operation.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_p3.T2_Stop_Operation.value = a.comp_fp.T11_Stop_Operation.value;
			result.add(a);
		}
		if (!comp_est.T17_Data_Update_Finished.value.equals(comp_smi.T15_Data_Update_Finished.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_est.T17_Data_Update_Finished.value = a.comp_smi.T15_Data_Update_Finished.value;
			result.add(a);
		}
		if (!comp_est.T9_PDI_Connection_Established.value.equals(comp_sec.T11_PDI_Connection_Established.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_est.T9_PDI_Connection_Established.value = a.comp_sec.T11_PDI_Connection_Established.value;
			result.add(a);
		}
		if (!comp_fp.T20_Point_Position.value.equals(comp_p3.T20_Point_Position.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.T20_Point_Position.value = a.comp_p3.T20_Point_Position.value;
			result.add(a);
		}
		if (!comp_sec.T18_Not_Ready_For_PDI_Connection.value.equals(comp_est.T18_Not_Ready_For_PDI_Connection.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T18_Not_Ready_For_PDI_Connection.value = a.comp_est.T18_Not_Ready_For_PDI_Connection.value;
			result.add(a);
		}
		if (!comp_smi.T12_Data_Update_After_Operational.value.equals(comp_est.T14_Data_Update_After_Operational.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_smi.T12_Data_Update_After_Operational.value = a.comp_est.T14_Data_Update_After_Operational.value;
			result.add(a);
		}
		if (!comp_smi.T11_Data_Update_After_Booting.value.equals(comp_est.T13_Data_Update_After_Booting.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_smi.T11_Data_Update_After_Booting.value = a.comp_est.T13_Data_Update_After_Booting.value;
			result.add(a);
		}
		if (!comp_sec.T10_SCP_Connection_Terminated.value.equals(comp_scpSec.T2_SCP_Connection_Terminated.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T10_SCP_Connection_Terminated.value = a.comp_scpSec.T2_SCP_Connection_Terminated.value;
			result.add(a);
		}
		if (!comp_smi.T18_Data_Update_In_Initialising.value.equals(comp_est.T15_Data_Update_In_Initialising.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_smi.T18_Data_Update_In_Initialising.value = a.comp_est.T15_Data_Update_In_Initialising.value;
			result.add(a);
		}
		if (!comp_p3.T40_Report_Status.value.equals(comp_fp.T40_Send_Status_Report.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_p3.T40_Report_Status.value = a.comp_fp.T40_Send_Status_Report.value;
			result.add(a);
		}
		if (!comp_sec.T1_Ready_For_PDI_Connection.value.equals(comp_est.T21_Ready_For_PDI_Connection.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_sec.T1_Ready_For_PDI_Connection.value = a.comp_est.T21_Ready_For_PDI_Connection.value;
			result.add(a);
		}
		if (!comp_fp.T18_Start_Status_Report.value.equals(comp_sec.T6_Start_Status_Report.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.T18_Start_Status_Report.value = a.comp_sec.T6_Start_Status_Report.value;
			result.add(a);
		}
		if (!comp_prim.DT13a_Result.value.equals(comp_sec.DT13a_Result.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_prim.DT13a_Result.value = a.comp_sec.DT13a_Result.value;
			result.add(a);
		}
		if (!comp_scpPrim.T1_Establish_SCP_Connection.value.equals(comp_prim.T6_Establish_SCP_Connection.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpPrim.T1_Establish_SCP_Connection.value = a.comp_prim.T6_Establish_SCP_Connection.value;
			result.add(a);
		}
		if (!comp_scpPrim.T11_Disc_Req.value.equals(comp_scpSec.T9_Disc_Requ.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_scpPrim.T11_Disc_Req.value = a.comp_scpSec.T9_Disc_Requ.value;
			result.add(a);
		}
		if (!comp_fp.T1_Cd_Move_Point.value.equals(comp_sp.T1_Cd_Move_Point.value)) {
			JavaSimClass a = new JavaSimClass().copyFrom(this);
			a.comp_fp.T1_Cd_Move_Point.value = a.comp_sp.T1_Cd_Move_Point.value;
			result.add(a);
		}
		return result;
	}
}
