package lib.blocks.printing;

import lib.blocks.models.*;
import lib.blocks.models.UnifyingBlock.*;

public class GraphVizUBlockPrinter extends AbstractPrinter<UnifyingBlock> {
	public GraphVizUBlockPrinter(UnifyingBlock target) {
		super(target);
	}
	
	@Override
	protected void print(String mode, Object object) {
		println("graph {");
		
		for (ReprBlock rb : target.reprBlocks) {
			String elemName = getUnusedName(rb.name);
			setName(rb, elemName);
			
			println("\t\"" + elemName + "\" [label=\"" + elemName + "\\n" + rb.type.id.toString() + "\", shape=rect]");
		}
		
		for (ReprCommEvt evt : target.reprCommEvts) {
			String elemName = getUnusedName(evt.source.name);
			setName(evt, elemName);
			
			println("\t\"" + elemName + "\" [label=\"" + evt.source.getType().name + "\", shape=oval, style=dotted]");
			
			String srcBlockName = getName(evt.source.owner);
			println("\t\"" + srcBlockName + "\" -- \"" + elemName + "\" [label=\"" + evt.source.name + "\", dir=both, arrowhead=open, arrowtail=none, style=solid]");
			
			for (ReprPort tgtPort : evt.targets) {
				String tgtBlockName = getName(tgtPort.owner);
				println("\t\"" + elemName + "\" -- \"" + tgtBlockName + "\" [label=\"" + tgtPort.name + "\", dir=both, arrowhead=open, arrowtail=none, style=solid]");
			}
		}
		
		println("}");
	}
}
