package lib.blocks.printing;

import java.util.*;

import lib.blocks.common.*;
import lib.blocks.models.*;
import lib.blocks.models.IBDInstances.*;
import lib.utils.Dir;
import lib.utils.LOD;

public class GraphVizModelPrinter extends AbstractPrinter<Model> {
	public GraphVizModelPrinter(Model target) {
		super(target);
	}
	
	@Override
	protected void print(String mode, Object object) {
		println("graph {");
		
		//Declare IBD1s:
		for (IBD1Instance ibd1 : target.getIBD1Instances()) {
			String elemName = getUnusedName(ibd1.id.toString());
			setName(ibd1, elemName);
			
			println("\t\"" + elemName + "\" [label=\"" + elemName + "\\n" + ibd1.getType().id.toString() + "\", shape=rect]");
		}
		
		//Declare IBD1 ports:
		for (IBD1Port p : target.getIBD1Ports()) {
			String ptName = getUnusedName(p.name);
			setName(p, ptName);
			
			println("\t\"" + ptName + "\" [label=\"" + p.someLegacyPt.textify(LOD.MINIMAL) + "\", shape=oval]");
		}
		
		//Declare IBD2 ports:
		for (IBD2Port p : target.getIBD2Ports()) {
			String ptName = getUnusedName(p.id.toString());
			setName(p, ptName);
			
			Iterator<FlowSpecExpr> q = target.lib.getInterfaceExprs(p.someLegacyPt).iterator();
			String label;
			
			if (q.hasNext()) {
				label = q.next().toString();
				
				while (q.hasNext()) {
					label += ", " + q.next().toString();
				}
			} else {
				label = "???";
			}
			
			println("\t\"" + ptName + "\" [label=\"" + p.someLegacyPt.textify(LOD.MINIMAL) + ": " + label + "\", shape=oval, style=dotted]");
		}
		
		//Draw lines between points and their owning part (if any):
		for (IBD1Instance i : target.getIBD1Instances()) {
			String elemName = getName(i);
			
			for (Map.Entry<String, IBD1Port> entry : i.getPortPerName().entrySet()) {
				String ptName = getName(entry.getValue());
				
				println("\t\"" + elemName + "\" -- \"" + ptName + "\" [label=\"\", dir=both, arrowtail=none, arrowhead=none, style=dashed]");
			}
		}
		
		//Draw lines between connected points:
		for (IBD1Flow f : target.getIBD1Flows()) {
			String name1 = getName(f.v1);
			String name2 = getName(f.v2);
			
			if (f.v1.dir == Dir.IN) {
				println("\t\"" + name1 + "\" -- \"" + name2 + "\" [label=\"\", dir=both, arrowtail=open, arrowhead=none, style=solid]");
			} else {
				// We only need to draw lines in one direction, because there is a flow from A to B and from B to A:
				// println("\t\"" + name1 + "\" -- \"" + name2 + "\" [label=\"\", dir=both, arrowtail=open, arrowhead=none, style=solid]");
			}
		}
		
		for (IBD1ToIBD2Flow f : target.getIBD1ToIBD2Flows()) {
			String name1 = getName(f.v1);
			String name2 = getName(f.v2);
			
			if (f.v1.dir == Dir.OUT) {
				println("\t\"" + name1 + "\" -- \"" + name2 + "\" [label=\"\", dir=both, arrowtail=none, arrowhead=open, style=solid]");
			} else {
				println("\t\"" + name1 + "\" -- \"" + name2 + "\" [label=\"\", dir=both, arrowtail=open, arrowhead=none, style=solid]");
			}
		}
		
		for (IBD2Flow f : target.getIBD2Flows()) {
			String name1 = getName(f.v1);
			String name2 = getName(f.v2);
			
			if (name1.compareTo(name2) < 0) {
				println("\t\"" + name1 + "\" -- \"" + name2 + "\" [label=\"\", dir=both, arrowtail=empty, arrowhead=empty, style=dashed]");
			}
		}
		
		println("}");
	}
}
