package lib.blocks.models;

import java.util.Objects;

public final class NameIndexId {
	public final String name;
	public final int index;
	
	public NameIndexId(String name, int index) {
		this.name = name;
		this.index = index;
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(index, name);
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (!(obj instanceof NameIndexId)) {
			return false;
		}
		NameIndexId other = (NameIndexId) obj;
		return index == other.index && Objects.equals(name, other.name);
	}
	
	@Override
	public String toString() {
		return index >= 0 ? name + "[" + index + "]" : name;
	}
}
