package lib.blocks.models;

import java.util.Objects;

import lib.blocks.ibd2.IBD2Target;

public class BlockId {
	public final String typeName;
	public final String variantName;
	
	public BlockId(Class<?> clz) {
		if (clz.getDeclaringClass() != null && IBD2Target.class.isAssignableFrom(clz.getDeclaringClass())) {
			typeName = clz.getDeclaringClass().getSimpleName();
			variantName = clz.getSimpleName();
		} else {
			typeName = clz.getSimpleName();
			variantName = null;
		}
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(typeName, variantName);
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (!(obj instanceof BlockId)) {
			return false;
		}
		BlockId other = (BlockId) obj;
		return Objects.equals(typeName, other.typeName) && Objects.equals(variantName, other.variantName);
	}
	
	@Override
	public String toString() {
		return variantName != null ? typeName + "." + variantName : typeName;
	}
}
