package lib.blocks.models;

import java.util.*;

import lib.blocks.common.ConnectionPt;
import lib.blocks.constraints.*;
import lib.blocks.models.ModelLib.BlockCache;

public class Block {
	public final ModelLib owner;
	public final BlockId id;
	
	public Block(ModelLib owner, BlockId id) {
		this.owner = owner;
		this.id = id;
	}
	
	public BlockCache getCache() {
		return owner.get(this);
	}
	
	public SourceType getSourceType() {
		return getCache().getSourceType();
	}
	
	public Set<Class<?>> getUserDefinedClzs() {
		return getCache().getUserDefinedClzs();
	}
	
	public List<BlockConstraint> getDeclaredConstraints() {
		return getCache().getDeclaredConstraints();
	}
	
	public List<BlockConstraint> getInheritedConstraints() {
		return getCache().getInheritedConstraints();
	}
	
	/**
	 * Declared AND inherited!
	 */
	public Set<ConnectionPt> getContextPts() {
		return getCache().getContextPts();
	}
	
	/**
	 * Not inherited!
	 */
	public Set<ConnectionPt> getOwnedPts() {
		return getCache().getOwnedPts();
	}
	
	public Block getSuperBlock() {
		return getCache().getSuperBlock();
	}
	
	/**
	 * The block itself is last in the list.
	 */
	public List<Block> getLineage() {
		List<Block> result = new ArrayList<Block>();
		result.add(this);
		
		Block current = this;
		Block superBlock;
		
		while (current != null && (superBlock = current.getSuperBlock()) != null) {
			if (result.contains(superBlock)) {
				throw new Error("Hierarchy of block \"" + superBlock.id + "\" should NOT be circular!");
			}
			
			result.add(superBlock);
			current = superBlock;
		}
		
		Collections.reverse(result);
		return result;
	}
	
//	public List<AssociationConstraint> getUniqueAssocs() {
//		return FilterUtils.filter(getInheritedConstraints(), AssociationConstraint.class, (a) -> {
//			return a.isUniqueAssoc();
//		});
//	}
	
	public static Block getNarrowBlock(Block block1, Block block2, String location) {
		if (block1.getLineage().contains(block2)) {
			return block1;
		}
		
		if (block2.getLineage().contains(block1)) {
			return block2;
		}
		
		String msg = location + "Blocks are incompatible:";
		msg += "\n\t\t" + block1.id;
		
		for (Block l : block1.getLineage()) {
			msg += "\n\t\t\t" + l.id;
		}
		
		for (BlockConstraint c : block1.getDeclaredConstraints()) {
			msg += "\n\t\t\t" + c;
		}
		
		msg += "\n\t\t" + block2.id;
		
		for (Block l : block2.getLineage()) {
			msg += "\n\t\t\t" + l.id;
		}
		
		for (BlockConstraint c : block2.getDeclaredConstraints()) {
			msg += "\n\t\t\t" + c;
		}
		
		throw new Error(msg);
	}
}
