package lib.blocks.ibd2;

import lib.blocks.common.*;
import lib.blocks.ibd1.*;

public final class InterfacePort extends Port {
	public final FlowSpecExpr flowSpecExpr;
	
	public InterfacePort() {
		this(null);
	}
	
	public InterfacePort(String flowSpecDecl) {
		flowSpecExpr = FlowSpecExpr.obtain(flowSpecDecl);
	}
	
	public void connect(InPort<?> targetPort) {
		addTargetPort(targetPort);
	}
	
	public void connect(OutPort<?> sourcePort) {
		addSourcePort(sourcePort);
	}
	
	public void connect(InterfacePort other) {
		addSourcePort(other);
		addTargetPort(other);
	}
}
