package lib.blocks.ibd1;

import java.lang.reflect.Field;

import lib.utils.ClassUtils;

public abstract class IBD1Target {
	public final void disconnectAllFlows() {
		for (Field f : ClassUtils.getAllFields(getClass())) {
			disconnectFlow(f);
		}
	}
	
	private void disconnectFlow(Field f) {
		if (InPort.class.isAssignableFrom(f.getType())) {
			InPort<?> port = getValue(this, f, InPort.class);
			port.disconnectAll();
			return;
		}
		
		if (OutPort.class.isAssignableFrom(f.getType())) {
			OutPort<?> port = getValue(this, f, OutPort.class);
			port.disconnectAll();
			return;
		}
	}
	
	private static <T> T getValue(Object instance, Field f, Class<T> clz) {
		try {
			return clz.cast(f.get(instance));
		} catch (IllegalArgumentException | IllegalAccessException e) {
			throw new Error(e);
		}
	}
}
