package lib.blocks.constraints;

import lib.blocks.models.IBDInstances.*;

@SuppressWarnings("serial")
public class ViolatingIBD2Exception extends Exception {
	public final IBD2Instance ibd2;
	
	public ViolatingIBD2Exception(IBD2Instance ibd2, ViolatedConstraintException cause) {
		super(getMsg(ibd2, cause), cause);
		
		this.ibd2 = ibd2;
	}
	
	private static String getMsg(IBD2Instance ibd2, ViolatedConstraintException cause) {
		String result = "IBD2 " + ibd2.id + " of type " + ibd2.getType().id;
		
		if (ibd2.getType().getUserDefinedClzs().isEmpty()) {
			return result + " violates a constraint, namely\n" + getString(cause.constraint, "");
		}
		
		for (Class<?> srcClz : ibd2.getType().getUserDefinedClzs()) {
			result += "\n\tfrom \"" + srcClz.getCanonicalName() + "\"";
		}
		
		return result + "\nviolates a constraint, namely\n" + getString(cause.constraint, "");
	}
	

	private static String getString(BlockConstraint c, String indent) {
		return c.sources.toString(indent + "\t", c.toString());
	}
}
