package lib.blocks.constraints;

import lib.blocks.models.IBDInstances.*;

@SuppressWarnings("serial")
public class ViolatingIBD1Exception extends Exception {
	public final IBD1Instance ibd1;
	
	public ViolatingIBD1Exception(IBD1Instance ibd1, ViolatedConstraintException cause) {
		super(getMsg(ibd1, cause), cause);
		
		this.ibd1 = ibd1;
	}
	
	private static String getMsg(IBD1Instance ibd1, ViolatedConstraintException cause) {
		String result = "IBD1 " + ibd1.id + " of type " + ibd1.getType().id;
		
		if (ibd1.getType().getUserDefinedClzs().isEmpty()) {
			return result + " violates a constraint, namely\n\t" + getString(cause.constraint, "");
		}
		
		for (Class<?> srcClz : ibd1.getType().getUserDefinedClzs()) {
			result += "\n\tfrom \"" + srcClz.getCanonicalName() + "\"";
		}
		
		return result + "\nviolates a constraint, namely\n\t" + getString(cause.constraint, "");
	}
	
	private static String getString(BlockConstraint c, String indent) {
		return c.sources.toString(indent + "\t", c.toString());
	}
}
