package lib.blocks.constraints;

import lib.blocks.models.IBDInstances.*;

@SuppressWarnings("serial")
public class ViolatedConstraintException extends Exception {
	public final IBD1Instance ibd1;
	public final IBD2Instance ibd2;
	public final BlockConstraint constraint;
	
	public ViolatedConstraintException(BlockConstraint constraint, String msg) {
		super(msg);
		
		this.constraint = constraint;
		
		ibd1 = null;
		ibd2 = null;
	}
	
	public ViolatedConstraintException(BlockConstraint constraint, IBD1Instance ibd1, String msg) {
		super(msg);
		
		this.ibd1 = ibd1;
		this.constraint = constraint;
		
		ibd2 = null;
	}
	
	public ViolatedConstraintException(BlockConstraint constraint, IBD2Instance ibd2, String msg) {
		super(msg);
		
		this.ibd2 = ibd2;
		this.constraint = constraint;
		
		ibd1 = null;
	}
}
