package lib.blocks.constraints;

import lib.blocks.common.IncompatibilityException;

@SuppressWarnings("serial")
public class IncompatibleConstraintsException extends IncompatibilityException {
	public final BlockConstraint c1;
	public final BlockConstraint c2;
	
	public IncompatibleConstraintsException(BlockConstraint c1, BlockConstraint c2) {
		super("Incompatible constraints:\n" + getString(c1, "\t") + "\n" + getString(c2, "\t"));
		
		this.c1 = c1;
		this.c2 = c2;
	}
	
	public IncompatibleConstraintsException(BlockConstraint c1, BlockConstraint c2, Throwable cause) {
		super("Incompatible constraints:\n" + getString(c1, "\t") + "\n" + getString(c2, "\t"), cause);
		
		this.c1 = c1;
		this.c2 = c2;
	}
	
	private static String getString(BlockConstraint c, String indent) {
		return c.sources.toString(indent + "\t", c.toString());
	}
}
