package lib.blocks.constraints;

import java.util.*;

import lib.blocks.common.IncompatibilityException;

public class BlockConstraints {
	private List<BlockConstraint> constraints;
	
	public BlockConstraints() {
		constraints = new ArrayList<BlockConstraint>();
	}
	
	public BlockConstraints(BlockConstraints source) {
		constraints = new ArrayList<BlockConstraint>();
		
		for (BlockConstraint c : source.constraints) {
			constraints.add(c.createCopy());
		}
	}
	
	public List<BlockConstraint> getConstraints() {
		return Collections.unmodifiableList(constraints);
	}
	
	public void add(BlockConstraint constraint, List<BlockConstraint> dest, boolean overriding) throws IncompatibilityException {
		for (int index = 0; index < dest.size(); index++) {
			BlockConstraint a = BlockConstraint.combine(dest.get(index), constraint, overriding);
			
			if (a != null) {
				dest.set(index, a);
				return;
			}
		}
		
		dest.add(constraint.createCopy());
	}
}
