package lib.blocks.constraints;

import lib.blocks.common.IncompatibilityException;
import lib.blocks.models.*;
import lib.blocks.models.IBDInstances.*;
import lib.utils.Sources;

public abstract class BlockConstraint {
	public final Sources sources;
	
	public BlockConstraint() {
		sources = new Sources();
	}
	
	public BlockConstraint(BlockConstraint c1, BlockConstraint c2) {
		sources = new Sources(c1.sources, c2.sources);
	}
	
	public abstract BlockConstraint createCopy();
	
	public abstract void checkConformance(Model model, IBD1Instance ibd1) throws ViolatedConstraintException;
	public abstract void checkConformance(Model model, IBD2Instance ibd2) throws ViolatedConstraintException;
	
	protected static void incompatibleConstraints(BlockConstraint a1, BlockConstraint a2) throws IncompatibleConstraintsException {
		throw new IncompatibleConstraintsException(a1, a2);
	}
	
	protected static <T> T getCompatibleValue(BlockConstraint a1, BlockConstraint a2, T value1, T value2, T undefinedValue) throws IncompatibleConstraintsException {
		if (value1 == undefinedValue) {
			return value2;
		}
		
		if (value2 == undefinedValue) {
			return value1;
		}
		
		if (value1.equals(value2)) {
			return value1;
		}
		
		incompatibleConstraints(a1, a2);
		return null;
	}
	
	protected static <T> T getSameValue(BlockConstraint a1, BlockConstraint a2, T value1, T value2) throws IncompatibleConstraintsException {
		if (value1 == value2) {
			return value1;
		}
		
		incompatibleConstraints(a1, a2);
		return null;
	}
	
	public static BlockConstraint combine(BlockConstraint a1, BlockConstraint a2, boolean overriding) throws IncompatibilityException {
		if (a1 instanceof GeneralizationConstraint && a2 instanceof GeneralizationConstraint) {
			return GeneralizationConstraint.combine((GeneralizationConstraint)a1, (GeneralizationConstraint)a2);
		}
		
		if (a1 instanceof ASALPortConstraint && a2 instanceof ASALPortConstraint) {
			return ASALPortConstraint.combine((ASALPortConstraint)a1, (ASALPortConstraint)a2, overriding);
		}
		
		if (a1 instanceof AggregationConstraint && a2 instanceof AggregationConstraint) {
			return AggregationConstraint.combine((AggregationConstraint)a1, (AggregationConstraint)a2);
		}
		
		if (a1 instanceof AssociationConstraint && a2 instanceof AssociationConstraint) {
			return AssociationConstraint.combine((AssociationConstraint)a1, (AssociationConstraint)a2, overriding);
		}
		
		return null;
	}
}
