package lib.blocks.common;

import java.util.*;

public abstract class Port {
	private Set<Port> connectedPorts;
	
	protected Port() {
		connectedPorts = new HashSet<Port>();
	}
	
	public void disconnectAll() {
		connectedPorts.clear();
	}
	
	protected final void addSourcePort(Port sourcePort) {
		if (sourcePort == null) {
			throw new Error("Source port should NOT be null!");
		}
		
		sourcePort.connectedPorts.add(this);
		connectedPorts.add(sourcePort);
	}
	
	protected final void addTargetPort(Port targetPort) {
		if (targetPort == null) {
			throw new Error("Target port should NOT be null!");
		}
		
		targetPort.connectedPorts.add(this);
		connectedPorts.add(targetPort);
	}
	
	public Set<Port> getConnectedPorts() {
		return Collections.unmodifiableSet(connectedPorts);
	}
	
	public static boolean sameSuffix(String portName1, String portName2) {
		return getSuffix(portName1).equals(getSuffix(portName2));
	}
	
	public static String getSuffix(String portName) {
		int index = portName.indexOf("_");
		String result;
		
		if (index >= 0) {
			result = portName.substring(index + 1);
		} else {
			result = portName;
		}
		
		if (result.isBlank()) {
			throw new Error("Could not extract suffix from port name (\"" + portName + "\")!");
		}
		
		if (portName.startsWith("DT")) {
			result = "DT*_" + result;
		} else {
			if (portName.startsWith("D")) {
				result = "D*_" + result;
			} else {
				if (portName.startsWith("T")) {
					result = "T*_" + result;
				}
			}
		}
		
		return result;
	}
}
