package lib.blocks.common;

@SuppressWarnings("serial")
public class IncompatibleMultiplicitiesException extends IncompatibilityException {
	public final Multiplicity m1;
	public final Multiplicity m2;
	
	public IncompatibleMultiplicitiesException(Multiplicity m1, Multiplicity m2) {
		super("Incompatible multiplicities:\n" + getString(m1, "\t") + "\n" + getString(m2, "\t"));
		
		this.m1 = m1;
		this.m2 = m2;
	}
	
	private static String getString(Multiplicity m, String indent) {
		return m.sources.toString(indent + "\t", m.toString());
	}
}
