package lib.blocks.common;

import java.util.*;

public class FlowSpecExprs {
	private Set<String> stdFlowSpecNames;
	private Set<String> conjFlowSpecNames;
	private Set<FlowSpecExpr> exprs;
	
	public FlowSpecExprs() {
		stdFlowSpecNames = new HashSet<String>();
		conjFlowSpecNames = new HashSet<String>();
		exprs = new HashSet<FlowSpecExpr>();
	}
	
	public FlowSpecExprs(FlowSpecExprs source) {
		stdFlowSpecNames = new HashSet<String>(source.stdFlowSpecNames);
		conjFlowSpecNames = new HashSet<String>(source.conjFlowSpecNames);
		exprs = new HashSet<FlowSpecExpr>(source.exprs);
	}
	
	public void clear() {
		stdFlowSpecNames.clear();
		conjFlowSpecNames.clear();
		exprs.clear();
	}
	
	public boolean isEmpty() {
		return exprs.isEmpty();
	}
	
	public boolean add(FlowSpecExpr expr) {
		if (exprs.add(expr)) {
		
			if (expr.isConjugate) {
				conjFlowSpecNames.add(expr.flowSpecName);
			} else {
				stdFlowSpecNames.add(expr.flowSpecName);
			}
			
			return true;
		}
		
		return false;
	}
	
	public boolean addAll(FlowSpecExprs other) {
		if (exprs.addAll(other.exprs)) {
			stdFlowSpecNames.addAll(other.stdFlowSpecNames);
			conjFlowSpecNames.addAll(other.conjFlowSpecNames);
			return true;
		}
		
		return false;
	}
	
	public boolean addAll(Collection<? extends FlowSpecExpr> exprs) {
		boolean result = false;
		
		for (FlowSpecExpr expr : exprs) {
			if (add(expr)) {
				result = true;
			}
		}
		
		return result;
	}
	
	public Set<FlowSpecExpr> getExprs() {
		return Collections.unmodifiableSet(exprs);
	}
	
	public boolean isConflicting(FlowSpecExprs other) {
		for (String stdFlowSpecName : other.stdFlowSpecNames) {
			if (conjFlowSpecNames.contains(stdFlowSpecName)) {
				return true;
			}
		}
		
		return false;
	}
	
	@Override
	public String toString() {
		Iterator<FlowSpecExpr> q = exprs.iterator();
		
		if (q.hasNext()) {
			String result = q.next().toString();
			
			while (q.hasNext()) {
				result += ", " + q.next().toString();
			}
			
			return "{" + result + "}";
		}
		
		return "{}";
	}
}
