package lib.blocks.common;

import java.util.Objects;

public class FlowSpecExpr {
	public final String originalText;
	public final String flowSpecName;
	public final boolean isConjugate;
	
	private FlowSpecExpr(String text) {
		isConjugate = text.startsWith("~");
		flowSpecName = isConjugate ? text.substring(1) : text;
		originalText = text;
	}
	
	public static FlowSpecExpr obtain(String flowSpecDecl) {
		return flowSpecDecl != null ? new FlowSpecExpr(flowSpecDecl) : null;
	}
	
	public FlowSpecExpr createConjugate() {
		if (isConjugate) {
			return new FlowSpecExpr(flowSpecName);
		}
		
		return new FlowSpecExpr("~" + flowSpecName);
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(originalText, flowSpecName, isConjugate);
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (!(obj instanceof FlowSpecExpr)) {
			return false;
		}
		FlowSpecExpr other = (FlowSpecExpr) obj;
		return Objects.equals(originalText, other.originalText) && Objects.equals(flowSpecName, other.flowSpecName) && isConjugate == other.isConjugate;
	}
	
	@Override
	public String toString() {
		return (isConjugate ? "~" : "") + flowSpecName;
	}
	
//	public static String toString(Collection<FlowSpecExpr> exprs) {
//		Iterator<FlowSpecExpr> q = exprs.iterator();
//		
//		if (q.hasNext()) {
//			String result = q.next().toString();
//			
//			while (q.hasNext()) {
//				result += ", " + q.next().toString();
//			}
//			
//			return "[" + result + "]";
//		}
//		
//		return "[]";
//	}
//	
//	public static boolean areConflicting(Collection<FlowSpecExpr> exprs1, Collection<FlowSpecExpr> exprs2) {
//		for (FlowSpecExpr expr1 : exprs1) {
//			FlowSpecExpr conjExpr1 = expr1.createConjugate();
//			
//			if (exprs2.contains(conjExpr1)) {
//				return true;
//			}
//		}
//		
//		return false;
//	}
}
