package lib.blocks.common;

import java.lang.reflect.*;
import java.util.*;

import lib.blocks.ibd1.*;
import lib.blocks.ibd2.*;
import lib.blocks.models.Block;
import lib.blocks.models.NameIndexId;
import lib.utils.*;

public class ConnectionPts {
	public static Set<ConnectionPt> getConnectionPts(Block block, Class<?> clz) throws ConnectionPtException, ReflectionException {
		Set<ConnectionPt> result = new HashSet<ConnectionPt>();
		
		IBD2Target instance = ClassUtils.createStdInstance(clz.asSubclass(IBD2Target.class));
		instance.disconnectAllFlows();
		instance.connectFlows();
		
		for (Field f : ClassUtils.getAllFields(instance.getClass())) {
			addConnectionPts(block, instance, f, result);
		}
		
		ConnectionPt.populateAll(instance, result);
		return result;
	}
	
	private static void addConnectionPts(Block block, IBD2Target instance, Field f, Set<ConnectionPt> dest) throws ReflectionException {
		if (f.getType().isArray()) {
			Class<?> compType = f.getType().getComponentType();
			
			if (InterfacePort.class.isAssignableFrom(compType)) {
				InterfacePort[] values = FieldUtils.getValues(instance, f, InterfacePort.class);
				
				for (int memberIndex = 0; memberIndex < values.length; memberIndex++) {
					dest.add(new ConnectionPt.ExposingPt(block, f.getDeclaringClass(), f, values[memberIndex], memberIndex));
				}
				
				return;
			}
			
			if (IBD1Target.class.isAssignableFrom(compType)) {
				IBD1Target[] values = FieldUtils.getValues(instance, f, IBD1Target.class);
				
				for (int memberIndex = 0; memberIndex < values.length; memberIndex++) {
					Block compBlock = block.owner.get(compType);
					addConnectionPts(instance, values[memberIndex], compBlock, f.getName(), memberIndex, dest);
				}
				
				return;
			}
			
			if (IBD2Target.class.isAssignableFrom(compType)) {
				IBD2Target[] values = FieldUtils.getValues(instance, f, IBD2Target.class);
				
				for (int memberIndex = 0; memberIndex < values.length; memberIndex++) {
					Block compBlock = block.owner.get(compType);
					addConnectionPts(instance, values[memberIndex], compBlock, f.getName(), memberIndex, dest);
				}
				
				return;
			}
		} else {
			if (InterfacePort.class.isAssignableFrom(f.getType())) {
				InterfacePort ip = FieldUtils.getValue(instance, f, InterfacePort.class);
				dest.add(new ConnectionPt.ExposingPt(block, f.getDeclaringClass(), f, ip, -1));
				return;
			}
			
			if (IBD1Target.class.isAssignableFrom(f.getType())) {
				IBD1Target comp = FieldUtils.getValue(instance, f, IBD1Target.class);
				Block compBlock = block.owner.get(f.getType());
				addConnectionPts(instance, comp, compBlock, f.getName(), -1, dest);
				return;
			}
			
			if (IBD2Target.class.isAssignableFrom(f.getType())) {
				IBD2Target comp = FieldUtils.getValue(instance, f, IBD2Target.class);
				Block compBlock = block.owner.get(f.getType());
				addConnectionPts(instance, comp, compBlock, f.getName(), -1, dest);
				return;
			}
		}
		
		throw new Error("Should not happen!");
	}
	
	private static void addConnectionPts(IBD2Target instance, IBD1Target comp, Block compBlock, String memberName, int memberIndex, Set<ConnectionPt> dest) throws ReflectionException {
		for (Field f : ClassUtils.getAllFields(comp.getClass())) {
			if (InPort.class.isAssignableFrom(f.getType())) {
				InPort<?> port = FieldUtils.getValue(comp, f, InPort.class);
				dest.add(new ConnectionPt.InPortPt(compBlock, f.getDeclaringClass(), f, new NameIndexId(memberName, memberIndex), port));
			} else {
				if (OutPort.class.isAssignableFrom(f.getType())) {
					OutPort<?> port = FieldUtils.getValue(comp, f, OutPort.class);
					dest.add(new ConnectionPt.OutPortPt(compBlock, f.getDeclaringClass(), f, new NameIndexId(memberName, memberIndex), port));
				}
			}
		}
	}
	
	private static void addConnectionPts(IBD2Target instance, IBD2Target comp, Block compBlock, String memberName, int memberIndex, Set<ConnectionPt> dest) throws ReflectionException {
		for (Field f : ClassUtils.getAllFields(comp.getClass())) {
			if (f.getType().isArray()) {
				if (InterfacePort.class.isAssignableFrom(f.getType().getComponentType())) {
					InterfacePort[] ips = FieldUtils.getValues(comp, f, InterfacePort.class);
					
					for (int index = 0; index < ips.length; index++) {
						dest.add(new ConnectionPt.ExposedPt(compBlock, f.getDeclaringClass(), f, new NameIndexId(memberName, memberIndex), ips[index], index));
					}
				}
			} else {
				if (InterfacePort.class.isAssignableFrom(f.getType())) {
					InterfacePort ip = FieldUtils.getValue(comp, f, InterfacePort.class);
					dest.add(new ConnectionPt.ExposedPt(compBlock, f.getDeclaringClass(), f, new NameIndexId(memberName, memberIndex), ip, -1));
				}
			}
		}
	}
}
