package lib.blocks.bdds;

public abstract class Relation<T> {
	public final int minCount;
	public final int maxCount;
	
	public Relation(int count) {
		this(count, count);
	}
	
	public Relation(int minCount, char star) {
		this(minCount, Integer.MAX_VALUE);
		
		if (star != '*') {
			throw new Error("Star must have value '*'!");
		}
	}
	
	public Relation(int minCount, int maxCount) {
		if (minCount > maxCount) {
			throw new Error("Minimum (\"" + minCount + "\") must not exceed maximum (\"" + maxCount + "\")!");
		}
		
		if (minCount < 0) {
			throw new Error("Minimum (\"" + minCount + "\") must be non-negative!");
		}
		
		if (maxCount < 0) {
			throw new Error("Maximum (\"" + maxCount + "\") must be non-negative!");
		}
		
		this.minCount = minCount;
		this.maxCount = maxCount;
	}
}


