package lib.blocks.bdds;

import java.lang.reflect.Field;
import java.util.*;

import lib.blocks.common.BidirMap;
import lib.blocks.models.ModelLib;
import lib.utils.*;

/**
 * Block Definition Diagrams (BDDs) mainly define the complexity of a system, or
 * the partial complexity of a partial system 
 * ('complexity' = possible combinations of system components).
 * BDDs also define inheritance relations between component types.
 */
public abstract class BDD {
	private BidirMap bidirMap;
	
	public final BidirMap getBidirMap() {
		return bidirMap;
	}
	
	public final void initBidirMap(ModelLib lib, Class<?> targetClz) throws ReflectionException {
		bidirMap = new BidirMap(lib, targetClz, getFieldPerAssoc());
	}
	
	public abstract void initBidirs();
	
	public final void bidir(Assoc<?> assoc1, Assoc<?> assoc2) {
		bidirMap.add(assoc1, assoc2);
	}
	
	private Map<Assoc<?>, ParameterizedField> getFieldPerAssoc() throws ReflectionException {
		Map<Assoc<?>, ParameterizedField> result = new HashMap<Assoc<?>, ParameterizedField>();
		
		for (Class<?> declaredClz : getClass().getDeclaredClasses()) {
			for (Field f : ClassUtils.getDeclaredFields(declaredClz)) {
				ParameterizedField pf = ParameterizedField.obtain(f, Relation.class);
				Relation<?> fieldValue = pf.getValue(Relation.class);
				
				if (fieldValue instanceof Assoc) {
					result.put((Assoc<?>)fieldValue, pf);
				}
			}
		}
		
		return result;
	}
}




