package lib.behave.proto;

import java.util.*;

import lib.asal.ASALFunction;
import lib.asal.parsing.ASALException;

public abstract class TritoVisitor<T> extends TritoHandler<T> {
	public TritoVisitor(TritoStateMachine stateMachine) {
		super(stateMachine);
	}
	
	public final T visitVertex(TritoVertex v) throws ASALException {
		T onEntry = null;
		T onExit = null;
		List<T> onDo = new ArrayList<T>();
		
		if (v.getOnEntry() != null) {
			onEntry = visitStat(v.getOnEntry().getStatement());
		}
		
		if (v.getOnExit() != null) {
			onExit = visitStat(v.getOnExit().getStatement());
		}
		
		for (TritoTransition t : v.getOnDo()) {
			onDo.add(visitTransition(t));
		}
		
		return handle(v, onEntry, onExit, onDo);
	}
	
	public final T visitTransition(TritoTransition transition) throws ASALException {
		T event = null;
		
		if (transition.getEvent() != null) {
			event = visitEvent(transition.getEvent());
		}
		
		T guard = null;
		
		if (transition.getGuard() != null) {
			guard = visitExpr(transition.getGuard());
		}
		
		T stat = null;
		
		if (transition.getStatement() != null) {
			stat = visitStat(transition.getStatement());
		}
		
		return handle(transition, event, guard, stat);
	}
	
	public final T visitMachine(TritoStateMachine stateMachine) throws ASALException {
		List<T> functions = new ArrayList<T>();
		
		for (Map.Entry<String, ASALFunction> entry : stateMachine.functions.entrySet()) {
			functions.add(visitFct(entry.getValue()));
		}
		
		List<T> vertices = new ArrayList<T>();
		
		for (TritoVertex t : stateMachine.vertices) {
			vertices.add(visitVertex(t));
		}
		
		List<T> transitions = new ArrayList<T>();
		
		for (TritoTransition t : stateMachine.transitions) {
			transitions.add(visitTransition(t));
		}
		
		return handle(stateMachine, functions, vertices, transitions);
	}
}
