package lib.behave.proto;

import java.util.*;

import lib.asal.ASALContext;
import lib.asal.parsing.ASALException;

public class TritoVertex {
	private Class<?> clz;
	private TritoVertex parentVertex;
	private List<TritoVertex> childVertices;
	private List<TritoVertex> initialVertices;
	
	private TritoTransition onEntry;
	private List<TritoTransition> onDo;
	private TritoTransition onExit;
	
	public TritoVertex(ASALContext context, DeuteroVertex vertex) throws ASALException {
		this.clz = vertex.getClz();
		
		if (vertex.getOnEntry() != null) {
			onEntry = new TritoTransition(this, vertex.getOnEntry());
		}
		
		onDo = new ArrayList<TritoTransition>();
		
		for (DeuteroTransition transition : vertex.getOnDo()) {
			onDo.add(new TritoTransition(this, transition));
		}
		
		if (vertex.getOnExit() != null) {
			onExit = new TritoTransition(this, vertex.getOnExit());
		}
		
		childVertices = new ArrayList<TritoVertex>();
		initialVertices = new ArrayList<TritoVertex>();
	}
	
	public Class<?> getClz() {
		return clz;
	}
	
	public TritoVertex getParentVertex() {
		return parentVertex;
	}
	
	public void setParentVertex(TritoVertex parentVertex) {
		this.parentVertex = parentVertex;
	}
	
	public List<TritoVertex> getChildVertices() {
		return childVertices;
	}
	
	public List<TritoVertex> getInitialVertices() {
		return initialVertices;
	}
	
	public TritoTransition getOnEntry() {
		return onEntry;
	}
	
	public List<TritoTransition> getOnDo() {
		return onDo;
	}
	
	public TritoTransition getOnExit() {
		return onExit;
	}
	
	/**
	 * Constructs a list with all ancestors of this vertex, including itself.
	 * The left-most element in the list will be the root container (which must be a state machine), and
	 * the right-most element in the list will be this vertex.
	 */
	public List<TritoVertex> getLineage() {
		List<TritoVertex> result;
		
		if (parentVertex != null) {
			result = parentVertex.getLineage();
		} else {
			result = new ArrayList<TritoVertex>();
		}
		
		result.add(this);
		return result;
	}
	
//	public Map<TritoVertex, List<ASALStatement>> getExitBehaviourPerChildlessDescendantVertex(Predicate<TritoVertex> filter) {
//		Map<TritoVertex, List<ASALStatement>> result = new HashMap<TritoVertex, List<ASALStatement>>();
//		addExitBehaviourPerChildlessDescendantVertex(result, new ArrayList<ASALStatement>(), filter);
//		return result;
//	}
//	
//	private void addExitBehaviourPerChildlessDescendantVertex(Map<TritoVertex, List<ASALStatement>> destination, List<ASALStatement> exitBehaviourSoFar, Predicate<TritoVertex> filter) {
//		List<ASALStatement> exitBehaviour = new ArrayList<ASALStatement>(exitBehaviourSoFar);
//		
//		if (onExit != null) {
//			exitBehaviour.add(0, onExit.getStatement());
//		}
//		
//		if (childVertices.size() > 0) {
//			for (TritoVertex childVertex : childVertices) {
//				childVertex.addExitBehaviourPerChildlessDescendantVertex(destination, exitBehaviour, filter);
//			}
//		} else {
//			if (filter.test(this)) {
//				destination.put(this, exitBehaviour);
//			}
//		}
//	}
//	
//	public Map<TritoVertex, List<ASALStatement>> getExitBehaviourPerFinalVertex() {
//		Map<TritoVertex, List<ASALStatement>> result = new HashMap<TritoVertex, List<ASALStatement>>();
//		List<ASALStatement> exitBehaviour = new ArrayList<ASALStatement>();
//		
//		if (onExit != null) {
//			exitBehaviour.add(0, onExit.getStatement());
//		}
//		
//		if (childVertices.size() > 0) {
//			for (TritoVertex childVertex : childVertices) {
//				if (FinalVertex.class.isAssignableFrom(childVertex.clz)) {
//					result.put(childVertex, exitBehaviour); //There should be only one!
//				}
//			}
//		} else {
//			result.put(this, exitBehaviour);
//		}
//		
//		return result;
//	}
//	
//	public Set<TritoVertex> getChildlessDescendantVertices(Predicate<TritoVertex> filter) {
//		Set<TritoVertex> result = new HashSet<TritoVertex>();
//		addChildlessDescendantVertices(filter, result);
//		return result;
//	}
//	
//	private void addChildlessDescendantVertices(Predicate<TritoVertex> filter, Set<TritoVertex> destination) {
//		if (childVertices.size() > 0) {
//			for (TritoVertex childVertex : childVertices) {
//				childVertex.addChildlessDescendantVertices(filter, destination);
//			}
//		} else {
//			if (filter.test(this)) {
//				destination.add(this);
//			}
//		}
//	}
}
