package lib.behave.proto;

import java.util.*;

import lib.asal.parsing.api.*;

public class TritoTransition {
	private TritoVertex sourceVertex;
	private TritoVertex targetVertex;
	private ASALEvent event;
	private ASALExpr guard;
	private ASALStatement statement;
	private boolean isLocal;
	
	public TritoTransition(TritoVertex vertex, DeuteroTransition source) {
		sourceVertex = vertex;
		targetVertex = vertex;
		event = source.getEvent();
		guard = source.getGuard();
		statement = source.getStatement();
		isLocal = source.isLocal();
	}
	
	public TritoTransition(TritoVertex sourceVertex, TritoVertex targetVertex, List<DeuteroTransition> sourceList) {
		this.sourceVertex = sourceVertex;
		this.targetVertex = targetVertex;
		
		event = sourceList.get(0).getEvent();
		
		for (int index = 1; index < sourceList.size(); index++) {
			if (sourceList.get(index).getEvent() != null) {
				throw new Error("Only the first transition in a sequence may specify an event!");
			}
		}
		
		List<ASALExpr> guards = new ArrayList<ASALExpr>();
		List<ASALStatement> stats = new ArrayList<ASALStatement>();
		isLocal = false;
		
		for (DeuteroTransition source : sourceList) {
			if (source.getGuard() != null) {
				guards.add(source.getGuard());
			}
			
			if (source.getStatement() != null) {
				stats.add(source.getStatement());
			}
			
			if (source.isLocal()) {
				isLocal = true;
			}
		}
		
		guard = ASALBinaryExpr.fromList(guards, "and");
		statement = ASALSeqStatement.fromList(stats);
	}
	
	public TritoTransition(TritoVertex sourceVertex, TritoVertex targetVertex, ASALEvent event, ASALExpr guard, ASALStatement statement, boolean isLocal) {
		this.sourceVertex = sourceVertex;
		this.targetVertex = targetVertex;
		this.event = event;
		this.guard = guard;
		this.statement = statement;
		this.isLocal = isLocal;
	}
	
	public void setSourceVertex(TritoVertex sourceVertex) {
		this.sourceVertex = sourceVertex;
	}
	
	public void setTargetVertex(TritoVertex targetVertex) {
		this.targetVertex = targetVertex;
	}
	
	public boolean interruptsCompositeStates() {
		return event instanceof ASALTrigger || event instanceof ASALTimeout;
	}
	
	public ASALEvent getEvent() {
		return event;
	}
	
	public ASALExpr getGuard() {
		return guard;
	}
	
	public ASALStatement getStatement() {
		return statement;
	}
	
	public TritoVertex getSourceVertex() {
		return sourceVertex;
	}
	
	public TritoVertex getTargetVertex() {
		return targetVertex;
	}
	
	public boolean isLocal() {
		return isLocal;
	}
	
	protected void setStatement(ASALStatement st) {
		this.statement = st;
	}
}
