package lib.behave.proto;

import java.util.*;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.asal.parsing.api.*;
import lib.behave.*;
//import lib.blocks.printing.ASALA2mCRL2Visitor;

/**
 * In this machine, junctions have been eliminated.
 */
public class TritoStateMachine extends ASALContext {
	public final Class<? extends StateMachine> clz;
	public final TritoVertex rootVertex;
	public final Set<TritoVertex> vertices;
	public final Set<TritoVertex> initialVerticesSM;
	public final Set<TritoTransition> transitions;
	public final Map<String,ASALLiteral> initialValuation;
	
	public final DeuteroStateMachine legacy;
	
	public TritoStateMachine(DeuteroStateMachine source) throws ASALException {
		clz = source.clz;
		legacy = source;
		
		inPortVars.putAll(source.inPortVars);
		outPortVars.putAll(source.outPortVars);
		stateMachineVars.putAll(source.stateMachineVars);
		functions.putAll(source.functions);
		
		vertices = new HashSet<TritoVertex>();
		Map<DeuteroVertex, TritoVertex> newVertexPerOldVertex = new HashMap<DeuteroVertex, TritoVertex>();
		
		for (DeuteroVertex v : source.vertices) {
			//if (!JunctionVertex.class.isAssignableFrom(v.getClz())) {
				TritoVertex w = new TritoVertex(this, v);
				newVertexPerOldVertex.put(v, w);
				vertices.add(w);
			//}
		}
		
		rootVertex = newVertexPerOldVertex.get(source.rootVertex);
		initialVerticesSM = new HashSet<TritoVertex>();
		
		//Resolve references to root/initial/parent/child vertices:
		for (DeuteroVertex i : source.initialVertices) {
			initialVerticesSM.add(newVertexPerOldVertex.get(i));
		}			
		for (Map.Entry<DeuteroVertex, TritoVertex> entry : newVertexPerOldVertex.entrySet()) {
			for (DeuteroVertex initialVertex : entry.getKey().getInitialVertices()) {
				entry.getValue().getInitialVertices().add(newVertexPerOldVertex.get(initialVertex));
			}
			
			if (entry.getKey().getParentVertex() != null) {
				entry.getValue().setParentVertex(newVertexPerOldVertex.get(entry.getKey().getParentVertex()));
			}
			
			for (DeuteroVertex childVertex : entry.getKey().getChildVertices()) {
				entry.getValue().getChildVertices().add(newVertexPerOldVertex.get(childVertex));
			}
		}
				
		
		transitions = new HashSet<TritoTransition>();
		for (DeuteroTransition t : source.transitions) {
			TritoVertex sourceVertex = newVertexPerOldVertex.get(t.getSourceVertex());
			TritoVertex targetVertex = newVertexPerOldVertex.get(t.getTargetVertex());
			transitions.add(new TritoTransition(sourceVertex, targetVertex, t.getEvent(), t.getGuard(), t.getStatement(), t.isLocal()));
		}
		
		//Set<List<DeuteroTransition>> fringe = new HashSet<List<DeuteroTransition>>();
		//Set<List<DeuteroTransition>> newFringe = new HashSet<List<DeuteroTransition>>();
		
//		for (DeuteroTransition t : source.transitions) {
//			if (!JunctionVertex.class.isAssignableFrom(t.getSourceVertex().getClz())) {
//				List<DeuteroTransition> ts = new ArrayList<DeuteroTransition>();
//				fringe.add(ts);
//				ts.add(t);
//			}
//		}
//		
//		while (fringe.size() > 0) {
//			newFringe.clear();
//			
//			for (List<DeuteroTransition> ts : fringe) {
//				DeuteroTransition t = ts.get(ts.size() - 1);
//				
//				if (JunctionVertex.class.isAssignableFrom(t.getTargetVertex().getClz())) {
//					for (DeuteroTransition t2 : source.transitions) {
//						if (t2.getSourceVertex() == t.getTargetVertex()) {
//							if (ts.contains(t2)) {
//								throw new ASALException("State machine: " + source.clz.getCanonicalName() + "\nTransition: " + t2, new ASALException("Transition and junctions may not be circular!"));
//							}
//							
//							List<DeuteroTransition> ts2 = new ArrayList<DeuteroTransition>(ts);
//							ts2.add(t2);
//							newFringe.add(ts2);
//						}
//					}
//				} else {
//					TritoVertex sourceVertex = newVertexPerOldVertex.get(ts.get(0).getSourceVertex());
//					TritoVertex targetVertex = newVertexPerOldVertex.get(ts.get(ts.size() - 1).getTargetVertex());
//					transitions.add(new TritoTransition(sourceVertex, targetVertex, ts));
//				}
//			}
//			
//			fringe.clear();
//			fringe.addAll(newFringe);
//		}
		
		//Initialize valuation based on transition from initial vertex
		initialValuation = new HashMap<String,ASALLiteral>();
		for(TritoTransition t: transitions) {
			if(this.initialVerticesSM.contains(t.getSourceVertex())) {
				initializeValuation(t.getStatement());
				t.setStatement(new ASALEmptyStatement(null,null));
			}
		}
	}
	
	/* Recursively go through ASALStatement and initialize variables
	 * We only allow assignments where directly a literal is given
	 * Also functions are allowed, where the function definition should only assign variables
	 */
	private void initializeValuation(ASALStatement st) throws ASALException {
		if(st instanceof ASALAssignStatement) {
			ASALAssignStatement statement = (ASALAssignStatement) st;
			ASALExpr expr = statement.getExpression();
			if(expr instanceof ASALLiteral) {
				ASALLiteral lit = (ASALLiteral) expr;
				initialValuation.put(statement.getVarName(), lit);
			} else {
				throw new ASALException("State machine: " + clz.getCanonicalName(), new ASALException("Transitions from initial vertices may only contain direct variable assignments"));
			}
		} else if(st instanceof ASALSeqStatement) {
			ASALSeqStatement statement = (ASALSeqStatement) st;
			initializeValuation(statement.getStatement());
			initializeValuation(statement.getSuccessor());
		} else if(st instanceof ASALFunctionCallStatement) {
			ASALFunctionCallStatement statement = (ASALFunctionCallStatement) st;
			initializeValuation(statement.resolveFunction(this).getBody());
		} else if(st instanceof ASALEmptyStatement) {
			//do nothing, but allowed
		} else {
			throw new ASALException("State machine: " + clz.getCanonicalName(), new ASALException("Transitions from initial vertices may only contain direct variable assignments"));
		}
	}
}




