package lib.behave.proto;

import java.util.*;

import lib.behave.State;

public class ProtoVertex {
	public final Class<?> clz;
	public final ProtoVertex parentVertex;
	public final Set<ProtoVertex> childVertices;
	public final Set<ProtoVertex> initialVertices;
	public final Set<ProtoTransition> onDo;
	
	public ProtoTransition onEntry;
	public ProtoTransition onExit;
	
	public ProtoVertex(ProtoVertex parentVertex, Class<?> clz) {
		this.clz = clz;
		this.parentVertex = parentVertex;
		
		childVertices = new HashSet<ProtoVertex>();
		initialVertices = new HashSet<ProtoVertex>();
		onDo = new HashSet<ProtoTransition>();
		
		if (parentVertex != null) {
			parentVertex.childVertices.add(this);
		}
	}
	
	public String getLineage() {
		String result = clz.getSimpleName();
		
		if (parentVertex != null) {
			result = parentVertex.getLineage() + "." + result; 
		}
		
		return result;
	}
	
	public Set<ProtoVertex> getChildStates() {
		Set<ProtoVertex> result = new HashSet<ProtoVertex>();
		
		for (ProtoVertex v : childVertices) {
			if (State.class.isAssignableFrom(v.clz)) {
				result.add(v);
			}
		}
		
		return result;
	}
}
