package lib.behave.proto;

import lib.asal.ASALContextDecls;
import lib.asal.parsing.*;

public class ProtoTransition {
	public final ProtoVertex sourceState;
	public final ProtoVertex targetState;
	public final String[] code;
	public final boolean isLocal;
	
	public ProtoTransition(ProtoVertex sourceState, ProtoVertex targetState, String[] code, boolean isLocal) {
		this.sourceState = sourceState;
		this.targetState = targetState;
		this.code = code;
		this.isLocal = isLocal;
	}
	
	public DeuteroTransition parse(ASALContextDecls context, boolean isInitCode) throws ASALException {
		try {
			ASALTokens tokens = new ASALTokens(code);
			ASALSyntaxTree tree = tokens.applyRule("TRANSITION");
			DeuteroTransition result = tree.createAPI(null, DeuteroTransition.class);
			result.validate(context, isInitCode);
			return result;
		} catch (ASALException e) {
			throw new ASALException("Could not accept the following transition code:", code, e);
		}
	}
	
	@Override
	public String toString() {
		String result = "";
		
		if (sourceState != null) {
			result += "[" + sourceState.clz.getCanonicalName() + "]";
		} else {
			result += "[??]";
		}
		
		result += "---->";
		
		if (targetState != null) {
			result += "[" + targetState.clz.getCanonicalName() + "]";
		} else {
			result += "[??]";
		}
		
		return result;
	}
}
