package lib.behave.proto;

import lib.asal.ASALContextDecls;
import lib.asal.parsing.ASALSyntaxTree;
import lib.asal.parsing.ASALSyntaxTreeAPI;
import lib.asal.parsing.api.*;
import lib.utils.LOD;
import lib.asal.parsing.ASALException;

public class DeuteroTransition extends ASALSyntaxTreeAPI {
	private DeuteroVertex sourceVertex;
	private DeuteroVertex targetVertex;
	private ASALEvent event;
	private ASALExpr guard;
	private ASALStatement statement;
	private boolean isLocal;
	
	public DeuteroTransition(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		event = createAPI("event", ASALEvent.class, true);
		guard = createAPI("guard", ASALExpr.class, true);
		statement = createAPI("statement", ASALStatement.class, false);
	}
	
	public void setSourceVertex(DeuteroVertex sourceVertex) {
		this.sourceVertex = sourceVertex;
	}
	
	public void setTargetVertex(DeuteroVertex targetVertex) {
		this.targetVertex = targetVertex;
	}
	
	public void setIsLocal(boolean isLocal) {
		this.isLocal = isLocal;
	}
	
	public boolean interruptsCompositeStates() {
		return event instanceof ASALTrigger || event instanceof ASALTimeout;
	}
	
	public ASALEvent getEvent() {
		return event;
	}
	
	public ASALExpr getGuard() {
		return guard;
	}
	
	public ASALStatement getStatement() {
		return statement;
	}
	
	public DeuteroVertex getSourceVertex() {
		return sourceVertex;
	}
	
	public DeuteroVertex getTargetVertex() {
		return targetVertex;
	}
	
	public boolean isLocal() {
		return isLocal;
	}
	
	@Override
	public void validate(ASALContextDecls context, boolean isInitCode) throws ASALException {
		if (event != null) {
			event.validate(context);
		}
		
		if (guard != null) {
			guard.validate(context);
			
			if (!guard.getType(context).isBooleanType) {
				throw new ASALException("Invalid data type", guard);
			}
		}
		
		statement.validate(context, isInitCode);
	}
	
	@Override
	public String textify(LOD lod) {
		String result = "";
		
		if (event != null) {
			result += event.textify(lod);
		}
		
		if (guard != null) {
			result += "[ " + guard.textify(lod) + " ]\n";
		}
		
		result += "/";
		
		if (statement != null) {
			result += " " + statement.textify(lod);
		}
		
		return result;
	}
}
