package lib.behave;

import java.util.*;

import lib.asal.*;

public class Function extends CodeObject {
	private List<String> paramNames;
	private List<Variable> paramDecls;
	private Map<String, Variable> paramDeclPerName;
	private ASALDataType returnType;
	
	public Function(ASALDataType returnType, String code0, String... code) {
		super(code0, code);
		
		paramNames = new ArrayList<String>();
		paramDecls = new ArrayList<Variable>();
		paramDeclPerName = new HashMap<String, Variable>();
		
		this.returnType = returnType;
	}
	
	public List<String> getParamNames() {
		return Collections.unmodifiableList(paramNames);
	}
	
	public List<Variable> getParamDecls() {
		return Collections.unmodifiableList(paramDecls);
	}
	
	public ASALDataType getReturnType() {
		return returnType;
	}
	
	public Function addParam(String paramName, ASALDataType paramType) {
		if (paramDeclPerName.containsKey(paramName)) {
			throw new Error("Parameter name \"" + paramName + "\" is already in use!");
		}
		
		Variable paramDecl = new Variable(paramType);
		paramDeclPerName.put(paramName, paramDecl);
		paramNames.add(paramName);
		paramDecls.add(paramDecl);
		return this;
	}
	
	public List<ASALVariable<?>> createParams() {
		List<ASALVariable<?>> result = new ArrayList<ASALVariable<?>>();
		
		for (int index = 0; index < paramNames.size(); index++) {
			result.add(new ASALVariableImpl<Object>(paramNames.get(index), paramDecls.get(index), ASALVarOrigin.FCT_PARAM));
		}
		
		return Collections.unmodifiableList(result);
	}
	
	public ASALContextDecls createContext(ASALContextDecls nestingContext) {
		return new FctContextDecls(this, nestingContext);
	}
	
	private static class FctContextDecls implements ASALContextDecls {
		private final Function function;
		private final ASALContextDecls nestingContext;
		
		private FctContextDecls(Function function, ASALContextDecls nestingContext) {
			this.function = function;
			this.nestingContext = nestingContext;
		}
		
		@Override
		public Variable getWritableVariableDecl(String name) {
			Variable result = function.paramDeclPerName.get(name);
			
			if (result != null) {
				return result;
			}
			
			return nestingContext.getWritableVariableDecl(name);
		}
		
		@Override
		public Variable getVariableDecl(String name) {
			return nestingContext.getVariableDecl(name);
		}
		
		@Override
		public Function getFunctionDecl(String name) {
			return nestingContext.getFunctionDecl(name);
		}
		
		@Override
		public String getScopeSuggestions() {
			return null;
		}
	}
}
