package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALWhileStatement extends ASALStatement {
	private ASALExpr condition;
	private ASALStatement body;
	
	public ASALWhileStatement(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		condition = createAPI("condition", ASALExpr.class, false);
		body = createAPI("body", ASALStatement.class, false);
	}
	
	public ASALExpr getCondition() {
		return condition;
	}
	
	public ASALStatement getBody() {
		return body;
	}
	
	@Override
	public void validate(ASALContextDecls context, boolean isInitCode) throws ASALException {
		condition.validate(context);
		
		if (!condition.getType(context).isBooleanType) {
			throw new ASALException("Invalid data type", condition);
		}
		
		body.validate(context, isInitCode);
	}
	
	@Override
	public String textify(LOD lod) {
		String result = "while " + condition.textify(lod) + " do\n";
		result += body.textify(lod) + "\n";
		return result + "end while";
	}
}
