package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.behave.Variable;
import lib.utils.LOD;

public class ASALVarRef extends ASALExpr {
	private String varName;
	
	public ASALVarRef(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		varName = tree.getPropery("ref");
	}
	
	public String getVarName() {
		return varName;
	}
	
	public Variable resolveVarDecl(ASALContextDecls context) throws ASALException {
		Variable result = context.getVariableDecl(varName);
		
		if (result == null) {
			throw new ASALException("Unknown variable", this, context.getScopeSuggestions());
		}
		
		return result;
	}
	
	public ASALVariable<?> resolveVar(ASALContext context) {
		ASALVariable<?> result = context.getVariable(varName);
		
		if (result == null) {
			throw new Error("Should not happen; unknown variable named \"" + varName + "\"!");
		}
		
		return result;
	}
	
	@Override
	public ASALDataType getType(ASALContextDecls context) throws ASALException {
		return resolveVarDecl(context).getType();
	}
	
	@Override
	public ASALDataType getType(ASALContext context) throws ASALException {
		return resolveVar(context).getType();
	}

	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		resolveVarDecl(context);
	}
	
	@Override
	public String textify(LOD lod) {
		return lod.abbreviate(varName);
	}
}
