package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALUnaryExpr extends ASALExpr {
	private ASALExpr expr;
	private String op;
	
	public ASALUnaryExpr(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		expr = createAPI("expr", ASALExpr.class, false);
		op = tree.getFirstToken().text;
	}
	
	public ASALUnaryExpr(ASALExpr expr, String op) {
		super(expr.getParent(), expr.getTree());
		
		this.expr = expr.getTree().createAPI(this, ASALExpr.class);
		this.op = op;
	}
	
	public ASALExpr getExpr() {
		return expr;
	}
	
	public String getOp() {
		return op;
	}
	
	@Override
	public ASALDataType getType(ASALContextDecls context) {
		switch (op) {
			case "+":
			case "-":
				return ASALDataType.NUMBER;
			case "not":
				return ASALDataType.BOOLEAN;
		}
		
		throw new Error("Should not happen!");
	}
	
	@Override
	public ASALDataType getType(ASALContext context) {
		switch (op) {
			case "+":
			case "-":
				return ASALDataType.NUMBER;
			case "not":
				return ASALDataType.BOOLEAN;
		}
		
		throw new Error("Should not happen!");
	}
	
	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		expr.validate(context);
		
		switch (op) {
			case "+":
			case "-":
				if (expr.getType(context) != ASALDataType.NUMBER) {
					throw new ASALException("Invalid operand type", expr);
				}
				
				return;
			case "!":
				if (expr.getType(context).isBooleanType) {
					throw new ASALException("Invalid operand type", expr);
				}
				
				return;
		}
	}
	
	@Override
	public String textify(LOD lod) {
		return op + " " + expr.textify(lod);
	}
}
