package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALTrigger extends ASALEvent {
	private ASALExpr expr;
	
	public ASALTrigger(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		expr = createAPI("expr", ASALExpr.class, false);
	}
	
	public ASALExpr getExpr() {
		return expr;
	}
	
	@Override
	public String textify(LOD lod) {
		return "when(" + expr.textify(lod) + ")";
	}
	
	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		expr.validate(context);
		
		if (!expr.getType(context).isBooleanType) {
			throw new ASALException("Invalid data type", expr);
		}
	}
}
