package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALTimeout extends ASALEvent {
	private ASALExpr duration;
	
	public ASALTimeout(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		duration = createAPI("duration", ASALExpr.class, false);
	}
	
	public ASALExpr getDuration() {
		return duration;
	}
	
	@Override
	public String textify(LOD lod) {
		return "after(" + duration.textify(lod) + ")";
	}
	
	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		duration.validate(context);
		
		if (duration.getType(context) != ASALDataType.NUMBER) {
			throw new ASALException("Invalid data type", duration);
		}
	}
}
