package lib.asal.parsing.api;

import java.util.*;

import lib.asal.ASALContextDecls;
import lib.asal.parsing.ASALSyntaxTree;
import lib.asal.parsing.ASALSyntaxTreeAPI;
import lib.utils.LOD;
import lib.asal.parsing.ASALException;

public class ASALSeqStatement extends ASALStatement {
	private ASALStatement statement;
	private ASALStatement successor;
	
	public ASALSeqStatement(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		statement = createAPI("statement", ASALStatement.class, false);
		successor = createAPI("successor", ASALStatement.class, false);
	}
	
	private ASALSeqStatement(ASALStatement statement, ASALStatement successor) {
		super(statement.getParent(), statement.getTree());
		
		this.statement = statement.getTree().createAPI(this, ASALStatement.class);
		this.successor = successor.getTree().createAPI(this, ASALStatement.class);
	}
	
	public ASALStatement getStatement() {
		return statement;
	}
	
	public ASALStatement getSuccessor() {
		return successor;
	}
	
	@Override
	public void validate(ASALContextDecls context, boolean isInitCode) throws ASALException {
		statement.validate(context, isInitCode);
		successor.validate(context, isInitCode);
	}
	
	@Override
	public String textify(LOD lod) {
		return statement.textify(lod) + "\n" + successor.textify(lod);
	}
	
	public static ASALStatement from(ASALStatement first, ASALStatement second) {
		if (first instanceof ASALEmptyStatement) {
			return second;
		}
		
		if (second instanceof ASALEmptyStatement) {
			return first;
		}
		
		if (first instanceof ASALSeqStatement) {
			if (((ASALSeqStatement)first).successor instanceof ASALEmptyStatement) {
				return new ASALSeqStatement(((ASALSeqStatement)first).statement, second);
			}
		}
		
		return new ASALSeqStatement(first, second);
	}
	
	public static ASALStatement fromList(List<ASALStatement> statements) {
		//List<ASALStatement> stats = toList(statements);
		List<ASALStatement> stats = statements;
		
		switch (stats.size()) {
			case 0:
				throw new Error("List must contain at least 1 statement!");
			case 1:
				return stats.get(0);
			default:
				ASALStatement result = stats.get(0);
				
				for (int index = 1; index < stats.size(); index++) {
					result = from(result, stats.get(index));
				}
				
				return result;
		}
	}
}
