package lib.asal.parsing.api;

import java.util.*;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALSeqExpr extends ASALExpr {
	private ASALExpr expr;
	private ASALSeqExpr tail;
	
	public ASALSeqExpr(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		expr = createAPI("expr", ASALExpr.class, false);
		tail = createAPI("tail", ASALSeqExpr.class, true);
	}
	
	public ASALExpr getExpr() {
		return expr;
	}
	
	public ASALSeqExpr getTail() {
		return tail;
	}
	
	public List<ASALExpr> getList() {
		List<ASALExpr> result = new ArrayList<ASALExpr>();
		ASALSeqExpr current = tail;
		
		while (current != null) {
			result.add(current.expr);
			current = current.tail;
		}
		
		return Collections.unmodifiableList(result);
	}
	
	@Override
	public ASALDataType getType(ASALContextDecls context) throws ASALException {
		throw new Error("Expression lists do not have a type!");
	}
	
	@Override
	public ASALDataType getType(ASALContext context) throws ASALException {
		throw new Error("Expression lists do not have a type!");
	}
	
	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		expr.validate(context);
		
		if (tail != null) {
			tail.validate(context);
		}
	}
	
	@Override
	public String textify(LOD lod) {
		if (tail != null) {
			return expr.textify(lod) + ", " + tail.textify(lod);
		}
		
		return expr.textify(lod);
	}
}
