package lib.asal.parsing.api;

import lib.asal.ASALContextDecls;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALReturnStatement extends ASALStatement {
	private ASALExpr expression;
	
	public ASALReturnStatement(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		expression = createAPI("expr", ASALExpr.class, false);
	}
	
	public ASALExpr getExpression() {
		return expression;
	}
	
	@Override
	public void validate(ASALContextDecls context, boolean isInitCode) throws ASALException {
		expression.validate(context);
	}
	
	@Override
	public String textify(LOD lod) {
		return "return " + expression.textify(lod) + ";";
	}
}
