package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALLiteral extends ASALExpr {
	private String text;
	private ASALDataType type;
	
	public ASALLiteral(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		this(parent, tree, tree.getFirstToken());
	}
	
	public ASALLiteral(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree, ASALToken token) {
		this(parent, tree, token.text, token.type);
	}
	
	public ASALLiteral(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree, String tokenText, ASALTokenType tokenType) {
		super(parent, tree);
		
		text = tokenText;
		
		switch (tokenType) {
			case BOOLEAN_LITERAL:
				type = ASALDataType.BOOLEAN;
				break;
			case NUMBER_LITERAL:
				type = ASALDataType.NUMBER;
				break;
			case STRING_LITERAL:
				type = ASALDataType.STRING;
				break;
			default:
				throw new Error("Should not happen!");
		}
	}
	
	public ASALLiteral(int i) {
		super(null,null);
		text = Integer.toString(i);
		type = ASALDataType.NUMBER;
	}
	
	public ASALLiteral(String s) {
		super(null,null);
		text = s;
		type = ASALDataType.STRING;
	}
	
	public ASALLiteral(Boolean b) {
		super(null,null);
		text = b ? "True" : "False";
		type = ASALDataType.BOOLEAN;
	}
	
	public String getText() {
		return text;
	}
	
	@Override
	public ASALDataType getType(ASALContextDecls context) {
		return type;
	}
	
	public ASALDataType getType() {
		return type;
	}
	
	@Override
	public ASALDataType getType(ASALContext context) {
		return type;
	}
	
	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		//Do nothing.
	}
	
	@Override
	public String textify(LOD lod) {
		return text;
	}
}
