package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.utils.LOD;

public class ASALIfStatement extends ASALStatement {
	private ASALExpr condition;
	private ASALStatement thenBranch;
	private ASALStatement elseBranch;
	
	public ASALIfStatement(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		condition = createAPI("condition", ASALExpr.class, false);
		thenBranch = createAPI("thenBranch", ASALStatement.class, false);
		elseBranch = createAPI("elseBranch", ASALStatement.class, true);
	}
	
	public ASALExpr getCondition() {
		return condition;
	}
	
	public ASALStatement getThenBranch() {
		return thenBranch;
	}
	
	public ASALStatement getElseBranch() {
		return elseBranch;
	}
	
	@Override
	public void validate(ASALContextDecls context, boolean isInitCode) throws ASALException {
		condition.validate(context);
		
		if (!condition.getType(context).isBooleanType) {
			throw new ASALException("Invalid data type", condition);
		}
		
		thenBranch.validate(context, isInitCode);
		
		if (elseBranch != null) {
			elseBranch.validate(context, isInitCode);
		}
	}
	
	@Override
	public String textify(LOD lod) {
		String result = "if " + condition.textify(lod) + " then\n";
		result += thenBranch.textify(lod) + "\n";
		
		if (elseBranch != null) {
			result += "else\n" + elseBranch.textify(lod) + "\n";
		}
		
		return result + "end if";
	}
}
