package lib.asal.parsing.api;

import lib.asal.*;
import lib.asal.parsing.*;
import lib.behave.Function;
import lib.utils.LOD;

public class ASALCall extends ASALEvent {
	private String methodName;
	
	public ASALCall(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		methodName = tree.get("methodName").getFirstToken().text;
	}
	
	public String getMethodName() {
		return methodName;
	}
	
	public Function resolveFunctionDecl(ASALContextDecls context) throws ASALException {
		Function result = context.getFunctionDecl(methodName);
		
		if (result == null) {
			throw new ASALException("Unknown method", this, context.getScopeSuggestions());
		}
		
		return result;
	}
	
	public ASALFunction resolveFunction(ASALContext context) {
		return context.getFunction(methodName);
	}
	
	@Override
	public String textify(LOD lod) {
		return methodName;
	}
	
	@Override
	public void validate(ASALContextDecls context) throws ASALException {
		resolveFunctionDecl(context);
	}
}
