package lib.asal.parsing.api;

import lib.asal.ASALContext;
import lib.asal.ASALContextDecls;
import lib.asal.ASALVariable;
import lib.asal.parsing.*;
import lib.behave.Variable;
import lib.utils.LOD;

public class ASALAssignStatement extends ASALStatement {
	private String varName;
	private ASALExpr expression;
	
	public ASALAssignStatement(ASALSyntaxTreeAPI parent, ASALSyntaxTree tree) {
		super(parent, tree);
		
		varName = tree.getPropery("ref");
		expression = createAPI("expr", ASALExpr.class, false);
	}
	
	public String getVarName() {
		return varName;
	}
	
	public ASALExpr getExpression() {
		return expression;
	}
	
	public Variable resolveVarDecl(ASALContextDecls context, boolean isInitCode) throws ASALException {
		Variable result;
		
		if (isInitCode) {
			result = context.getVariableDecl(varName);
		} else {
			result = context.getWritableVariableDecl(varName);
		}
		
		if (result == null) {
			throw new ASALException("Unknown variable", this, context.getScopeSuggestions());
		}
		
		return result;
	}
	
	public ASALVariable<?> resolveVar(ASALContext context) {
		ASALVariable<?> result = context.getWritableVariable(varName);
		
		if (result == null) {
			throw new Error("Should not happen; unknown variable named \"" + varName + "\"!");
		}
		
		return result;
	}
	
	@Override
	public void validate(ASALContextDecls context, boolean isInitCode) throws ASALException {
		Variable var = resolveVarDecl(context, isInitCode);
		expression.validate(context);
		
		if (!expression.getType(context).isAssignableTo(var.getType())) {
			throw new ASALException("Data type mismatch", expression);
		}
	}
	
	@Override
	public String textify(LOD lod) {
		return lod.abbreviate(varName) + " := " + expression.textify(lod) + ";";
	}
}
