package lib.asal.parsing;

import java.util.*;

public class ASALTokens {
	private String[] code;
	private List<ASALToken> tokens;
	
	public ASALTokens(String... code) {
		this.code = code;
		this.tokens = ASALToken.tokenize(code);
	}
	
	public ASALTokens(ASALTokens source) {
		code = source.code;
		tokens = new ArrayList<ASALToken>(source.tokens);
	}
	
	public ASALSyntaxTree applyRule(String ruleName) throws ASALException {
		ASALRuleOpportunities missedOpportunities = new ASALRuleOpportunities();
		ASALRuleApplication app = ASALRules.SINGLETON.applyRule(ruleName, this, missedOpportunities, null);
		
		if (app != null) {
			tokens.clear();
			tokens.addAll(app.getTokens().tokens);
			return app.getTree();
		}
		
		throw new ASALException("Could not parse the following code:", code, missedOpportunities.getSuggestions(""));
	}
	
	public boolean hasNext() {
		return tokens.get(0).type != ASALTokenType.EOF;
	}
	
	public ASALToken next() {
		if (hasNext()) {
			return tokens.remove(0);
		}
		
		return tokens.get(0);
	}
	
	public String getFirstStr() {
		return tokens.get(0).toString();
	}
	
	public void print() {
		for (ASALToken token : tokens) {
			System.out.println(token.toString());
		}
	}
}
